package com.biz.crm.integral.service.component;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.common.param.RedisParam;
import com.biz.crm.eunm.sfa.IntegralEnum;
import com.biz.crm.integral.controller.SfaIntegralSaveUtil;
import com.biz.crm.integral.req.SfaIntegralDetailAddReq;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.mdm.position.req.MdmPositionPageReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionPageRespVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaMonthSignReqVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaMonthSignRespVo;
import com.biz.crm.util.*;
import com.biz.crm.visitinfo.model.SfaVisitCompleteInfoEntity;
import com.biz.crm.visitinfo.service.ISfaVisitCompleteInfoService;
import com.biz.crm.worksign.service.ISfaSignFormsService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;


/**
 * 月度积分任务执行器
 *  @author: luoqi
 *  @Date: 2021-5-21 12:43
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
@Component
@ConditionalOnMissingBean(name = "sfaIntegralMonthJobExecutorExtend")
public class SfaIntegralMonthJobExecutor implements JobHelper.JobExecutor {
    @Resource
    private MdmPositionFeign mdmPositionFeign;
    @Resource
    private ISfaSignFormsService sfaSignFormsService;
    @Resource
    private ISfaVisitCompleteInfoService sfaVisitCompleteInfoService;
    @Resource
    private JobHelper jobHelper;

    @Override
    @Transactional
    public void executeJob(Object jobParam) {
        this.doSettlementJob((String) jobParam);
    }
    /**
     * 启动任务
     * @param yearMonth
     */
    public void integralDetailJob(String yearMonth){
        if (StringUtils.isEmpty(yearMonth)){
            LocalDate yearMonthDate = LocalDate.now().plusMonths(-1);
            yearMonth = yearMonthDate.format(CrmDateUtils.yyyyMM);
        }else{
            CrmDateUtils.checkTimeFormatThrows(yearMonth, CrmDateUtils.yyyyMM, null);
        }
        JobHelper.JobContext context = new JobHelper.JobContext();
        context.setJob(JobHelper.Job.INTEGRAL_MONTH_JOB);
        context.setExecutorBeanClass(SfaIntegralMonthJobExecutor.class);
        context.setJobParam(yearMonth);
        this.jobHelper.executeJobSaveContext(context);
    }

    /**
     * 执行积分计算任务
     */
    protected void doSettlementJob(String yearMonth){
        PageDataAdviser pageDataAdviser = new PageDataAdviser(jobHelper.getJobBizDataPageSize());
        long total = jobHelper.getJobBizDataPageSize();
        while (true){
            if(pageDataAdviser.hasNext(total)){
                MdmPositionPageReqVo reqVo = new MdmPositionPageReqVo();
                reqVo.setPageNum(pageDataAdviser.nextPage());
                reqVo.setPageSize(pageDataAdviser.getPageSize());
                PageResult<MdmPositionPageRespVo> pageResult =  ApiResultUtil.objResult(this.mdmPositionFeign.positionAndUserPage(reqVo), true);
                List<MdmPositionPageRespVo> users = pageResult.getData();
                this.doIntegral(yearMonth, users);
                total = pageResult.getCount();
            }else {
                break;
            }
        }
    }

    /**
     * 发送mq
     * @param userList
     */
    private void doIntegral(String yearMonth, List<MdmPositionPageRespVo> userList){
        Map<String, List<String>> userMapPositions = userList.stream().collect(Collectors.groupingBy(MdmPositionPageRespVo :: getUserName, Collectors.mapping(MdmPositionPageRespVo :: getPositionCode, Collectors.toList())));
        //月考勤打卡完成积分
        this.signMonthIntegral(yearMonth, userMapPositions);
        //月拜访、协访完成积分
        this.visitMonthIntegral(yearMonth, userMapPositions);

    }


    /**
     * 月考勤打卡完成积分
     * @return
     */
    protected void signMonthIntegral(String yearMonth, Map<String, List<String>> userMapPositions){
        SfaMonthSignReqVo sfaMonthSignReqVo = new SfaMonthSignReqVo();
        sfaMonthSignReqVo.setUserNameList(Lists.newArrayList(userMapPositions.keySet()));
        sfaMonthSignReqVo.setYearMonth(yearMonth);
        List<SfaMonthSignRespVo> sfaMonthSignRespVos = sfaSignFormsService.monthSignListByUsers(sfaMonthSignReqVo);
        if (null == sfaMonthSignRespVos){
            return;
        }
        for (SfaMonthSignRespVo sfaMonthSignRespVo : sfaMonthSignRespVos) {
            //需要上班天数
            BigDecimal goToWorkDays = sfaMonthSignRespVo.getGoToWorkDays();
            //正常出勤
            BigDecimal normal = sfaMonthSignRespVo.getNormal();
            //当月需要上班天数必须大于0，才加入计分
            if(goToWorkDays.compareTo(BigDecimal.ZERO) > 0
                    && goToWorkDays.compareTo(normal) == 0){
                SfaIntegralDetailAddReq integralDetailAddReq = new SfaIntegralDetailAddReq();
                String integralTaskType = IntegralEnum.taskType.MONTH_SIGN.getValue();
                String userName = sfaMonthSignRespVo.getUserName();
                // 月考勤打卡完成积分业务id  integralTaskType + userName + 年月
                integralDetailAddReq.setBizId(integralTaskType + userName + yearMonth);
                integralDetailAddReq.setIntegralTaskType(integralTaskType);
                List<String> posCodes = userMapPositions.get(userName);
                String posCode = CollectionUtils.isEmpty(posCodes) ? userName : posCodes.get(0);
                integralDetailAddReq.setPosCode(posCode);
                integralDetailAddReq.setUserName(userName);
                integralDetailAddReq.setExtParam(null);
                //新增积分
                SfaIntegralSaveUtil.saveIntegralDetail(integralDetailAddReq);
            }
        }

    }

    /**
     * 月拜访、协访完成积分
     * @param yearMonth
     * @param userMapPositions
     */
    protected void visitMonthIntegral(String yearMonth, Map<String, List<String>> userMapPositions){
        List<SfaVisitCompleteInfoEntity> list = this.sfaVisitCompleteInfoService.list(Wrappers.lambdaQuery(SfaVisitCompleteInfoEntity.class)
                .in(SfaVisitCompleteInfoEntity::getVisitUserName, Lists.newArrayList(userMapPositions.keySet()))
                .eq(SfaVisitCompleteInfoEntity::getVisitYearMonth, yearMonth));
        if (CollectionUtil.listEmpty(list)){
            return;
        }
        final String completedTag = "100.00";
        //按用户职位分组计算
        Map<String, List<SfaVisitCompleteInfoEntity>> userVisitData = list.stream().collect(Collectors.groupingBy(v -> v.getVisitUserName() + RedisParam.DELIMITER + v.getVisitPosCode()));
        SfaIntegralDetailAddReq integralDetailAddReq = new SfaIntegralDetailAddReq();
        userVisitData.forEach((s, sfaVisitCompleteInfoEntities) -> {
            boolean completedHelpVisit = true, completedVisit = true;
            String userName = null, posCode = null;
            //该用户职位下当月 拜访、协访报表数据
            for (SfaVisitCompleteInfoEntity sfaVisitCompleteInfoEntity : sfaVisitCompleteInfoEntities) {
                if(!completedTag.equals(sfaVisitCompleteInfoEntity.getCompleteHelpVisitPercent())){
                    completedHelpVisit = false;
                }
                if(!completedTag.equals(sfaVisitCompleteInfoEntity.getCompleteVisitPercent())){
                    completedVisit = false;
                }
                userName = sfaVisitCompleteInfoEntity.getVisitUserName();
                posCode = sfaVisitCompleteInfoEntity.getVisitPosCode();
            }
            if(completedHelpVisit){
                //月协访计划完成
                this.visitMonthIntegralAdd(integralDetailAddReq, userName, posCode, yearMonth, IntegralEnum.taskType.FINISH_VISIT_HELP_PLAN);
            }

            if(completedVisit){
                //月拜访计划完成
                this.visitMonthIntegralAdd(integralDetailAddReq, userName, posCode, yearMonth, IntegralEnum.taskType.FINISH_VISIT_PLAN);
            }

        });
    }

    protected void visitMonthIntegralAdd(SfaIntegralDetailAddReq integralDetailAddReq, String userName, String posCode, String yearMonth, IntegralEnum.taskType taskType){

        String integralTaskType = taskType.getValue();
        // 月考勤打卡完成积分业务id  integralTaskType + userName + 年月
        StringJoiner bizId = new StringJoiner(RedisParam.DELIMITER);
        bizId.add(integralTaskType);
        bizId.add(userName);
        bizId.add(posCode);
        bizId.add(yearMonth);
        integralDetailAddReq.setBizId(bizId.toString());
        integralDetailAddReq.setIntegralTaskType(integralTaskType);
        integralDetailAddReq.setPosCode(posCode);
        integralDetailAddReq.setUserName(userName);
        integralDetailAddReq.setExtParam(null);
        //新增积分
        SfaIntegralSaveUtil.saveIntegralDetail(integralDetailAddReq);
    }

}
