package com.biz.crm.integral.service.component;

import com.biz.crm.common.param.RedisParam;
import com.biz.crm.eunm.sfa.IntegralEnum;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.integral.controller.SfaIntegralSaveUtil;
import com.biz.crm.integral.req.SfaIntegralDetailAddReq;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepListener;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.Set;


/**
 *拜访步骤业务积分新增监听
 *  @author: luoqi
 *  @Date: 2021-5-20 12:31
 *  @version: V1.0
 *  @Description:
 */
@Component
public class SfaIntegralStepListener extends AbstractVisitStepListener {
    protected static Map<String, String> stepMappingIntegralTaskType = Maps.newHashMap();
    static {
        stepMappingIntegralTaskType.put(SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_STOCK.getVal()
                , IntegralEnum.taskType.SFA_STEP_CODE_STOCK.getValue());
        stepMappingIntegralTaskType.put(SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_ORDER.getVal()
                , IntegralEnum.taskType.SFA_STEP_CODE_ORDER.getValue());
        stepMappingIntegralTaskType.put(SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_COMPETITOR.getVal()
                , IntegralEnum.taskType.SFA_STEP_CODE_COMPETITOR.getValue());
        stepMappingIntegralTaskType.put(SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_COST.getVal()
                , IntegralEnum.taskType.SFA_STEP_CODE_COST.getValue());
        stepMappingIntegralTaskType.put(SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_DISPLAY.getVal()
                , IntegralEnum.taskType.SFA_STEP_CODE_DISPLAY.getValue());
    }

    /**
     * 拜访步骤监听器注册，
     * 请返回该步骤监听器对应的拜访步骤编码[SfaCodeEnum.VisitStepCode]
     * 如果需要监听全部大类，则返回 SfaVisitEnum.VisitStepCode.LISTENER_ALL
     * @return
     */
    @Override
    protected Set<String> visitStepCodeRegistry() {
        return Sets.newHashSet(
                SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_STOCK.getVal(),
                SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_ORDER.getVal(),
                SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_COMPETITOR.getVal(),
                SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_COST.getVal(),
                SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_DISPLAY.getVal()
        );
    }

    /**
     *  ############## 该事件还未触发,后期实现 ##############
     * 拜访执行，用户有可能反复编辑后提交多次，生成多个事件。
     * 该事件的业务数据完全在redis缓存里操作，不会持久化到数据库
     *
     * @param doneEvent
     */
    @Override
    public void visitDone(VisitStepListenerDoneEvent doneEvent) {

    }

    /**
     * 拜访提交(包括工作台的业务事件)，持久化到数据库（用户有可能会反复编辑，生成多个事件）
     *
     * @param committedEvent
     */
    @Override
//    @Async  不能使用异步注解，会导致使用spring上下文通过class获取bean出问题
    public void committed(VisitStepListenerCommittedEvent committedEvent) {
        List<? extends VisitStepListenerCommittedData> entities = committedEvent.getEntities();
        entities.forEach(entity -> {
            SfaIntegralDetailAddReq reqVo = CrmBeanUtil.copy(entity, SfaIntegralDetailAddReq.class);
            String integralTaskType = stepMappingIntegralTaskType.get(entity.getStepCode());
            reqVo.setBizId(integralTaskType + RedisParam.DELIMITER + entity.getId());
            reqVo.setIntegralTaskType(integralTaskType);
            reqVo.setExtParam(null);
            SfaIntegralSaveUtil.saveIntegralDetail(reqVo);
        });
    }
}
