package com.biz.crm.integral.service.component;

import com.biz.crm.common.param.RedisParam;
import com.biz.crm.eunm.sfa.IntegralEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.integral.controller.SfaIntegralSaveUtil;
import com.biz.crm.integral.req.SfaIntegralDetailAddReq;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitInfoPlanListener;
import com.biz.crm.moblie.controller.visit.req.GetVisitListReq;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoRedisData;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.google.common.collect.Maps;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;


/**
 * 拜访完成监听器-积分新增
 *  @author: luoqi
 *  @Date: 2021-5-20 12:26
 *  @version: V1.0
 *  @Description:
 */
@Component
public class SfaIntegralVisitListener extends AbstractVisitInfoPlanListener {
    protected static Map<String, String> visitBigTypeMappingIntegralTaskType = Maps.newHashMap();
    static {
        visitBigTypeMappingIntegralTaskType.put(SfaVisitEnum.VisitBigType.VISIT.getVal()
                , IntegralEnum.taskType.DAY_VISIT_PLAN.getValue());
        visitBigTypeMappingIntegralTaskType.put(SfaVisitEnum.VisitBigType.HELP_VISIT.getVal()
                , IntegralEnum.taskType.DAY_HELP_VISIT_PLAN.getValue());
    }

    @Resource
    private ISfaVisitPlanInfoService sfaVisitPlanInfoService;
    /**
     * 拜访大类监听器注册
     * 请返回该监听器对应的拜访大类编码[SfaVisitEnum.VisitBigType]
     * 如果需要监听全部大类，则返回 SfaVisitEnum.VisitBigType.LISTENER_ALL
     *
     * @return
     */
    @Override
    protected Set<String> visitBigTypeRegistry() {
        HashSet<String> hashSet = new HashSet<>();
        hashSet.add(SfaVisitEnum.VisitBigType.HELP_VISIT.getVal());
        hashSet.add(SfaVisitEnum.VisitBigType.VISIT.getVal());
        return  hashSet;
    }

    /**
     * 计划生成事件
     *
     * @param event
     */
    @Override
    public void created(VisitInfoPlanListenerEvent event) {

    }

    /**
     * 开始拜访事件
     *
     * @param doneEvent
     */
    @Override
    public void begin(DoneEvent doneEvent) {

    }

    /**
     * 用户提交完成事件(包括异常提报)
     *
     * @param doneEvent
     */
    @Override
    public void committed(DoneEvent doneEvent) {
        SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData = doneEvent.getSfaVisitPlanInfoRedisData();

        if(!SfaVisitEnum.visitType.PLAN_VISIT.getVal().equals(sfaVisitPlanInfoRedisData.getVisitType())){
            //不是计划拜访，跳过
            return;
        }
        if(this.isComplete(doneEvent, sfaVisitPlanInfoRedisData)){
            //日拜访计划完成 新增积分
            SfaIntegralDetailAddReq integralDetailAddReq = new SfaIntegralDetailAddReq();
            String integralTaskType = visitBigTypeMappingIntegralTaskType.get(sfaVisitPlanInfoRedisData.getVisitBigType());
            String userName = sfaVisitPlanInfoRedisData.getVisitUserName(), posCode = sfaVisitPlanInfoRedisData.getVisitPosCode();
            // 日拜访计划完成积分业务id  integralTaskType + userName + 拜访日期
            StringJoiner bizId = new StringJoiner(RedisParam.DELIMITER);
            bizId.add(integralTaskType);
            bizId.add(userName);
            bizId.add(posCode);
            bizId.add(sfaVisitPlanInfoRedisData.getVisitDate());
            integralDetailAddReq.setBizId(bizId.toString());
            integralDetailAddReq.setIntegralTaskType(integralTaskType);
            integralDetailAddReq.setPosCode(posCode);
            integralDetailAddReq.setUserName(userName);
            integralDetailAddReq.setExtParam(null);
            SfaIntegralSaveUtil.saveIntegralDetail(integralDetailAddReq);
        }

    }

    protected boolean isComplete(DoneEvent doneEvent, SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData){

        GetVisitListReq req = new GetVisitListReq();
        req.setVisitPositionCode(sfaVisitPlanInfoRedisData.getVisitPosCode());
        req.setVisitUserName(sfaVisitPlanInfoRedisData.getVisitUserName());
        req.setVisitDate(sfaVisitPlanInfoRedisData.getVisitDate());
        req.setVisitBigType(sfaVisitPlanInfoRedisData.getVisitBigType());
        List<SfaVisitPlanInfoEntity> planInfoEntities = this.sfaVisitPlanInfoService.doGetVisitInfoList(req)
                .stream().filter(//只统计计划拜访
                        v -> SfaVisitEnum.visitType.PLAN_VISIT.getVal().equals(v.getVisitType())
                ).collect(Collectors.toList());
        int complete = SfaVisitPlanInfoEntity.countingCompletedNum(planInfoEntities);
        //未完成计划或没有计划，不计积分
        if(complete != planInfoEntities.size() || planInfoEntities.size() == 0){
            return false;
        }
        return true;
    }



    /**
     * 结算任务，计划未完成事件(拜访中未主动提交数据)
     *
     * @param doneEvent
     */
    @Override
    public void noCommit(DoneEvent doneEvent) {
    }

    /**
     * 结算任务，计划过期事件
     *
     * @param event
     */
    @Override
    public void overdue(VisitInfoPlanListenerEvent event) {
    }
}
