package com.biz.crm.job;

import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignExecuteReqVo;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.UserUtils;
import com.biz.crm.worksignrule.service.ISfaWorkSignRuleService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.time.LocalDate;


/**
 * 考勤规则执行定时任务
 *  @author: luoqi
 *  @Date: 2020-11-12 15:29
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
@Component
public class SfaWorkSignRuleJob {
    @Resource
    private ISfaWorkSignRuleService sfaWorkSignRuleService;


//    @Scheduled(cron = "0 30 0 * * ?")
    public void executeWorkSignRule(){
        log.warn("#########################考勤规则任务开始#########################");
        UserUtils.doTokenForNull();
        SfaWorkSignExecuteReqVo reqVo = new SfaWorkSignExecuteReqVo();
        reqVo.setExecuteDate(LocalDate.now().format(CrmDateUtils.yyyyMMdd));
        sfaWorkSignRuleService.executeWorkSignRule(reqVo);
        log.warn("#########################考勤规则任务结束#########################");
    }
}
