package com.biz.crm.map.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.map.model.SfaTencentMapDataEntity;
import com.biz.crm.map.model.req.SfaCoordinatesDetermineReqVO;
import com.biz.crm.map.model.req.SfaSalesFenceReqVO;
import com.biz.crm.map.model.req.SfaTencentMapData;
import com.biz.crm.map.model.resp.SfaTencentMapDataRespVo;
import com.biz.crm.map.service.SfaTencentMapDataService;
import com.biz.crm.map.util.TencentMapDataConvert;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author yangshan
 * @date 2021/4/14 21:16
 */
@RestController
@RequestMapping("/tencentMapData")
@Api(tags = "腾讯地图写入数据")
public class SfaTencentMapDataController {

    @Resource
    private SfaTencentMapDataService sfaTencentMapDataService;

    @ApiOperation(value = "列表")
    @PostMapping("/findList")
    @CrmLog
    public Result<PageResult<SfaTencentMapDataRespVo>> findList(@RequestBody SfaTencentMapData.SfaTencentMapDataReqVo reqVo){
        return Result.ok(sfaTencentMapDataService.findList(reqVo));
    }

    @ApiOperation(value = "新增")
    @PostMapping("/save")
    public Result save(@RequestBody SfaTencentMapData reqVo){
        TencentMapDataConvert convert = new TencentMapDataConvert();
        List<SfaTencentMapDataEntity> req = reqVo.getData().stream().map(convert::convert).collect(Collectors.toList());
        sfaTencentMapDataService.save(req);
        return sfaTencentMapDataService.saveTxMapData(reqVo);
    }

    @ApiOperation(value = "终端坐标判定")
    @PostMapping("/qryCoordinatesDetermine")
    @CrmLog
    public Result qrySalesConsultantFence(@RequestBody SfaCoordinatesDetermineReqVO reqVO){
        return sfaTencentMapDataService.qrySalesConsultantFence(reqVO);
    }

    @ApiOperation(value = "销售片区经纬")
    @PostMapping("/qrySalesFence")
    @CrmLog
    public Result<List<String>> qrySalesFence(@RequestBody SfaSalesFenceReqVO reqVO){
        return sfaTencentMapDataService.qrySalesFence(reqVO);
    }



}
