package com.biz.crm.map.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.elasticsearch.annotations.GeoPointField;

/**
 *
 * @author yangshan
 * @date 2021/4/14 20:46
 */
@Data
@TableName("sfa_tencent_map_data")
@CrmTable(name = "sfa_tencent_map_data", tableNote = "地图数据")
public class SfaTencentMapDataEntity extends CrmExtTenEntity {

    @CrmColumn(name = "map_id", length = 64, note = "地图唯一id")
    private String mapId;

    @CrmColumn(name = "code", length = 64, note = "编码")
    private String code;

    @CrmColumn(name = "name", length = 64, note = "名称")
    private String name;

    @CrmColumn(name = "channel", length = 64, note = "渠道")
    private String channel;

    @CrmColumn(name = "city_code", length = 64, note = "城市")
    private String cityCode;

    @CrmColumn(name = "district_code", length = 64, note = "区县")
    private String districtCode;

    @CrmColumn(name = "province_code", length = 64, note = "省份")
    private String provinceCode;

    @CrmColumn(name = "longitude", length = 64, note = "经度")
    private String longitude;

    @CrmColumn(name = "latitude", length = 64, note = "纬度")
    private String latitude;

    @CrmColumn(name = "address", length = 64, note = "地址")
    private String address;

    @CrmColumn(name = "contact_name", length = 64, note = "终端/客户主联系人姓名")
    private String contactName;

    @CrmColumn(name = "contact_phone", length = 64, note = "终端/客户联系方式")
    private String contactPhone;

    @CrmColumn(name = "position_codes", length = 64, note = "终端：供货关系职位编码集合；客户：对接人职位编码集合。都是按照;分割")
    private String positionCodes;

    @CrmColumn(name = "client_type", length = 64, note = "大类")
    private String clientType;

    @CrmColumn(name = "client_type_name", length = 64, note = "网点类型名称")
    private String clientTypeName;

    @CrmColumn(name = "client_subclass", length = 64, note = "细类")
    private String clientSubclass;

    @CrmColumn(name = "client_Subclass_name", length = 64, note = "客户细类")
    private String clientSubclassName;

    @CrmColumn(name = "busi_label", length = 64, note = "商圈标签")
    private String busiLabel;

    @CrmColumn(name = "busi_type", length = 64, note = "业态")
    private String busiType;

}
