package com.biz.crm.map.model.req;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @description: 销售坐标判定请求VO
 * @author: heJie by 2021/11/18 12:19
 */
@Data
@ApiModel("销售坐标判定请求VO")
public class SfaCoordinatesDetermineReqVO implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("省")
    private String province;
    @ApiModelProperty("市")
    private String city;
    @ApiModelProperty("区县")
    private String district;
    @ApiModelProperty("坐标")
    private Location location;
    @ApiModelProperty(value = "用户key",hidden = true)
    private String key;

    @ApiModelProperty("销售顾问code")
    private String salesConsultantOffline;

    @ApiModelProperty("网点编码")
    private String clientCode;

    @Data
    public static class Location {
        @ApiModelProperty("经度")
        private String lng;
        @ApiModelProperty("纬度")
        private String lat;
    }
}
