package com.biz.crm.map.model.req;

import com.biz.crm.map.util.MapDataConvert;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author yangshan
 * @date 2021/4/14 21:23
 */
@Data
@ApiModel(value = "SfaTencentMapData", description = "腾讯地图客户数据 ")
public class SfaTencentMapData extends MapDataConvert.MapData {

    private List<SfaTencentMapDataReqVo> data;

    @Data
    public static class SfaTencentMapDataReqVo extends MapDataConvert.MapData {

        @ApiModelProperty("售点ID")
        private String poiId;

        @ApiModelProperty("售点名称")
        private String poiTitle;

        @ApiModelProperty("售点地址")
        private String poiAddress;

        @ApiModelProperty("省份")
        private String province;

        @ApiModelProperty("城市")
        private String city;

        @ApiModelProperty("区县")
        private String district;

        @ApiModelProperty("商圈标签")
        private String busiLabel;

        @ApiModelProperty("经度")
        private String lng;

        @ApiModelProperty("纬度")
        private String lat;

        @ApiModelProperty("渠道")
        private String channel;

        @ApiModelProperty("业态")
        private String busiType;

        @ApiModelProperty("数量")
        private Integer pageSize=25;

        @ApiModelProperty("页码")
        private Integer pageNum=0;


        @ApiModelProperty("品牌编码")
        private String brandId;

        @ApiModelProperty("品牌名称")
        private String brandName;

        @ApiModelProperty("业务员编码")
        private String userName;

        @ApiModelProperty("业务员编码")
        private String userId;

        @ApiModelProperty("分组编码")
        private String groupCode;

        @ApiModelProperty("分组名称")
        private String groupName;

        @ApiModelProperty("分组包含新客数量")
        private String size;

        @ApiModelProperty("走访时间")
        private String duration;

        @ApiModelProperty("距离")
        private String distance;


    }
}
