package com.biz.crm.map.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.map.model.SfaTencentMapDataEntity;
import com.biz.crm.map.model.req.SfaCoordinatesDetermineReqVO;
import com.biz.crm.map.model.req.SfaSalesFenceReqVO;
import com.biz.crm.map.model.req.SfaTencentMapData;
import com.biz.crm.map.model.resp.SfaTencentMapDataRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTencentMapData;
import com.biz.crm.util.Result;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author yangshan
 * @date 2021/4/14 21:20
 */
public interface SfaTencentMapDataService extends IService<SfaTencentMapDataEntity> {

    /**
     * 新增
     * @param reqVo
     */
    void save(List<SfaTencentMapDataEntity> reqVo);

    /**
     * 数据同步(腾讯地图
     * @param sfaTencentMapData
     */
    Result saveTxMapData(SfaTencentMapData sfaTencentMapData);

    /**
     * 分页查询
     * @param reqVo
     */
    PageResult<SfaTencentMapDataRespVo> findList(SfaTencentMapData.SfaTencentMapDataReqVo reqVo);

    /**
     * 围栏坐标判定
     * @param reqVO
     * @return
     */
    Result qrySalesConsultantFence(SfaCoordinatesDetermineReqVO reqVO);

    /**
     * 销售片区经纬
     * @param reqVO
     * @return
     */
    Result<List<String>> qrySalesFence(@RequestBody SfaSalesFenceReqVO reqVO);



    }
