package com.biz.crm.moblie.controller;

import com.biz.crm.aop.CrmAPIDiscard;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.ActivitiEnum;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.moblie.service.SfaClientByCustConExtend;
import com.biz.crm.moblie.service.SfaCustomerService;
import com.biz.crm.moblie.service.SfaTerminalService;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.mdm.PageVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactPageRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDistanceContactPageReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactPageVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalDistanceContactPageReqVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.sfa.moblie.req.SfaCustomerReqVo;
import com.biz.crm.nebular.sfa.moblie.req.SfaTerminalMsgReqVo;
import com.biz.crm.nebular.sfa.moblie.req.SfaTerminalReqVo;
import com.biz.crm.nebular.sfa.moblie.resp.SfaCustomerMsgRespVo;
import com.biz.crm.nebular.sfa.moblie.resp.SfaTerminalMsgRespVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditFinishReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaLeaveRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.bind.annotation.*;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 客户(网点:终端)管理
 * @author liuhongming
 * @date 2020-10-14 15:05:08
 */
@Slf4j
@RestController
@RequestMapping("/client")
@Api(tags = "小程序端-工作台页面-客户管理")
public class SfaClientController {

    @Autowired
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Autowired(required = false)
    private SfaClientByCustConExtend sfaClientByCustConExtend;
    @Autowired
    private MdmTerminalFeign mdmTerminalFeign;
    @Autowired
    private SfaTerminalService sfaTerminalService;
    @Autowired
    private SfaCustomerService sfaCustomerService;

    @ApiOperation(value = "客户查询")
    @PostMapping("/findClientByCustConList")
    @CrmLog
    public Page<MdmCustomerMsgRespVo> findClientByCustomerConList(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        if (null==mdmCustomerMsgReqVo.getPageNum()){
            mdmCustomerMsgReqVo.setPageNum(0);
        }
        if (null==mdmCustomerMsgReqVo.getPageSize()){
            mdmCustomerMsgReqVo.setPageSize(50);
        }
        PageResult<MdmCustomerMsgRespVo> pageResult = null;
        if (null != sfaClientByCustConExtend){
            pageResult = sfaClientByCustConExtend.findClientByCustomerConList(mdmCustomerMsgReqVo);
        }else{
            pageResult = mdmCustomerMsgFeign.list(mdmCustomerMsgReqVo).getResult();
        }
        return pageResult == null
                ? new PageImpl<>(Lists.newArrayList(), PageRequest.of(mdmCustomerMsgReqVo.getPageNum(), mdmCustomerMsgReqVo.getPageSize()), 0)
                : new PageImpl<>(pageResult.getData(), PageRequest.of(mdmCustomerMsgReqVo.getPageNum(), mdmCustomerMsgReqVo.getPageSize()), pageResult.getCount());
    }


    /**
     * 条件查询客户主联系人及距离分页列表
     * @method findCustomer
     * @date: 2020/12/29 16:44
     * @author: YuanZiJian
     * @return org.springframework.data.domain.Page<com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo>
     */
    @ApiOperation(value = "条件查询客户主联系人及距离分页列表")
    @PostMapping("/findCustomer")
    @CrmLog
    public  Result<PageResult<MdmCustomerContactPageRespVo>> findCustomer(@RequestBody MdmCustomerDistanceContactPageReqVo mdmCustomerDistanceContactPageReqVo) {
        Result<PageResult<MdmCustomerContactPageRespVo>> pageResult = mdmCustomerMsgFeign.distanceContactNoBpmFilterPage(mdmCustomerDistanceContactPageReqVo);
        PageResult<MdmCustomerContactPageRespVo> page = pageResult.getResult();
        if(CollectionUtil.listNotEmpty(page.getData())){
            List<String> clientsCode = page.getData().stream().map(MdmCustomerContactPageRespVo::getCustomerCode).collect(Collectors.toList());
            Map<String, String> visitLabelMap= sfaCustomerService.findVisitLabel(clientsCode);
            for (MdmCustomerContactPageRespVo datum : page.getData()) {
                datum.setVisitLabel(visitLabelMap.getOrDefault(datum.getCustomerCode(), "从未拜访"));
            }
        }
        return pageResult;
    }

    /**
     * 客户明细查询
     * @return
     */
    @ApiOperation(value = "客户明细查询")
    @GetMapping("//findClientByCustomerQuery")
    @CrmLog
    public Result<MdmCustomerMsgRespVo> findClientByCustomerQuery(@RequestParam(value = "id",required = false) String id, @RequestParam(value = "customerCode",required = false) String customerCode) {
        Result<MdmCustomerMsgRespVo> result = mdmCustomerMsgFeign.query(id,customerCode);
        return result;
    }


    /**
     * 新增客户
     * @method saveCustomer
     * @date: 2020/12/30 11:07
     * @author: YuanZiJian
     * @param mdmCustomerMsgReqVo
     * @return com.biz.crm.util.Result
     */
    @ApiOperation(value = "新增客户")
    @PostMapping("/saveCustomer")
    @CrmLog
    public Result saveCustomer(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo ){
        sfaCustomerService.saveCustomer(mdmCustomerMsgReqVo);
        return Result.ok();
    }


    /**
     * 更新客户
     * @method updateCustomer
     * @date: 2020/12/30 11:07
     * @author: YuanZiJian
     * @param mdmCustomerMsgReqVo
     * @return com.biz.crm.util.Result
     */
    @ApiOperation(value = "更新客户")
    @PostMapping("/updateCustomer")
    @CrmLog
    public Result updateCustomer(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo ){
        sfaCustomerService.updateCustomer(mdmCustomerMsgReqVo);
        return Result.ok();
    }

    /**
     * 终端查询
     * @method findTerminal
     * @date: 2020/12/29 15:12
     * @author: YuanZiJian
     * @return com.biz.crm.util.Result<com.biz.crm.common.PageResult<com.biz.crm.nebular.mdm.terminal.MdmTerminalVo>>
     */
    @ApiOperation(value = "终端查询")
    @PostMapping("/findTerminal")
    @CrmLog
    public Result<PageResult<MdmTerminalContactPageVo>> findTerminal(@RequestBody MdmTerminalDistanceContactPageReqVo mdmTerminalDistanceContactPageReqVo){
        Result<PageResult<MdmTerminalContactPageVo>> pageResultResult = mdmTerminalFeign.distanceContactNoBpmFilterPage(mdmTerminalDistanceContactPageReqVo);
        if(pageResultResult.getResult() != null && CollectionUtil.listNotEmpty(pageResultResult.getResult().getData())){
            List<String> clientsCode = pageResultResult.getResult().getData().stream().map(MdmTerminalContactPageVo::getTerminalCode).collect(Collectors.toList());
            Map<String, String> visitLabelMap= sfaCustomerService.findVisitLabel(clientsCode);
            for (MdmTerminalContactPageVo datum : pageResultResult.getResult().getData()) {
                datum.setVisitLabel(visitLabelMap.getOrDefault(datum.getTerminalCode(), "从未拜访"));
            }
        }
        return pageResultResult;
    }


    /**
     *
     * 根据营业执照号查出指定终端
     * @method findTerminalByLicenseRegisterNumb
     * @date: 2020/12/29 11:40
     * @author: YuanZiJian
     * @param licenseRegisterNumber 营业执照注册号
     * @param terminalName 终端名字
     * @return com.biz.crm.util.Result<com.biz.crm.nebular.mdm.terminal.MdmTerminalVo>
     */
    @ApiOperation(value = "根据营业执照号查出指定终端")
    @GetMapping("/findTerminalByLicenseRegisterNumb")
    @CrmLog
    public Result<MdmTerminalVo> findTerminalByLicenseRegisterNumb(@RequestParam(value = "licenseRegisterNumber", required = false) String licenseRegisterNumber,
                                                      @RequestParam(value = "terminalName", required = false) String terminalName){
        Result<MdmTerminalVo> detailByRegisterOrName = mdmTerminalFeign.findDetailByRegisterOrName(licenseRegisterNumber, terminalName);
        return detailByRegisterOrName;
    }


    @ApiOperation(value = "查询单个终端")
    @GetMapping("/queryTerminal")
    @CrmLog
    public Result<MdmTerminalVo> query(@RequestParam(value = "id", required = false) String id,
                                                                   @RequestParam(value = "terminalCode", required = false) String terminalCode){
        Result<MdmTerminalVo> mdmTerminalVoResult = mdmTerminalFeign.query(id, terminalCode);
        return mdmTerminalVoResult;
    }

    /**
     * 新增终端
     * @method findTerminalByLicenseRegisterNumb
     * @date: 2020/12/29 11:39
     * @author: YuanZiJian
     * @return com.biz.crm.util.Result<com.biz.crm.nebular.mdm.terminal.MdmTerminalVo>
     */
    @ApiOperation(value = "新增终端")
    @PostMapping("/saveTerminal")
    @CrmLog
    public Result saveTerminal(@RequestBody SfaTerminalMsgReqVo sfaTerminalMsgReqVo){
        sfaTerminalService.saveTerminal(sfaTerminalMsgReqVo);
        return Result.ok();
    }

    /**
     * 更新终端
     * @method updateTerminal
     * @date: 2020/12/29 13:41
     * @author: YuanZiJian
     * @param mdmTerminalVo
     * @return com.biz.crm.util.Result
     */
    @ApiOperation(value = "更新终端")
    @PostMapping("/updateTerminal")
    @CrmLog
    public Result updateTerminal(@RequestBody SfaTerminalMsgReqVo sfaTerminalMsgReqVo){
        sfaTerminalService.updateTerminal(sfaTerminalMsgReqVo);
        return Result.ok();
    }

    /**
     * 客户审核流程结束
     * @method customerEnd
     * @date: 2021/1/6 11:08
     * @author: YuanZiJian
     * @param activitiCallBackVo
     * @return com.biz.crm.util.Result
     */
    @ApiOperation("客户审核流程结束")
    @PostMapping("/customerEnd")
    @CrmLog
    public Result customerEnd(@RequestBody ActivitiCallBackVo activitiCallBackVo) {
        sfaCustomerService.updateActApproveStatus(activitiCallBackVo);
        return Result.ok();
    }

    /**
     * 终端审核流程结束
     * @method terminalEnd
     * @date: 2021/1/6 11:08
     * @author: YuanZiJian
     * @param activitiCallBackVo
     * @return com.biz.crm.util.Result
     */
    @ApiOperation("终端审核流程结束")
    @PostMapping("/terminalEnd")
    @CrmLog
    public Result terminalEnd(@RequestBody ActivitiCallBackVo activitiCallBackVo) {
        sfaTerminalService.updateActApproveStatus(activitiCallBackVo);
        return Result.ok();
    }


    /**
     * 查询在审核的所有终端-小程序端
     * @method findAllTerminal
     * @date: 2021/1/6 11:08
     * @author: YuanZiJian
     * @param sfaTerminalReqVo
     * @return com.biz.crm.util.Result<com.biz.crm.common.PageResult<com.biz.crm.nebular.mdm.terminal.MdmTerminalVo>>
     */
    @ApiOperation("查询在审核的所有终端-小程序端")
    @PostMapping("/findAllTerminal")
    @CrmLog
    public Result<PageResult<SfaTerminalMsgRespVo>> findAllTerminal(@RequestBody SfaTerminalReqVo sfaTerminalReqVo) {
        return Result.ok(sfaTerminalService.findAllSfaTerminal(sfaTerminalReqVo));
    }

    /**
     * 终端审批-小程序端
     * @method updateSfaTerminal
     * @date: 2021/1/6 12:53
     * @author: YuanZiJian
     * @param id sfa审批终端Id
     * @param remark 审批意见
     * @param actApproveStatus 审批状态
     * @return com.biz.crm.util.Result
     */
    @ApiOperation("终端审批-小程序端")
    @GetMapping("/updateSfaTerminal")
    @CrmLog
    @CrmAPIDiscard
    @Deprecated
    public Result updateSfaTerminal(@RequestParam(value = "id", required = false) String id,
                                   @RequestParam(value = "remark", required = false) String remark,
                                   @RequestParam(value = "actApproveStatus", required = false) String actApproveStatus) {
        sfaTerminalService.updateSfaActApproveStatus(id,remark,actApproveStatus);
        return Result.ok();
    }



    /**
     * 根据id获取审批终端的信息-小程序端
     * @method querySfaTreminalVo
     * @date: 2021/1/6 13:46
     * @author: YuanZiJian
     * @param id sfa审批终端Id
     * @return com.biz.crm.util.Result<com.biz.crm.nebular.mdm.terminal.MdmTerminalVo>
     */
    @ApiOperation("根据id获取审批终端的信息-小程序端")
    @GetMapping("/querySfaTerminal")
    @CrmLog
    public Result<MdmTerminalVo> querySfaTerminalVo(@RequestParam(value = "id", required = false) String id){
//        return sfaTerminalService.querySfaTerminalVo(id);
        MdmTerminalVo mdmTerminalVoResult = ApiResultUtil.objResult(mdmTerminalFeign.query(id, null));
        return Result.ok(mdmTerminalVoResult);
    }

//____________________________________________下面是经销商

    /**
     * 根据id获取审批经销商的信息-小程序端
     * @method querySfaCustomerMsgVo
     * @date: 2021/1/6 13:46
     * @author: YuanZiJian
     * @param id sfa审批终端Id
     * @return com.biz.crm.util.Result<com.biz.crm.nebular.mdm.terminal.MdmTerminalVo>
     */
    @ApiOperation("根据id获取审批经销商的信息-小程序端")
    @GetMapping("/querySfaCustomerMsgVo")
    @CrmLog
    @CrmDictMethod
    public Result<MdmCustomerMsgRespVo> querySfaCustomerMsgVo(@RequestParam(value = "id", required = false) String id){
//        return sfaCustomerService.querySfaCustomerVo(id);
        MdmCustomerMsgRespVo mdmCustomerMsgRespVo = ApiResultUtil.objResult(mdmCustomerMsgFeign.query(id, null));
        return Result.ok(mdmCustomerMsgRespVo);
    }

    /**
     * 经销商审批-小程序端
     * @method updateSfaCustomer
     * @date: 2021/1/6 12:53
     * @author: YuanZiJian
     * @param id sfa审批经销商Id
     * @param remark 审批意见
     * @param actApproveStatus 审批状态
     * @return com.biz.crm.util.Result
     */
    @ApiOperation("经销商审批-小程序端")
    @GetMapping("/updateSfaCustomer")
    @CrmLog
    @CrmAPIDiscard
    @Deprecated
    public Result updateSfaCustomer(@RequestParam(value = "id", required = false) String id,
                                    @RequestParam(value = "remark", required = false) String remark,
                                    @RequestParam(value = "actApproveStatus", required = false) String actApproveStatus) {
        sfaCustomerService.updateSfaActApproveStatus(id,remark,actApproveStatus);
        return Result.ok();
    }

    /**
     * 查询在审核的所有经销商-小程序端
     * @method findAllCustomer
     * @date: 2021/1/6 11:08
     * @author: YuanZiJian
     * @param sfaCustomerReqVo
     * @return com.biz.crm.util.Result<com.biz.crm.common.PageResult<com.biz.crm.nebular.mdm.terminal.MdmTerminalVo>>
     */
    @ApiOperation("查询在审核的所有经销商-小程序端")
    @PostMapping("/findAllCustomer")
    @CrmLog
    public Result<PageResult<MdmCustomerMsgReqVo>> findAllCustomer(@RequestBody SfaCustomerReqVo sfaCustomerReqVo) {
        return Result.ok(sfaCustomerService.findAllSfaCustomer(sfaCustomerReqVo));
    }

//    ___________________________下面是气泡

    @ApiOperation("待处理的经销商数量")
    @GetMapping("/countCustomerInApproving")
    @CrmLog
    public Result<Integer> countCustomerInApproving(){
        return sfaCustomerService.countCustomer();
    }

    @ApiOperation("待处理的终端数量")
    @GetMapping("/countTerminalInApproving")
    @CrmLog
    public Result<Integer> countTerminalInApproving(){
        return sfaTerminalService.countTerminal();
    }


    @ApiOperation("获取客户新增数")
    @GetMapping("/getCustomerNum")
    @CrmLog
    public Result<Integer> getCustomerNum(@RequestParam(value = "dateFlag",required = false) String dateFlag){
        return Result.ok(sfaCustomerService.getCustomerNum(dateFlag));
    }

    @ApiOperation("获取客户活动标签")
    @GetMapping("getActLabel")
    @CrmLog
    public Result<List<String>>getActLabel(@RequestParam("clientCode") String clientCode){
        return Result.ok(sfaCustomerService.getActLabel(clientCode));
    }

}
