package com.biz.crm.moblie.controller;

import com.biz.crm.aop.CrmAPIDiscard;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.helpdefense.service.ISfaHelpDefenseService;
import com.biz.crm.nebular.sfa.helpdefense.req.SfaHelpDefenseReqVo;
import com.biz.crm.nebular.sfa.helpdefense.resp.SfaHelpDefenseRespVo;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author lf
 * @describe 计算薪资日期日志表实体类
 * @project crm
 * @package com.biz.crm.moblie.controller
 * @date 2021/1/6 22:46
 */
@Slf4j
@RestController
@RequestMapping("/sfaHelpController")
@Api(tags = "小程序端-日常工作-协访计划")
public class SfaHelpController {

    @Autowired
    private ISfaHelpDefenseService sfaHelpDefenseService;


    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaHelpDefenseRespVo>> list(@RequestBody SfaHelpDefenseReqVo sfaHelpDefenseReqVo) {
        PageResult<SfaHelpDefenseRespVo> result=sfaHelpDefenseService.findList(sfaHelpDefenseReqVo);
        return Result.ok(result);
    }

    /**
     * 通过日期查询协访信息
     * @param reqVo
     * @return
     */
    @CrmLog
    @PostMapping("findSfaHelpDefenseDetail")
    @ApiOperation(value = "通过日期查询协访信息")
    public Result<SfaHelpDefenseRespVo> findSfaHelpDefenseDetail(@RequestBody SfaHelpDefenseReqVo reqVo){
        SfaHelpDefenseRespVo sfaHelpDefenseRespVo = sfaHelpDefenseService.findSfaHelpDefenseDetail(reqVo);
        return Result.ok(sfaHelpDefenseRespVo);
    }

    /**
     * 通过主键id查询详情
     */
    @ApiOperation(value = "通过主键id查询详情")
    @GetMapping("/queryDetailById")
    @CrmLog
    public Result<SfaHelpDefenseRespVo> queryDetailById(@RequestParam String id) {
        SfaHelpDefenseRespVo respVo=sfaHelpDefenseService.queryDetailById(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaHelpDefenseReqVo sfaHelpDefenseReqVo) {
        sfaHelpDefenseService.save(sfaHelpDefenseReqVo);
        return Result.ok();
    }


    /**
     * 查询被协访的拜访网点信息
     * @param reqVo
     * @return
     */
    @ApiOperation(value = "查询被协访的拜访网点信息")
    @PostMapping("findSfaVisitPlanInfoList")
    @CrmLog
    public Result<List<SfaVisitPlanInfoRespVo>> findSfaVisitPlanInfoList(@RequestBody SfaVisitPlanInfoReqVo reqVo){
        List<SfaVisitPlanInfoRespVo> pageResult = sfaHelpDefenseService.findSfaVisitPlanInfoList(reqVo);
        return Result.ok(pageResult);
    }

    /**
     * 查询被协访的拜访网点信息
     * @param reqVo
     * @return
     */
    @ApiOperation(value = "查询所有被协访的拜访网点信息")
    @PostMapping("findAllSfaVisitPlanInfoList")
    @CrmLog
    public Result<List<SfaVisitPlanInfoRespVo>> findAllSfaVisitPlanInfoList(@RequestBody SfaVisitPlanInfoReqVo reqVo){
        List<SfaVisitPlanInfoRespVo> dataList = sfaHelpDefenseService.findAllSfaVisitPlanInfoList(reqVo);
        return Result.ok(dataList);
    }


    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    @Deprecated
    @CrmAPIDiscard
    public Result update(@RequestBody SfaHelpDefenseReqVo sfaHelpDefenseReqVo) {
        sfaHelpDefenseService.update(sfaHelpDefenseReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        sfaHelpDefenseService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "协防计划删除校验")
    @GetMapping("/checkIsDelete")
    @CrmLog
    public Result checkIsDelete(@RequestParam(value = "id") String id, @RequestParam("coverHelpPosCode") String coverHelpPosCode) {
        sfaHelpDefenseService.checkIsDelete(id, coverHelpPosCode);
        return Result.ok("删除成功");
    }

}
