package com.biz.crm.moblie.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.collection.controller.resp.SfaUnfamiliarVisitRecordDetailRespVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.moblie.controller.visit.resp.SfaVisitResp;
import com.biz.crm.moblie.service.ISfaNearbyCustomerService;
import com.biz.crm.nebular.sfa.moblie.req.SfaNearbyCustomerReqVo;
import com.biz.crm.nebular.sfa.moblie.req.SfaUnfamiliarVisitRecordReqVo;
import com.biz.crm.nebular.sfa.moblie.resp.SfaUnfamiliarVisitRecordRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 附近客户
 * @author yangshan
 * @date 2021/3/9 14:32
 */
@RestController
@RequestMapping("/sfaNearbyCustomerController")
@Slf4j
@Api(tags = "附近客户")
public class SfaNearbyCustomerController {

    @Autowired
    private ISfaNearbyCustomerService sfaNearbyCustomerService;

    @ApiOperation(value = "根据经纬度查询未合作客户")
    @PostMapping("/findNotCooperationCustomerList")
    @CrmLog
    public Result<SfaVisitResp> findNotCooperationCustomerList(@RequestBody SfaNearbyCustomerReqVo reqVo){
        return Result.ok(sfaNearbyCustomerService.findNotCooperationCustomerList(reqVo));
    }

    @ApiOperation(value = "根据经纬度查询已合作客户")
    @PostMapping("/findCooperationCustomerList")
    @CrmLog
    public Result<SfaVisitResp> findCooperationCustomerList(@RequestBody SfaNearbyCustomerReqVo reqVo){
        return Result.ok(sfaNearbyCustomerService.findCooperationCustomerList(reqVo));
    }


    @ApiOperation("查询陌拜记录")
    @PostMapping("/findUnfamiliarVisitRecord")
    @CrmLog
    public Result<PageResult<SfaUnfamiliarVisitRecordRespVo>> findUnfamiliarVisitRecord(@RequestBody SfaUnfamiliarVisitRecordReqVo reqVo){
        return Result.ok(sfaNearbyCustomerService.findUnfamiliarVisitRecord(reqVo));
    }

    @ApiOperation("查询陌拜详情")
    @GetMapping("/getUnfamiliarVisitRecordDetail")
    public Result<SfaUnfamiliarVisitRecordDetailRespVo> getUnfamiliarVisitRecordDetail(@RequestParam("visitPlanInfoId")String visitPlanInfoId){
        return Result.ok(sfaNearbyCustomerService.getUnfamiliarVisitRecordDetail(visitPlanInfoId));
    }
}
