package com.biz.crm.moblie.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.assistant.service.ISfaWorkTaskReceveService;
import com.biz.crm.assistant.service.ISfaWorkTaskReleaseService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskReleaseReqVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskReleaseRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 工作任务
 * @author Xiao
 * @date 2020-09-30 10:26:35
 */
@Slf4j
@RestController
@RequestMapping("/task")
@Api(tags = "小程序端-工作台页面-工作助手-工作任务")
public class SfaTaskController {

    @Autowired
    private ISfaWorkTaskReceveService sfaWorkTaskReceveService;

     @Autowired
    private ISfaWorkTaskReleaseService sfaWorkTaskReleaseService;

    /**
     * 查询当日工作任务列表
     * @param sfaWorkTaskReleaseReqVo
     * @return
     */
    @ApiOperation(value = "查询当日工作任务列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaWorkTaskReleaseRespVo>> list(@RequestBody SfaWorkTaskReleaseReqVo sfaWorkTaskReleaseReqVo) {
        //启用状态
        sfaWorkTaskReleaseReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());

        //登陆账号
        if(StringUtils.isEmpty(sfaWorkTaskReleaseReqVo.getCreateCode())){
            String userName = UserUtils.getUser().getUsername();
            sfaWorkTaskReleaseReqVo.setCreateCode(userName);
        }

        PageResult<SfaWorkTaskReleaseRespVo> result=sfaWorkTaskReleaseService.findList(sfaWorkTaskReleaseReqVo);
        return Result.ok(result);
    }




}
