package com.biz.crm.moblie.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.req.GetVisitListReq;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoRespVo;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitGroupReqVo;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitPlanReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitGroupRespVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitPlanRespVo;
import com.biz.crm.util.*;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.biz.crm.visitnote.service.ISfaVisitGroupService;
import com.biz.crm.visitnote.service.ISfaVisitPlanService;
import com.biz.crm.visitnote.service.ISfaVisitTempPlanService;
import com.biz.crm.visitnote.service.component.resolver.SfaVisitPlanResolver;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Project crm-core
 * @PackageName com.biz.crm.moblie.controller
 * @Author lifei
 * @Date 2020/11/16
 * @Description
 */
@Slf4j
@RestController
@RequestMapping("/sfaWorkVisitPlanController")
@Api(tags = "小程序端-工作台-拜访计划")
public class SfaWorkVisitPlanController {

    @Autowired
    private ISfaVisitPlanInfoService sfaVisitPlanInfoService;
    @Autowired
    private ISfaVisitGroupService sfaVisitGroupService;
    @Autowired
    private ISfaVisitPlanService sfaVisitPlanService;
    @Autowired
    private ISfaVisitTempPlanService sfaVisitTempPlanService;


    /**
     * 查询sfa临时拜访列表(临时/周期性拜访计划)
     *
     * @param reqVo
     * @return
     */
    @ApiOperation(value = "临时拜访计划列表查询(临时/周期拜访计划)")
    @PostMapping("/findVisitPlanInfoList")
    @CrmLog
    public Result<List<SfaVisitPlanInfoRespVo>> findVisitPlanInfoList(@RequestBody SfaVisitPlanInfoReqVo reqVo) {


        return Result.ok(CrmBeanUtil.copyList(this.doFindVisitPlanInfoList(reqVo), SfaVisitPlanInfoRespVo.class));
    }

    private List<SfaVisitPlanInfoEntity> doFindVisitPlanInfoList(SfaVisitPlanInfoReqVo reqVo) {
        if (org.apache.commons.lang3.StringUtils.isBlank(reqVo.getVisitDate())) {
            throw new BusinessException("日期为空！");
        }
        LocalDate visitDate;
        try {
            visitDate = LocalDate.parse(reqVo.getVisitDate(), CrmDateUtils.yyyyMMdd);
        } catch (Exception e) {
            throw new BusinessException("日期格式错误", e);
        }
        SfaVisitPlanResolver.futureDaysCheck(visitDate);
        UserRedis userRedis = UserUtils.getUser();
        //判断当前登录用户为经销商用户
        if (userRedis.getUsertype().equals(UserTypeEnum.CUSTOMER_EMPLOYEE.getCode())) {
            userRedis.setPoscode(userRedis.getUsername());
        }
        if (StringUtils.isEmpty(reqVo.getVisitUserName()) || org.apache.commons.lang3.StringUtils.isBlank(reqVo.getVisitPosCode())) {
            reqVo.setVisitUserName(userRedis.getUsername());
            reqVo.setVisitPosCode(userRedis.getPoscode());
        }

        GetVisitListReq.MoreReq req = new GetVisitListReq.MoreReq();
        req.setVisitUserName(reqVo.getVisitUserName());
        if (org.apache.commons.lang3.StringUtils.isBlank(reqVo.getVisitPosCode())) {
            throw new BusinessException("职位为空！");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank(reqVo.getClientType())) {
            throw new BusinessException("客户类型为空！");
        }
        req.setVisitBigType(SfaVisitEnum.VisitBigType.VISIT.getVal());
        req.setVisitPositionCode(reqVo.getVisitPosCode());
        req.setVisitDate(reqVo.getVisitDate());
        req.setClientType(reqVo.getClientType());
        req.setKeyWord(reqVo.getKeyWord());
        List<SfaVisitPlanInfoEntity> list = this.sfaVisitPlanInfoService.getVisitInfoListByClientType(req);
        return list;
    }


    /**
     * 查询线路组列表
     */
    @ApiOperation(value = "查询线路组列表")
    @PostMapping("/findVisitGroupList")
    @CrmLog
    public Result<PageResult<SfaVisitGroupRespVo>> findVisitGroupList(@RequestBody SfaVisitGroupReqVo reqVo) {
        if (StringUtils.isEmpty(reqVo.getUserName())) {
            String userName = UserUtils.getUser().getUsername();
            reqVo.setUserName(userName);
        }
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        PageResult<SfaVisitGroupRespVo> result = sfaVisitGroupService.findList(reqVo);
        return Result.ok(result);
    }

    /**
     * 线路组查询
     */
    @ApiOperation(value = "线路组查询")
    @PostMapping("/visitGroupQuery")
    @CrmLog
    public Result<SfaVisitGroupRespVo> visitGroupQuery(@RequestBody SfaVisitGroupReqVo reqVo) {
        SfaVisitGroupRespVo respVo = sfaVisitGroupService.query(reqVo);
        return Result.ok(respVo);
    }

    /**
     * 线路组新增
     */
    @ApiOperation(value = "线路组新增")
    @PostMapping("/visitGroupSave")
    @CrmLog
    public Result visitGroupSave(@RequestBody SfaVisitGroupReqVo reqVo) {
        sfaVisitGroupService.save(reqVo);
        return Result.ok();
    }

    /**
     * 线路组更新更新
     */
    @ApiOperation(value = "线路组更新更新")
    @PostMapping("/visitGroupUpdate")
    @CrmLog
    public Result visitGroupUpdate(@RequestBody SfaVisitGroupReqVo reqVo) {
        if (StringUtils.isEmpty(reqVo.getUserName())) {
            String userName = UserUtils.getUser().getUsername();
            reqVo.setUserName(userName);
        }
        sfaVisitGroupService.update(reqVo);
        return Result.ok("修改成功");
    }

    /**
     * 线路组删除
     */
    @ApiOperation(value = "线路组删除")
    @PostMapping("/visitGroupDelete")
    @CrmLog
    public Result visitGroupDelete(@RequestBody List<String> ids) {
        sfaVisitGroupService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 查询周期性拜访列表
     */
    @ApiOperation(value = "查询周期性拜访列表")
    @PostMapping("/findVisitPlanList")
    @CrmLog
    public Result<PageResult<SfaVisitPlanRespVo>> findVisitPlanList(@RequestBody SfaVisitPlanReqVo reqVo) {
        if (StringUtils.isEmpty(reqVo.getVisitUserName())) {
            UserRedis user = UserUtils.getUser();
            if (user.getUsertype().equals(UserTypeEnum.CUSTOMER_EMPLOYEE.getCode())){
                user.setPoscode(user.getUsername());
            }
            reqVo.setVisitUserName(user.getUsername());
            reqVo.setVisitPosCode(user.getPoscode());
        }
        reqVo.setPlanType(SfaVisitEnum.visitType.PLAN_VISIT.getVal());
        reqVo.setRouteType(SfaVisitEnum.routeTypeEnum.R1.getVal());
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        PageResult<SfaVisitPlanRespVo> result = sfaVisitPlanService.findList(reqVo);
        return Result.ok(result);
    }

    /**
     * 周期性拜访查询
     */
    @ApiOperation(value = "周期性拜访查询")
    @PostMapping("/visitPlanQuery")
    @CrmLog
    public Result<SfaVisitPlanRespVo> visitPlanQuery(@RequestBody SfaVisitPlanReqVo sfaVisitPlanReqVo) {
        sfaVisitPlanReqVo.setPlanType(SfaVisitEnum.visitType.PLAN_VISIT.getVal());
        SfaVisitPlanRespVo respVo = sfaVisitPlanService.query(sfaVisitPlanReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "周期性拜访新增")
    @PostMapping("/visitPlanSave")
    @CrmLog
    public Result visitPlanSave(@RequestBody SfaVisitPlanReqVo reqVo) {
        if (StringUtils.isEmpty(reqVo.getVisitUserName())) {
            UserRedis userRedis = UserUtils.getUser();
            if (userRedis.getUsertype().equals(UserTypeEnum.CUSTOMER_EMPLOYEE.getCode())){
                userRedis.setPoscode(userRedis.getUsername());
                userRedis.setPosname(userRedis.getRealname());
            }
            reqVo.setVisitUserName(userRedis.getUsername());
            reqVo.setVisitRealName(userRedis.getRealname());
            reqVo.setVisitOrgCode(userRedis.getOrgcode());
            reqVo.setVisitOrgName(userRedis.getOrgname());
            reqVo.setVisitPosCode(userRedis.getPoscode());
            reqVo.setVisitPosName(userRedis.getPosname());
        }
        reqVo.setPlanType(SfaVisitEnum.visitType.PLAN_VISIT.getVal());
        reqVo.setRouteType(SfaVisitEnum.routeTypeEnum.R1.getVal());
        sfaVisitPlanService.save(reqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "周期性拜访更新")
    @PostMapping("/visitPlanUpdate")
    @CrmLog
    public Result visitPlanUpdate(@RequestBody SfaVisitPlanReqVo reqVo) {
        if (StringUtils.isEmpty(reqVo.getVisitUserName())) {
            String userName = UserUtils.getUser().getUsername();
            reqVo.setVisitUserName(userName);
        }
        reqVo.setPlanType(SfaVisitEnum.visitType.PLAN_VISIT.getVal());
        reqVo.setRouteType(SfaVisitEnum.routeTypeEnum.R1.getVal());
        sfaVisitPlanService.update(reqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "周期性拜访删除")
    @PostMapping("/visitPlanDelete")
    @CrmLog
    public Result visitPlanDelete(@RequestBody List<String> ids) {
        sfaVisitPlanService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 查询拜访日期已存在的客户类型
     *
     * @param reqVo
     * @return
     */
    @ApiOperation(value = "查询拜访日期已存在的客户类型")
    @PostMapping("/findAlreadyCusOrTerminal")
    @CrmLog
    public Result<List<String>> findAlreadyCusOrTerminal(@RequestBody SfaVisitPlanInfoReqVo reqVo) {
        List<String> clientCodeList = this.doFindVisitPlanInfoList(reqVo).stream().map(SfaVisitPlanInfoEntity::getClientCode).collect(Collectors.toList());
        return Result.ok(clientCodeList);
    }


}
