package com.biz.crm.moblie.controller.visit;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.moblie.controller.visit.component.impl.DefaultVisitStepExecutor;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.util.Result;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.biz.crm.visitinfo.service.impl.SfaVisitPlanInfoRedisDataServiceEsImpl;
import com.biz.crm.visitstep.model.SfaVisitStepDefaultEntity;
import com.biz.crm.visitstep.model.SfaVisitStepDefaultEsData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;


/**
 * 拜访执行-默认步骤模板
 *  @author: luoqi
 *  @Date: 2021-3-24 13:48
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
@RestController
@RequestMapping("/sfaDefStepVisitController")
@Api(tags = "小程序端-日程页面-拜访执行-默认步骤模板")
public class SfaDefStepVisitController {

    @Resource
    private ISfaVisitPlanInfoService sfaVisitPlanInfoService;

    @Resource
    private DefaultVisitStepExecutor defaultVisitStepExecutor;
    @Resource
    private SfaVisitPlanInfoRedisDataServiceEsImpl sfaVisitPlanInfoRedisDataServiceEsImpl;



    /**
     * 拜访步骤-默认模板
     * @param visitStepExecuteReq
     * @return
     */
    @ApiOperation(value = "拜访步骤-默认步骤模板")
    @PostMapping("/saveVisitStepDef")
    @CrmLog
    public Result saveVisitStepDef(@RequestBody VisitStepExecuteReq<SfaVisitStepDefaultEntity> visitStepExecuteReq){

        this.defaultVisitStepExecutor.execute(visitStepExecuteReq);
        return Result.ok();
    }
    /**
     * 拜访步骤-默认模板
     * @param redisHashKey
     * @return
     */
    @ApiOperation(value = "拜访步骤-默认步骤模板-查询表单执行数据")
    @PostMapping("/loadVisitStepDef")
    @CrmLog
    public Result<SfaVisitStepDefaultEsData> loadVisitStepDef(@RequestBody ExecutorLoadReq redisHashKey){
        SfaVisitStepDefaultEsData dataResp = (SfaVisitStepDefaultEsData)this.defaultVisitStepExecutor.load(redisHashKey);
        return Result.ok(dataResp);
    }






}
