package com.biz.crm.moblie.controller.visit;

import com.biz.crm.aop.CrmAPIDiscard;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.moblie.service.ISfaVisitClientStepDisplayService;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepDisplayReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepDisplayRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

@Slf4j
@RestController
@RequestMapping("/visitClientStepDisplay")
@Api(tags = "小程序端-日程页面-拜访执行(终端)-陈列执行")
public class SfaVisitClientStepDisplayController {

    @Resource
    private ISfaVisitClientStepDisplayService iSfaVisitClientStepDisplayService;

    @ApiOperation(value = "查询陈列执行需要上传的图片要求")
    @PostMapping("/visitDisplayList")
    @CrmLog
    @CrmAPIDiscard
    @Deprecated
    public Result<List<SfaVisitStepDisplayRespVo>> visitDisplayList(@RequestBody @Validated SfaVisitStepDisplayReqVo vo) {
        List<SfaVisitStepDisplayRespVo> list = iSfaVisitClientStepDisplayService.visitDisplayList(vo);
        return Result.ok(list);
    }

    @ApiOperation(value = "保存和更新陈列执行数据")
    @PostMapping("/saveVisitDisplay")
    @CrmLog
    @CrmAPIDiscard
    @Deprecated
    public Result saveVisitDisplay(@RequestBody SfaVisitStepDisplayReqVo vo) {
        iSfaVisitClientStepDisplayService.saveVisitDisplay(vo);
        return Result.ok();
    }

}
