package com.biz.crm.moblie.controller.visit;

import com.biz.crm.aop.CrmAPIDiscard;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.asexecution.service.ISfaAsTreatyService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.collection.model.SfaVisitRoleConfigEntity;
import com.biz.crm.common.CrmRedisHashKeyVo;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.component.impl.*;
import com.biz.crm.moblie.controller.visit.req.GetVisitListReq;
import com.biz.crm.moblie.controller.visit.req.SfaVisitExceptionReq;
import com.biz.crm.moblie.controller.visit.req.SfaVisitInOutReq;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.*;
import com.biz.crm.moblie.controller.visit.resp.SfaVisitExceptionResp;
import com.biz.crm.moblie.controller.visit.resp.SfaVisitExecuteResp;
import com.biz.crm.moblie.controller.visit.resp.SfaVisitResp;
import com.biz.crm.moblie.controller.visit.resp.step.*;
import com.biz.crm.nebular.sfa.tpmact.VisitBaseVo;
import com.biz.crm.nebular.sfa.tpmact.actcollect.SfaTpmActCollectVo;
import com.biz.crm.nebular.sfa.tpmact.displaytreaty.CashTreatyVo;
import com.biz.crm.nebular.sfa.tpmact.displaytreaty.GoodsTreatyVo;
import com.biz.crm.nebular.sfa.tpmact.distributionorder.DistributionOrderVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActRespVo;
import com.biz.crm.nebular.sfa.visitdealer.req.SfaVisitDealerDetailReqVo;
import com.biz.crm.nebular.sfa.visitdealer.resp.SfaVisitDealerDetailRespVo;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoRespVo;
import com.biz.crm.tpmact.service.ISfaTpmActDetailService;
import com.biz.crm.tpmact.service.ISfaVisitStepTpmActCollectService;
import com.biz.crm.util.*;
import com.biz.crm.visitdealer.service.ISfaVisitDealerDetailService;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoExecuteRedisData;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.biz.crm.visitinfo.service.impl.SfaVisitPlanInfoRedisDataServiceEsImpl;
import com.biz.crm.visitstep.model.SfaVisitStepActivityExecutionEntity;
import com.biz.crm.visitstep.model.SfaVisitStepFromEntity;
import com.biz.crm.visitstep.req.LoadVisitActivityListReq;
import com.biz.crm.visitstep.resp.SfaActivityExecutionEntityResp;
import com.biz.crm.visitstep.service.ISfaVisitStepActivityExecutionService;
import com.biz.crm.visitstep.service.ISfaVisitStepFromService;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;

/**
 * 拜访
 *
 * @author Xiao
 * @date 2020-09-30 10:26:35
 */
@Slf4j
@RestController
@RequestMapping("/sfaVisitController")
@Api(tags = "小程序端-日程页面-拜访执行")
public class SfaVisitController {

    @Resource
    private ISfaVisitPlanInfoService sfaVisitPlanInfoService;

    @Resource
    private ISfaVisitDealerDetailService sfaVisitDealerDetailService;

    @Resource
    private ISfaVisitStepActivityExecutionService sfaVisitStepActivityExecutionService;

    @Resource
    private ActivityCostVisitStepExecutor activityCostVisitStepExecutor;

    @Resource
    private ActivityDisplayVisitStepExecutor activityDisplayVisitStepExecutor;


    @Resource
    private CompetitorVisitStepExecutor competitorVisitStepExecutor;
    @Resource
    private OrderVisitStepExecutor orderVisitStepExecutor;

    @Resource
    private StockInventoryVisitStepExecutor stockInventoryVisitStepExecutor;

    @Resource
    private StoreCheckVisitStepExecutor storeCheckVisitStepExecutor;

    @Resource
    private SummaryVisitStepExecutor summaryVisitStepExecutor;

    @Resource
    private SfaVisitPlanInfoRedisDataServiceEsImpl sfaVisitPlanInfoRedisDataServiceEsImpl;

    @Autowired
    private ISfaVisitStepFromService sfaVisitStepFromService;
    @Autowired
    private ISfaAsTreatyService sfaAsTreatyService;
    @Autowired
    private ISfaVisitStepOrderService sfaVisitStepOrderService;
    @Autowired
    private ISfaVisitStepTpmActCollectService sfaVisitStepTpmActCollectService;
    @Autowired
    private ISfaTpmActDetailService sfaTpmActDetailService;


    /**
     * 查询用户指定日期的拜访列表
     *
     * @return
     */
    @ApiOperation(value = "查询用户指定日期的拜访列表")
    @PostMapping("/getVisitInfoList")
    @CrmLog
    public Result<SfaVisitResp> getVisitInfoList(@RequestBody GetVisitListReq req) {
        //启用状态
//        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
//        reqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());

        //登陆账号
        if (StringUtils.isEmpty(req.getVisitUserName())) {
            UserRedis userRedis = UserUtils.getUser();
            req.setVisitUserName(userRedis.getUsername());
            req.setVisitPositionCode(userRedis.getPoscode());
        }

        return Result.ok(sfaVisitPlanInfoService.getVisitInfoList(req));
    }

    /**
     * 拜访进店打卡
     *
     * @return
     */
    @ApiOperation(value = "拜访-查询拜访客户信息、步骤列表")
    @PostMapping("/getVisitSteps")
    @CrmLog
    public Result<SfaVisitExecuteResp> getVisitSteps(@RequestBody CrmRedisHashKeyVo redisHashKeyVo) {
        return Result.ok(this.sfaVisitDealerDetailService.getVisitSteps(redisHashKeyVo));
    }

    @ApiOperation(value = "拜访-查询拜访客户信息、步骤列表-拜访完成后")
    @PostMapping("/getVisitExecuteInfoById")
    @CrmLog
    public Result<SfaVisitExecuteResp> getVisitStepsOfComplete(String visitInfoId) {
        return Result.ok(this.sfaVisitPlanInfoRedisDataServiceEsImpl.getVisitStepsOfComplete(visitInfoId));
    }

    /**
     * 查询拜访信息
     */
    @ApiOperation(value = "查询拜访信息")
    @PostMapping("/queryVisitInfo")
    @CrmLog
    @Deprecated
    @CrmAPIDiscard
    public Result<SfaVisitDealerDetailRespVo> queryVisitInfo(@RequestBody SfaVisitDealerDetailReqVo sfaVisitDealerDetailReqVo) {
        SfaVisitDealerDetailRespVo respVo = sfaVisitDealerDetailService.query(sfaVisitDealerDetailReqVo);
        return Result.ok(respVo);
    }


    /**
     * 拜访进店打卡
     *
     * @return
     */
    @ApiOperation(value = "拜访进店打卡")
    @PostMapping("/visitInStore")
    @CrmLog
    public Result<String> visitInStore(@RequestBody SfaVisitInOutReq inOutReq) {
        Result result = new Result();
        SfaVisitExecuteResp executeResp = this.sfaVisitDealerDetailService.visitInStore(inOutReq);
        result.setResult(executeResp.getIsOffLine());
        return result;
    }


    @CrmLog
    @ApiOperation("拜访执行-确认为离线拜访")
    @PostMapping("confirmVisitOffLine")
    public Result confirmVisitOffLine(@RequestBody CrmRedisHashKeyVo redisHashKeyVo){
        sfaVisitDealerDetailService.confirmVisitOffLine(redisHashKeyVo.getRedisHashKey());
        return Result.ok();
    }

    /**
     * 拜访离店打卡
     *
     * @param inOutReq
     * @return
     */
    @ApiOperation(value = "拜访离店打卡")
    @PostMapping("/visitOutStore")
    @CrmLog
    public Result visitOutStore(@RequestBody SfaVisitInOutReq inOutReq) {
        this.sfaVisitDealerDetailService.visitOutStore(inOutReq);
        return Result.ok();
    }

    /**
     * 拜访异常提报
     *
     * @param exceptionReq
     * @return
     */
    @ApiOperation(value = "拜访异常提报")
    @PostMapping("/visitException")
    @CrmLog
    public Result<SfaVisitExceptionResp> visitException(@RequestBody SfaVisitExceptionReq exceptionReq) {
        return Result.ok(this.sfaVisitDealerDetailService.visitException(exceptionReq));
    }

    @ApiOperation(value = "拜访-查询拜访异常信息")
    @PostMapping("/getVisitExceptionInfoById")
    @CrmLog
    public Result<SfaVisitExceptionResp> getVisitExceptionInfoById(String visitInfoId) {
        SfaVisitExceptionResp resp = new SfaVisitExceptionResp();
        SfaVisitPlanInfoExecuteRedisData redisData = this.sfaVisitPlanInfoRedisDataServiceEsImpl.getVisitExcuteInfo(visitInfoId);
        resp.setVisitExceptionPics(redisData.getVisitExceptionPics());
        resp.setExceptionDetail(redisData.getExceptionDetail());
        return Result.ok(resp);
    }


    /**
     * 拜访步骤-提交拜访总结
     *
     * @param visitStepExecuteReq
     * @return
     */
    @ApiOperation(value = "拜访步骤-拜访总结")
    @PostMapping("/saveVisitStepSummary")
    @CrmLog
    public Result saveVisitStepSummary(@RequestBody VisitStepExecuteReq<SummaryStepExecuteData> visitStepExecuteReq) {

        summaryVisitStepExecutor.execute(visitStepExecuteReq);
        return Result.ok();
    }

    /**
     * 拜访步骤-提交拜访总结
     *
     * @param redisHashKey
     * @return
     */
    @ApiOperation(value = "拜访步骤-拜访总结-查询表单执行数据")
    @PostMapping("/loadVisitStepSummary")
    @CrmLog
    public Result<SummaryStepExecuteDataResp> loadVisitStepSummary(@RequestBody ExecutorLoadReq redisHashKey) {
        SummaryStepExecuteDataResp dataResp = summaryVisitStepExecutor.load(redisHashKey);
        return Result.ok(dataResp);
    }


    /**
     * @param reqVo
     * @return
     */
    @ApiOperation(value = "(小地图)查询拜访完成的数据信息")
    @PostMapping("/findSfaVisitDealerVisitComplete")
    @CrmLog
    public Result<List<SfaVisitPlanInfoRespVo>> findSfaVisitDealerVisitComplete(@RequestBody SfaVisitPlanInfoReqVo reqVo) {
        reqVo.setVisitStatus(SfaVisitEnum.visitStatus.V3.getVal());
        List<SfaVisitPlanInfoRespVo> sfaVisitDealerDetailRespVos = sfaVisitDealerDetailService.findSfaVisitMapComplete(reqVo);
        return Result.ok(sfaVisitDealerDetailRespVos);
    }


    /**
     * 拜访步骤-库存盘点
     *
     * @param visitStepExecuteReq
     * @return
     */
    @ApiOperation(value = "拜访步骤-库存盘点")
    @PostMapping("/saveVisitStepStockInventory")
    @CrmLog
    public Result saveVisitStepStockInventory(@RequestBody VisitStepExecuteReq<StockInventoryStepExecuteData> visitStepExecuteReq) {

        stockInventoryVisitStepExecutor.execute(visitStepExecuteReq);
        return Result.ok();
    }

    /**
     * 拜访步骤-库存盘点
     *
     * @param redisHashKey
     * @return
     */
    @ApiOperation(value = "拜访步骤-库存盘点-查询表单执行数据")
    @PostMapping("/loadVisitStepStockInventory")
    @CrmLog
    public Result<StockInventoryStepExecuteDataResp> loadVisitStepStockInventory(@RequestBody ExecutorLoadReq redisHashKey) {
        StockInventoryStepExecuteDataResp dataResp = (StockInventoryStepExecuteDataResp) stockInventoryVisitStepExecutor.load(redisHashKey);
        return Result.ok(dataResp);
    }


    /**
     * 拜访步骤-竞品采集
     *
     * @param visitStepExecuteReq
     * @return
     */
    @ApiOperation(value = "拜访步骤-竞品采集")
    @PostMapping("/saveVisitStepCompetitor")
    @CrmLog
    public Result saveVisitStepCompetitor(@RequestBody VisitStepExecuteReq<CompetitorStepExecuteData> visitStepExecuteReq) {

        competitorVisitStepExecutor.execute(visitStepExecuteReq);
        return Result.ok();
    }

    /**
     * 拜访步骤-竞品采集
     *
     * @param redisHashKey
     * @return
     */
    @ApiOperation(value = "拜访步骤-竞品采集-查询表单执行数据")
    @PostMapping("/loadVisitStepCompetitor")
    @CrmLog
    public Result<CompetitorStepExecuteDataResp> loadVisitStepCompetitor(@RequestBody ExecutorLoadReq redisHashKey) {
        CompetitorStepExecuteDataResp dataResp = (CompetitorStepExecuteDataResp) competitorVisitStepExecutor.load(redisHashKey);
        return Result.ok(dataResp);
    }


    /**
     * 拜访步骤-订单采集
     *
     * @param visitStepExecuteReq
     * @return
     */
    @ApiOperation(value = "拜访步骤-订单采集")
    @PostMapping("/saveVisitStepOrders")
    @CrmLog
    public Result saveVisitStepOrder(@RequestBody VisitStepExecuteReq<OrderStepExecuteData> visitStepExecuteReq) {

        orderVisitStepExecutor.execute(visitStepExecuteReq);
        return Result.ok();
    }

    /**
     * 拜访步骤-订单采集
     *
     * @param redisHashKey
     * @return
     */
    @ApiOperation(value = "拜访步骤-订单采集-查询表单执行数据")
    @PostMapping("/loadVisitStepOrders")
    @CrmLog
    public Result<OrderStepExecuteDataResp> loadVisitStepOrder(@RequestBody ExecutorLoadReq redisHashKey) {
        OrderStepExecuteDataResp dataResp = (OrderStepExecuteDataResp) orderVisitStepExecutor.load(redisHashKey);
        return Result.ok(dataResp);
    }


    /**
     * 拜访步骤-店面检查
     *
     * @param visitStepExecuteReq
     * @return
     */
    @ApiOperation(value = "拜访步骤-店面检查")
    @PostMapping("/saveVisitStepStoreCheck")
    @CrmLog
    public Result saveVisitStepStoreCheck(@RequestBody VisitStepExecuteReq<StoreCheckStepExecuteData> visitStepExecuteReq) {

        storeCheckVisitStepExecutor.execute(visitStepExecuteReq);
        return Result.ok();
    }

    /**
     * 拜访步骤-店面检查
     *
     * @param redisHashKey
     * @return
     */
    @ApiOperation(value = "拜访步骤-店面检查-查询表单执行数据")
    @PostMapping("/loadVisitStepStoreCheck")
    @CrmLog
    public Result<StoreCheckStepExecuteDataResp> loadVisitStepStoreCheck(@RequestBody ExecutorLoadReq redisHashKey) {
        StoreCheckStepExecuteDataResp dataResp = (StoreCheckStepExecuteDataResp) storeCheckVisitStepExecutor.load(redisHashKey);
        return Result.ok(dataResp);
    }


    /**
     * 查询拜访活动执行列表
     *
     * @param reqVo
     * @return
     */
    @CrmLog
    @ApiOperation(value = "拜访活动执行列表")
    @PostMapping("findVisitActivityExecutionList")
    public Result<List<SfaActivityExecutionEntityResp>> findVisitActivityExecutionList(@RequestBody LoadVisitActivityListReq reqVo) {
        List<SfaActivityExecutionEntityResp> pageResult = sfaVisitStepActivityExecutionService.loadVisitActivityList(reqVo);
//        if (reqVo.getActivityType().equals(SfaActivityEnum.activityType.COST_ACTIVITY.getVal())) {
//            reqVo.setActivityType(SfaActivityEnum.activityType.COST_ACTIVITY.getVal());
//            pageResult = sfaVisitStepActivityExecutionService.findCostActivityExecution(reqVo);
//        } else if (reqVo.getActivityType().equals(SfaActivityEnum.activityType.DISPLAY_ACTIVITY.getVal())) {
//            reqVo.setActivityType(SfaActivityEnum.activityType.DISPLAY_ACTIVITY.getVal());
//            pageResult = sfaVisitStepActivityExecutionService.loadVisitActivityList(reqVo);
//        } else if (reqVo.getActivityType().equals(SfaActivityEnum.activityType.TPM_ACTIVITY.getVal())) {
//            reqVo.setActivityType(SfaActivityEnum.activityType.TPM_ACTIVITY.getVal());
//        }
        return Result.ok(pageResult);
    }


    /**
     * 拜访步骤-活动执行
     *
     * @param visitStepExecuteReq
     * @return
     */
    @ApiOperation(value = "拜访步骤-活动执行")
    @PostMapping("/saveVisitStepActivity")
    @CrmLog
    public Result saveVisitStepActivity(@RequestBody VisitStepExecuteReq<ActivityStepExecuteData> visitStepExecuteReq) {
        ActivityStepExecuteData dataReq = visitStepExecuteReq.getStepExecuteData();
        if (null == dataReq) {
            throw new BusinessException("请求参数执行数据对象为空");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank(dataReq.getId())) {
            throw new BusinessException("活动执行明细ID为空");
        }

        SfaVisitStepActivityExecutionEntity executionEntity = this.sfaVisitStepActivityExecutionService.getById(visitStepExecuteReq.getStepExecuteData().getId());
        if (null == executionEntity) {
            throw new BusinessException("未查询到活动执行明细");
        }
        checkDistance(visitStepExecuteReq, executionEntity);
        if (SfaVisitEnum.visitStep.VISIT_STEP_DISPLAY.getVal().equals(executionEntity.getActivityType())) {
            activityDisplayVisitStepExecutor.execute(visitStepExecuteReq);
        } else {
            activityCostVisitStepExecutor.execute(visitStepExecuteReq);
        }
        return Result.ok();
    }

    /**
     * 距离校验
     *
     * @param visitStepExecuteReq
     * @param entity
     */
    private void checkDistance(VisitStepExecuteReq<ActivityStepExecuteData> visitStepExecuteReq, SfaVisitStepActivityExecutionEntity entity) {
        ActivityStepExecuteData stepExecuteData = visitStepExecuteReq.getStepExecuteData();
        if (org.apache.commons.lang3.StringUtils.isBlank(stepExecuteData.getLongitude())) {
            throw new BusinessException("经度为空");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank(stepExecuteData.getLatitude())) {
            throw new BusinessException("纬度为空");
        }
        //判断拜访客户经纬度不为空
        if (entity != null && entity.getLatitude() != null && entity.getLatitude() != null) {
            SfaVisitStepFromEntity stepFromEntity = sfaVisitStepFromService.lambdaQuery().eq(SfaVisitStepFromEntity::getId, visitStepExecuteReq.getFormId()).one();
            if (stepFromEntity != null && stepFromEntity.getLocateType().equals(YesNoEnum.yesNoEnum.Y.getValue())) {
                if (com.biz.crm.util.StringUtils.isNotEmpty(stepFromEntity.getDistance())) {
                    BigDecimal distance = new BigDecimal(stepFromEntity.getDistance()).setScale(2, BigDecimal.ROUND_HALF_DOWN);
                    log.info("当前步骤配置的距离:{}",distance);
                    log.info("当前位置的经度:{},纬度:{},拜访客户的经度:{},纬度:{}",stepExecuteData.getLongitude(),stepExecuteData.getLatitude(),entity.getLongitude(),entity.getLatitude());
                    double data = LocationUtils.getDistance(new BigDecimal(stepExecuteData.getLongitude()),
                            new BigDecimal(stepExecuteData.getLatitude()), new BigDecimal(entity.getLongitude()), new BigDecimal(entity.getLatitude()));
                    BigDecimal nowDistance = new BigDecimal(data).setScale(2, BigDecimal.ROUND_HALF_DOWN);
                    log.info("当前位置距离拜访客户的距离:{}",nowDistance);
                    if (distance.compareTo(nowDistance) == -1) {
                        throw new BusinessException("您未在客户距离" + distance + "M内，请前往客户地址进行操作！");
                    }
                }
            }
        }
    }

    /**
     * 拜访步骤-订单采集
     *
     * @param redisHashKey
     * @return
     */
    @ApiOperation(value = "拜访步骤-活动执行-查询表单执行数据")
    @PostMapping("/loadVisitStepActivity")
    @CrmLog
    public Result<ActivityStepExecuteDataResp> loadVisitStepActivity(@RequestBody ActivityExecutorLoadReq redisHashKey) {
        if (org.apache.commons.lang3.StringUtils.isBlank(redisHashKey.getId())) {
            throw new BusinessException("活动执行明细ID为空");
        }
        SfaVisitStepActivityExecutionEntity executionEntity = this.sfaVisitStepActivityExecutionService.getById(redisHashKey.getId());
        if (null == executionEntity) {
            throw new BusinessException("未查询到活动执行明细");
        }
        ActivityStepExecuteDataResp dataResp;
        if (SfaVisitEnum.visitStep.VISIT_STEP_DISPLAY.getVal().equals(executionEntity.getActivityType())) {
            dataResp = (ActivityStepExecuteDataResp) activityDisplayVisitStepExecutor.load(redisHashKey);
        } else {
            dataResp = (ActivityStepExecuteDataResp) activityCostVisitStepExecutor.load(redisHashKey);
        }
        return Result.ok(dataResp);
    }



    @CrmLog
    @ApiOperation(value = "拜访步骤-tpm活动-陈列协议-货品协议保存")
    @PostMapping("saveVisitStepGoodsTreaty")
    public Result saveVisitStepGoodsTreaty(@RequestBody VisitBaseVo<GoodsTreatyVo> vo){
        sfaAsTreatyService.saveVisitStepGoodsTreaty(vo);
        return Result.ok();
    }



    @CrmLog
    @ApiOperation(value = "拜访步骤-tpm活动-陈列协议-现金协议保存")
    @PostMapping("saveVisitStepCashTreaty")
    public Result saveVisitStepCashTreaty(@RequestBody VisitBaseVo<CashTreatyVo> vo){
        sfaAsTreatyService.saveVisitStepCashTreaty(vo);
        return Result.ok();
    }


    @CrmLog
    @ApiOperation(value = "拜访步骤-tpm活动-分销订单采集保存")
    @PostMapping("saveVisitStepDistributionOrder")
    public Result saveVisitStepDistributionOrder(@RequestBody VisitBaseVo<DistributionOrderVo> vo){
        sfaVisitStepOrderService.saveVisitStepDistributionOrder(vo);
        return Result.ok();
    }


    @CrmLog
    @ApiOperation(value = "拜访步骤-tpm活动-活动数据采集")
    @PostMapping("saveVisitStepActCollect")
    public Result saveVisitStepActCollect(@RequestBody VisitBaseVo<SfaTpmActCollectVo> vo){
        sfaVisitStepTpmActCollectService.saveVisitStepActCollect(vo);
        return Result.ok();
    }


    @CrmLog
    @ApiOperation(value = "拜访步骤-tpm活动-查询已完成的拜访历史tpm活动")
    @PostMapping("getVisitSuccessTpmAct")
    public Result<List<SfaTpmActRespVo>> getVisitSuccessTpmAct(@RequestBody ExecutorWorkbenchLoadReq loadReq){
        AssertUtils.isNotEmpty(loadReq.getVisitPlanInfoId(),"拜访明细id为空");
        return Result.ok(sfaTpmActDetailService.getVisitSuccessTpmAct(loadReq.getVisitPlanInfoId()));
    }


}
