package com.biz.crm.moblie.controller.visit;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitStepProcessReqVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitStepProgressRespVo;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.service.ISfaVisitStepProcessService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@Slf4j
@RestController
@RequestMapping("/visitstepprocess")
@Api(tags = "小程序端-日程页面-拜访-进度查询")
public class SfaVisitStepProcessController {

    @Resource
    private ISfaVisitStepProcessService iSfaVisitStepProcessService;

    /**
     * 查询当前门店拜访步骤进度
     *
     * @param vo
     * @return
     */
    @ApiOperation(value = "查询当前门店拜访步骤进度")
    @PostMapping("/visitstepprocess")
    @CrmLog
    public Result<SfaVisitStepProgressRespVo> visitStepProgress(@RequestBody SfaVisitStepProcessReqVo vo) {
        //拜访日期
        if (StringUtils.isEmpty(vo.getVisitDate())) {
            vo.setVisitDate(DateUtil.formatDate());
        }
        //登陆账号
        if (StringUtils.isEmpty(vo.getVisitUserName())) {
            String userName = UserUtils.getUser().getUsername();
            vo.setVisitUserName(userName);
        }
        SfaVisitStepProgressRespVo respVo = iSfaVisitStepProcessService.visitStepProgress(vo);
        return Result.ok(respVo);
    }

}
