package com.biz.crm.moblie.controller.visit.component;

import com.biz.crm.eunm.sfa.SfaActivityEnum;
import com.biz.crm.visitstep.req.LoadVisitActivityListReq;
import com.biz.crm.visitstep.resp.SfaActivityExecutionEntityResp;
import com.biz.crm.visitstep.service.ISfaVisitStepActivityExecutionService;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

@Component
public class ActivityExecuteHelper {
    @Resource
    private ISfaVisitStepActivityExecutionService sfaVisitStepActivityExecutionService;

    /**
     * 检查拜访步骤活动是否已经全部执行完成
     * @param redisHashKey
     * @param activityType
     * @return
     */
    public boolean activityStepCompleted(String redisHashKey, String activityType, String stepCode){
        LoadVisitActivityListReq reqVo = new LoadVisitActivityListReq();
        reqVo.setRedisHashKey(redisHashKey);
        reqVo.setActivityType(activityType);
        reqVo.setStepCode(stepCode);

        List<SfaActivityExecutionEntityResp> activityExecutionEntityResps =  this.sfaVisitStepActivityExecutionService.loadVisitActivityList(reqVo);
        for (SfaActivityExecutionEntityResp activityExecutionEntityResp : activityExecutionEntityResps) {
            if(SfaActivityEnum.StepActivityExecuteStatus.WAITING.getVal().equals(activityExecutionEntityResp.getExecuteStatus())){
                return false;
            }
        }
        return true;
    }
}
