package com.biz.crm.moblie.controller.visit.component;


import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoRedisData;
import lombok.Data;

/**
 * 拜访计划明细监听器
 *  @author: luoqi
 *  @Date: 2021-4-8 10:43
 *  @version: V1.0
 *  @Description:
 */
public interface VisitInfoPlanListener {
    /**
     * 计划生成事件
     * @param event
     */
    void created(VisitInfoPlanListenerEvent event);

    /**
     * 开始拜访事件
     * @param doneEvent
     */
    void begin(DoneEvent doneEvent);

    /**
     * 用户提交完成事件(包括异常提报)
     * @param doneEvent
     */
    void committed(DoneEvent doneEvent);

    /**
     * 场景:用户已开始拜访，状态为[拜访中],但未主动提交数据
     * 结算任务触发:[拜访中] -> [未完成]
     * 结算任务:后台程序会每天定时结算[未完成]、[已过期]的拜访计划
     *@see com.biz.crm.eunm.sfa.SfaVisitEnum.HelpVisitStatus
     *@see com.biz.crm.eunm.sfa.SfaVisitEnum.visitStatus
     * @param doneEvent
     */
    void noCommit(DoneEvent doneEvent);

    /**
     * 结算任务触发:[未拜访] -> [已过期]
     * 结算任务:后台程序会每天定时结算[未完成]、[已过期]的拜访计划
     * @see com.biz.crm.eunm.sfa.SfaVisitEnum.HelpVisitStatus
     * @see com.biz.crm.eunm.sfa.SfaVisitEnum.visitStatus
     * @param event
     */
    void overdue(VisitInfoPlanListenerEvent event);


    /**
     * 拜访步骤监听事件
     *  @author: luoqi
     *  @Date: 2021-4-8 14:53
     *  @version: V1.0
     *  @Description:
     */
    @Data
    class VisitInfoPlanListenerEvent{
        //拜访计划
        private SfaVisitPlanInfoEntity planInfoEntity;
    }

    /**
     * 拜访步骤监听事件
     *  @author: luoqi
     *  @Date: 2021-4-12 17:30
     *  @version: V1.0
     *  @Description:
     */
    @Data
    class DoneEvent extends VisitInfoPlanListenerEvent{
        //计划执行数据(缓存在redis)
        private SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData;
    }



}
