package com.biz.crm.moblie.controller.visit.component;

import com.biz.crm.base.VisitStep;
import com.biz.crm.common.CrmRedisHashKeyVo;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.resp.StepExecuteDataResp;


/**
 * 拜访步骤模板执行器,ExecuteReq:执行参数，Resp：执行数据加载返回数据
 *  @author: luoqi
 *  @since: 2021-3-4 22:04
 *  @version: V1.0
 */
public interface VisitStepExecutor<ExecuteReq extends VisitStepExecuteReq.StepExecuteDataReq, Resp extends StepExecuteDataResp, LoadParam extends CrmRedisHashKeyVo> extends VisitStep {
    String componentPostfix = "VisitStepExecutor";
    /**
     * 步骤执行
     * @param visitStepExecuteReq 执行参数
     */
    void execute(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq);

    /**
     * 离线数据处理
     * @param visitStepExecuteReq
     */
    void executeOffLine(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq);

    /**
     * 步骤执行数据加载
     * @param loadParam 数据加载参数
     * @return 表单执行数据
     */
    Resp load(LoadParam loadParam);
}
