package com.biz.crm.moblie.controller.visit.component.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmAttachment;
import com.biz.crm.eunm.sfa.SfaActivityEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepRedisExecutor;
import com.biz.crm.moblie.controller.visit.component.ActivityExecuteHelper;
import com.biz.crm.moblie.controller.visit.component.VisitDataDurabilityService;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ActivityExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.ActivityStepExecuteData;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorWorkbenchLoadReq;
import com.biz.crm.moblie.controller.visit.resp.StepExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.ActivityCostStepExecuteDataResp;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.model.SfaVisitStepActivityCostExecutionEsData;
import com.biz.crm.visitstep.model.SfaVisitStepActivityExecutionRedisData;
import com.biz.crm.visitstep.repositories.SfaVisitStepActivityCostExecutionEsDataRepositories;
import com.biz.crm.visitstep.req.LoadVisitActivityListReq;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstep.service.impl.SfaVisitStepActivityExecutionServiceImpl;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;


/**
 * 拜访步骤执行器-费用活动
 *  @author: luoqi
 *  @Date: 2021-1-19 13:54
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
@Component()
@ConditionalOnMissingBean(name = "activityCostVisitStepExecutorExpandImpl")
public class ActivityCostVisitStepExecutor<ExecuteReq extends ActivityStepExecuteData> extends AbstractVisitStepRedisExecutor<ExecuteReq, ActivityCostStepExecuteDataResp, ActivityExecutorLoadReq> {
    @Resource
    private SfaVisitStepActivityExecutionServiceImpl sfaVisitStepActivityExecutionServiceImpl;
    @Resource
    private ActivityExecuteHelper activityExecuteHelper;
    @Resource
    private SfaVisitStepActivityCostExecutionEsDataRepositories sfaVisitStepActivityCostExecutionEsDataRepositories;

    @Override
    protected VisitDataDurabilityService getVisitDataDurabilityService() {
        return sfaVisitStepActivityExecutionServiceImpl;
    }
    @Override
    protected String visitStepRegistry() {
        return SfaVisitEnum.visitStep.VISIT_STEP_COST.getVal();
    }

    /**
     * 步骤执行
     *
     * @param visitStepExecuteReq
     */
    @Override
    public void execute(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());

        SfaVisitStepActivityExecutionRedisData redisData = this.doExecute(visitStepExecuteReq, sfaVisitPlanInfoEntity.getId(), SfaActivityEnum.StepActivityExecuteStatus.EXECUTING,SfaVisitEnum.VISIT_OFF_LINE.online);
//        if(this.activityExecuteHelper.activityStepCompleted(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode(), redisData.getStepCode())){
//        }
        //费用活动只要做了一次，就更新步骤状态
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode(), visitRedisHashKey.getVisitBigType());
    }

    @Override
    public void executeOffLine(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());

        SfaVisitStepActivityExecutionRedisData redisData = this.doExecute(visitStepExecuteReq, sfaVisitPlanInfoEntity.getId(), SfaActivityEnum.StepActivityExecuteStatus.EXECUTING,SfaVisitEnum.VISIT_OFF_LINE.offline);
        //进行数据的转换
        this.controlDataTrans(visitStepExecuteReq);
        //费用活动只要做了一次，就更新步骤状态
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode(), visitRedisHashKey.getVisitBigType());
    }

    /**
     * 工作台-陈列活动-执行
     * @param visitStepExecuteReq
     */
    public void executeForWorkbench(VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        this.check(null, visitStepExecuteReq);
        ExecuteReq executeReq = visitStepExecuteReq.getStepExecuteData();
        visitStepExecuteReq.setRedisHashKey(executeReq.getId());
        this.doExecute(visitStepExecuteReq, executeReq.getId(), SfaActivityEnum.StepActivityExecuteStatus.COMPLETE,SfaVisitEnum.VISIT_OFF_LINE.online);
    }

    protected SfaVisitStepActivityExecutionRedisData doExecute(VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq, String visitPlanInfoId, SfaActivityEnum.StepActivityExecuteStatus executeStatus,SfaVisitEnum.VISIT_OFF_LINE lineType) {
        this.check(null, visitStepExecuteReq);
        SfaVisitStepActivityExecutionRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        redisData.setExecuteStatus(executeStatus.getVal());
        redisData.setVisitPlanInfoId(visitPlanInfoId);

        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        this.dataDurability(Lists.newArrayList(redisData), fromRespVo);
        return redisData;
    }
    @Override
    protected  List<? extends VisitStepListener.VisitStepListenerCommittedData> loadRedisDataList(ExecutorLoadReq loadParam){
        List<? extends SfaVisitStepActivityExecutionRedisData>  data = this.sfaVisitStepActivityExecutionServiceImpl.loadVisitActivityList(loadParam.getVisitInfoId(), SfaActivityEnum.activityType.COST_ACTIVITY.getVal());
        return data.stream()
                .filter(v -> SfaActivityEnum.StepActivityExecuteStatus.EXECUTING.getVal().equals(v.getExecuteStatus())
                        || SfaActivityEnum.StepActivityExecuteStatus.COMPLETE.getVal().equals(v.getExecuteStatus()))
                .map(v -> {
                    v.setExecuteStatus(SfaActivityEnum.StepActivityExecuteStatus.COMPLETE.getVal());
                    return v;
                }).collect(Collectors.toList());
    }
    /**
     * 组装 RedisData 数据对象
     * @param visitStepExecuteReq
     * @return
     */
    protected SfaVisitStepActivityExecutionRedisData buildRedisData(VisitStepExecuteReq<? extends ActivityStepExecuteData> visitStepExecuteReq){
        //加载活动数据
        ActivityStepExecuteData executeData = visitStepExecuteReq.getStepExecuteData();
        SfaVisitStepActivityCostExecutionEsData esData = (SfaVisitStepActivityCostExecutionEsData) this.getEsDataById(executeData.getId());
        CrmBeanUtil.copyPropertiesIgnoreEmpty(executeData, esData);
        esData.setRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        esData.setActivityRequireReqVoList(executeData.getActivityRequireReqVoList());
        esData.setActivityTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));

        UserRedis userRedis = UserUtils.getUser();
        esData.setUserName(userRedis.getUsername());
        esData.setRealName(userRedis.getUsername());
        esData.setPosCode(userRedis.getPoscode());
        esData.setPosName(userRedis.getPosname());
        esData.setOrgCode(userRedis.getOrgcode());
        esData.setOrgName(userRedis.getOrgname());
        return esData;
    }


    /**
     * 校验数据，可扩展
     * @param sfaVisitPlanInfoEntity
     * @param visitStepExecuteReq
     */
    protected void check(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq){
        if(StringUtils.isBlank(visitStepExecuteReq.getFormId())){
            throw new BusinessException("请指定表单id");
        }

        ActivityStepExecuteData stepExecuteData = visitStepExecuteReq.getStepExecuteData();
        if(null == stepExecuteData){
            throw new BusinessException("执行数据为空");
        }
        if(StringUtils.isBlank(stepExecuteData.getId())){
            throw new BusinessException("活动执行明细id为空");
        }
        List<ActivityStepExecuteData.ActivityRequireReqVo> activityRequireReqVoList = stepExecuteData.getActivityRequireReqVoList();
        if(!CollectionUtils.isEmpty(activityRequireReqVoList)){
            for (ActivityStepExecuteData.ActivityRequireReqVo requireReqVo : activityRequireReqVoList) {
                List<CrmAttachment> pictureList = requireReqVo.getPictureList();
                this.checkPics(pictureList, 1, 5, requireReqVo.getActivityRequireName());
            }
        }
    }




    /**
     * 步骤执行数据加载
     *
     * @param loadParam
     */
    @Override
    protected ActivityCostStepExecuteDataResp doLoad(ActivityExecutorLoadReq loadParam) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(loadParam.getRedisHashKey());
        this.loadAndCheckSfaVisitPlanInfoEntity(loadParam.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(loadParam.getFormId());

        ExecutorWorkbenchLoadReq param = new ExecutorWorkbenchLoadReq();
        param.setBizId(loadParam.getId());
        ActivityCostStepExecuteDataResp dataResp = this.doLoadEditPageForWorkbench(param);

        dataResp.setSfaVisitStepFrom(fromRespVo);
        this.controlDataToObj(dataResp);
        return dataResp;
    }



    /**
     * 查询ES的执行数据
     * @param id
     * @return
     */
    @Override
    public StepExecuteDataResp getEsDataById(String id) {
        Optional<SfaVisitStepActivityCostExecutionEsData> optional = this.sfaVisitStepActivityCostExecutionEsDataRepositories.findById(id);
        if(optional.isPresent()){
            return optional.get();
        }else{
            throw new BusinessException("未查询到该活动执行明细数据!");
        }
    }

    /**
     * 查询ES的执行数据
     *
     * @param visitPlanInfoId
     * @param stepCode
     * @return
     */
    @Override
    public StepExecuteDataResp getEsDataByVisitPlanInfo(String visitPlanInfoId, String stepCode) {
        return null;
    }



    /**
     * 加载工作台活动执行编辑页面数据
     *
     */
    @Override
    protected ActivityCostStepExecuteDataResp doLoadEditPageForWorkbench(ExecutorWorkbenchLoadReq param) {
        if(StringUtils.isBlank(param.getBizId())){
            throw new BusinessException("活动执行明细[BizId]为空");
        }
        SfaVisitStepActivityCostExecutionEsData redisData = (SfaVisitStepActivityCostExecutionEsData) this.getEsDataById(param.getBizId());
        ActivityCostStepExecuteDataResp dataResp = CrmBeanUtil.copy(redisData, ActivityCostStepExecuteDataResp.class);
        dataResp.setActivityRequireReqVoList(redisData.getActivityRequireReqVoList());
        SfaVisitStepFromRespVo sfaVisitStepFrom = redisData.getSfaVisitStepFrom();
        if(null == sfaVisitStepFrom){
            sfaVisitStepFrom = this.getFormData(redisData.getClientType(), redisData.getStepCode()
                    , param.getVisitBigType(), redisData.getClientSubclass());
        }
        dataResp.setSfaVisitStepFrom(sfaVisitStepFrom);
        return dataResp;

    }



}
