package com.biz.crm.moblie.controller.visit.component.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.base.*;
import com.biz.crm.base.utils.SfaAttachmentUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.sfa.AttachmentBizTypeEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepRedisExecutor;
import com.biz.crm.moblie.controller.visit.component.VisitDataDurabilityService;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.moblie.controller.visit.req.ClientReq;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.CompetitorStepExecuteData;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorWorkbenchLoadReq;
import com.biz.crm.moblie.controller.visit.resp.StepExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.CompetitorStepExecuteDataResp;
import com.biz.crm.moblie.controller.workbench.req.CompetitorWorkbenchDataReq;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.util.*;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.model.SfaVisitStepColletEntity;
import com.biz.crm.visitstep.model.SfaVisitStepColletEsData;
import com.biz.crm.visitstep.model.SfaVisitStepColletItemEntity;
import com.biz.crm.visitstep.model.SfaVisitStepColletRedisData;
import com.biz.crm.visitstep.repositories.SfaVisitStepColletEsDataRepositories;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstep.service.ISfaVisitStepColletItemService;
import com.biz.crm.visitstep.service.ISfaVisitStepColletService;
import com.biz.crm.visitstep.service.impl.SfaVisitStepColletServiceImpl;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Optional;


/**
 * 拜访步骤执行器-竞品采集
 *
 * @author: luoqi
 * @Date: 2021-3-5 16:13
 * @version: V1.0
 * @Description:
 */
@Slf4j
@Component()
@ConditionalOnMissingBean(name = "competitorVisitStepExecutorExpandImpl")
public class CompetitorVisitStepExecutor<ExecuteReq extends CompetitorStepExecuteData> extends AbstractVisitStepRedisExecutor<ExecuteReq, CompetitorStepExecuteDataResp, ExecutorLoadReq> {
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;

    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;

    @Resource
    private MdmOrgFeign mdmOrgFeign;
    @Resource
    private SfaVisitStepColletEsDataRepositories sfaVisitStepColletEsDataRepositories;

    @Resource
    private SfaVisitStepColletServiceImpl sfaVisitStepColletServiceImpl;

    @Resource
    private ISfaVisitStepColletService sfaVisitStepColletService;
    @Resource
    private ISfaVisitStepColletItemService sfaVisitStepColletItemService;

    @Override
    protected VisitDataDurabilityService getVisitDataDurabilityService() {
        return sfaVisitStepColletServiceImpl;
    }

    @Override
    protected String visitStepRegistry() {
        return SfaVisitEnum.visitStep.VISIT_STEP_COMPETITOR.getVal();
    }

    /**
     * 步骤执行
     *
     * @param visitStepExecuteReq
     */
    @Override
    public void execute(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());

        this.check(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        SfaVisitStepColletRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        log.info("-------------------------redis日志————————————————"+ JSON.toJSONString(sfaVisitPlanInfoEntity));
        this.buildEntity(sfaVisitPlanInfoEntity, redisData);
        redisData.setFormId(visitStepExecuteReq.getFormId());
        redisData.setRedisHashKey(visitStepExecuteReq.getRedisHashKey());
//        redisData.setActivityName(executeData.getActivityInfo());
        redisData.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());
        redisData.setLineType(SfaVisitEnum.VISIT_OFF_LINE.online);
        //更新步骤状态
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode(), visitRedisHashKey.getVisitBigType());
        //保存到redis
        this.redisService.hmset(redisData.redisHash(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode()).toString()
                , redisData.buildRedisDataForWrite(), SfaVisitPlanInfoEntity.CACHE_TIME);
    }

    @Override
    public void executeOffLine(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());

        SfaVisitStepColletRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        //数据校验
        super.check(visitStepExecuteReq);
        redisData.setFormId(visitStepExecuteReq.getFormId());
        redisData.setRedisHashKey(visitStepExecuteReq.getRedisHashKey());
//        redisData.setActivityName(executeData.getActivityInfo());
        redisData.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());
        redisData.setLineType(SfaVisitEnum.VISIT_OFF_LINE.offline);
        //更新步骤状态
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode(), visitRedisHashKey.getVisitBigType());
        //保存到redis
        this.redisService.hmset(redisData.redisHash(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode()).toString()
                , redisData.buildRedisDataForWrite(), SfaVisitPlanInfoEntity.CACHE_TIME);
    }

    /**
     * 工作台-竞品采集-执行
     *
     * @param visitStepExecuteReq
     */
    @Transactional
    public void executeForWorkbench(VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        String id = UUIDGenerator.generate();
        visitStepExecuteReq.setRedisHashKey(id);
        this.check(null, visitStepExecuteReq);
        SfaVisitStepColletRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        CompetitorWorkbenchDataReq dataReq = (CompetitorWorkbenchDataReq) visitStepExecuteReq.getStepExecuteData();
        this.buildEntity(dataReq, redisData);
        redisData.setId(id);
        redisData.setVisitPlanInfoId(id);
        redisData.setLineType(SfaVisitEnum.VISIT_OFF_LINE.online);
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        this.dataDurability(Lists.newArrayList(redisData), fromRespVo);
    }

    /**
     * 组装 RedisData 数据对象
     *
     * @param visitStepExecuteReq
     * @return
     */
    protected SfaVisitStepColletRedisData buildRedisData(VisitStepExecuteReq<? extends CompetitorStepExecuteData> visitStepExecuteReq) {
        CompetitorStepExecuteData executeData = visitStepExecuteReq.getStepExecuteData();
        SfaVisitStepColletRedisData redisData = CrmBeanUtil.copy(executeData, SfaVisitStepColletRedisData.class);
        redisData.setRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        redisData.setFormId(visitStepExecuteReq.getFormId());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        redisData.setStepCode(fromRespVo.getStepCode());
        redisData.setSfaVisitStepColletItemReqVos(executeData.getSfaVisitStepColletItemReqVos());
        redisData.setSfaVisitPictureReqVos(executeData.getSfaVisitPictureReqVos());
        return redisData;
    }

    /**
     * 组装参数，可扩展
     *
     * @param sfaVisitPlanInfoEntity
     * @param redisData
     */
    protected void buildEntity(ClientReq sfaVisitPlanInfoEntity, SfaVisitStepColletRedisData redisData) {
        this.checkClientReq(sfaVisitPlanInfoEntity);
        CrmBaseEntity.buildDefEntityData(redisData);
        log.info("-------------------------redis日志————————————————"+ JSON.toJSONString(sfaVisitPlanInfoEntity));
        log.info("------------------大日志---------------"+sfaVisitPlanInfoEntity.getClientType());
        if (SfaVisitEnum.ClientType.TERMINAL.getVal().equals(sfaVisitPlanInfoEntity.getClientType())) {
            this.injectOrgInfoOfTerminal(sfaVisitPlanInfoEntity, redisData);
        } else {
            this.injectOrgInfoOfTerminalCustomer(sfaVisitPlanInfoEntity, redisData);
        }

        //根据终端id查出他的组织Id（所属办事处）再根据组织Id查出他的上级组织（所属区域）

        if (sfaVisitPlanInfoEntity instanceof SfaVisitPlanInfoEntity) {
            this.buildClientData(redisData, (SfaVisitPlanInfoEntity) sfaVisitPlanInfoEntity);
        } else {
            this.buildClientData(redisData, sfaVisitPlanInfoEntity.getClientCode(), sfaVisitPlanInfoEntity.getClientType());
        }

//        redisData.setClientTypeName(sfaVisitPlanInfoEntity.getClientTypeName());

        UserRedis userRedis = UserUtils.getUser();
        redisData.setUserName(userRedis.getUsername());
        redisData.setRealName(userRedis.getUsername());
        redisData.setPosCode(userRedis.getPoscode());
        redisData.setPosName(userRedis.getPosname());
        redisData.setOrgCode(userRedis.getOrgcode());
        redisData.setOrgName(userRedis.getOrgname());

    }

    private void injectOrgInfoOfTerminal(ClientReq sfaVisitPlanInfoEntity, SfaVisitStepColletRedisData redisData) {
        //修改为陌拜不去查客户信息，此处之前在报错，导致无法提交竞品采集
        //陌拜不用去mdm查询客户信息
        if (sfaVisitPlanInfoEntity instanceof SfaVisitPlanInfoEntity &&
            SfaVisitEnum.VisitBigType.UNFAMILIAR_VISIT.getVal().equals(
                ((SfaVisitPlanInfoEntity) sfaVisitPlanInfoEntity).getVisitBigType())) {
            return;
        }
        MdmTerminalVo clientVo = mdmTerminalFeign.query(null, sfaVisitPlanInfoEntity.getClientCode()).getResult();
        if (null == clientVo) {
            throw new BusinessException("未查询到客户数据[" + sfaVisitPlanInfoEntity.getClientCode() + "]");
        }
        MdmOrgRespVo resultParent = mdmOrgFeign.getParentOrg(null, clientVo.getOrgCode()).getResult();
        //封装上级组织（所属区域）
        if (null != resultParent) {
            redisData.setClientAreaId(resultParent.getOrgCode());
            redisData.setClientArea(resultParent.getOrgName());
        }
        //封装组织Id（所属办事处）
        redisData.setClientOfficeId(clientVo.getOrgCode());
        redisData.setClientOffice(clientVo.getOrgName());
    }

    private void injectOrgInfoOfTerminalCustomer(ClientReq sfaVisitPlanInfoEntity, SfaVisitStepColletRedisData redisData) {
        MdmCustomerMsgRespVo clientVo = mdmCustomerMsgFeign.query(null, sfaVisitPlanInfoEntity.getClientCode()).getResult();
        if (null == clientVo) {
            throw new BusinessException("未查询到客户数据[" + sfaVisitPlanInfoEntity.getClientCode() + "]");
        }
        MdmOrgRespVo resultParent = mdmOrgFeign.getParentOrg(null, clientVo.getOrgCode()).getResult();
        //封装上级组织（所属区域）
        if (null != resultParent) {
            redisData.setClientAreaId(resultParent.getOrgCode());
            redisData.setClientArea(resultParent.getOrgName());
        }
        //封装组织Id（所属办事处）
        redisData.setClientOfficeId(clientVo.getOrgCode());
        redisData.setClientOffice(clientVo.getOrgName());
    }

    /**
     * 校验数据，可扩展
     *
     * @param entity
     * @param visitStepExecuteReq
     */
    protected void check(SfaVisitPlanInfoEntity entity, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        super.check(visitStepExecuteReq);
        //进行数据的转换
        this.controlDataTrans(visitStepExecuteReq);
        CompetitorStepExecuteData stepExecuteData = visitStepExecuteReq.getStepExecuteData();
        if (null == stepExecuteData) {
            throw new BusinessException("执行数据为空");
        }

        //判断拜访客户经纬度不为空
        super.checkLongitudeAndLatitude(visitStepExecuteReq, entity, stepExecuteData.getLongitude(), stepExecuteData.getLatitude());
//        if (entity != null && entity.getLatitude() != null && entity.getLatitude() != null) {
//            SfaVisitStepFromEntity stepFromEntity = sfaVisitStepFromService.lambdaQuery().eq(SfaVisitStepFromEntity::getId, visitStepExecuteReq.getFormId()).one();
//            if (stepFromEntity != null && stepFromEntity.getLocateType().equals(YesNoEnum.yesNoEnum.Y.getValue())) {
//                if (com.biz.crm.util.StringUtils.isNotEmpty(stepFromEntity.getDistance())) {
//                    if (StringUtils.isBlank(stepExecuteData.getLongitude())) {
//                        throw new BusinessException("经度为空");
//                    }
//                    if (StringUtils.isBlank(stepExecuteData.getLatitude())) {
//                        throw new BusinessException("纬度为空");
//                    }
//                    BigDecimal distance = new BigDecimal(stepFromEntity.getDistance()).setScale(2, BigDecimal.ROUND_HALF_DOWN);
//                    log.info("当前步骤配置的距离:{}",distance);
//                    log.info("当前位置的经度:{},纬度:{},拜访客户的经度:{},纬度:{}",stepExecuteData.getLongitude(),stepExecuteData.getLatitude(),entity.getLongitude(),entity.getLatitude());
//                    double data = LocationUtils.getDistance(new BigDecimal(stepExecuteData.getLongitude()),
//                            new BigDecimal(stepExecuteData.getLatitude()), entity.getLongitude(), entity.getLatitude());
//                    BigDecimal nowDistance = new BigDecimal(data).setScale(2, BigDecimal.ROUND_HALF_DOWN);
//                    log.info("当前位置距离拜访客户的距离:{}",nowDistance);
//                    if (distance.compareTo(nowDistance) == -1) {
//                        throw new BusinessException("您未在客户距离" + distance + "M内，请前往客户地址进行操作！");
//                    }
//                }
//            }
//        }
        if (CollectionUtils.isEmpty(stepExecuteData.getSfaVisitStepColletItemReqVos())) {
            throw new BusinessException("竞品商品清单为空");
        }
        List<CrmAttachment> sfaVisitPictureReqVos = stepExecuteData.getSfaVisitPictureReqVos();
        this.checkPics(sfaVisitPictureReqVos, 1, 5, "竞品");
    }


    /**
     * 步骤执行数据加载
     *
     * @param redisHashKey
     */
    @Override
    protected CompetitorStepExecuteDataResp doLoad(ExecutorLoadReq redisHashKey) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(redisHashKey.getRedisHashKey());
        this.loadAndCheckSfaVisitPlanInfoEntity(redisHashKey.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(redisHashKey.getFormId());
        SfaVisitStepColletRedisData redisData = (SfaVisitStepColletRedisData) this.redisService
                .hmget(SfaVisitStepColletRedisData.getInstance().redisHash(redisHashKey.getRedisHashKey(), fromRespVo.getStepCode()).toString(), redisHashKey.getRedisHashKey());
        if (null == redisData) {
            redisData = new SfaVisitStepColletRedisData() {{
                List list = Lists.newArrayList();
                this.setSfaVisitPictureReqVos(list);
                this.setSfaVisitStepColletItemReqVos(list);
            }};
        }
        CompetitorStepExecuteDataResp dataResp = CrmBeanUtil.copy(redisData, CompetitorStepExecuteDataResp.class);
        dataResp.setSfaVisitPictureReqVos(redisData.getSfaVisitPictureReqVos());
        dataResp.setSfaVisitStepColletItemReqVos(redisData.getSfaVisitStepColletItemReqVos());
        dataResp.setSfaVisitStepFrom(fromRespVo);
        this.controlDataToObj(dataResp);
        return dataResp;
    }

    /**
     * 查询ES的执行数据
     *
     * @param id
     * @return
     */
    @Override
    public StepExecuteDataResp getEsDataById(String id) {
        Optional<SfaVisitStepColletEsData> optional = this.sfaVisitStepColletEsDataRepositories.findById(id);
        if (optional.isPresent()) {
            return optional.get();
        } else {
            throw new BusinessException("未查询到该数据详细信息!");
        }
    }

    /**
     * 查询ES的执行数据
     *
     * @param visitPlanInfoId
     * @param stepCode
     * @return
     */
    @Override
    public StepExecuteDataResp getEsDataByVisitPlanInfo(String visitPlanInfoId, String stepCode) {
        StepExecuteDataResp esData = this.sfaVisitStepColletEsDataRepositories.findByVisitPlanInfoIdAndStepCode(visitPlanInfoId, stepCode);
        return esData;
    }


    /**
     * 加载工作台编辑页面数据
     *
     * @param loadParam
     */
    @Override
    protected CompetitorStepExecuteDataResp doLoadEditPageForWorkbench(ExecutorWorkbenchLoadReq loadParam) {
        CompetitorStepExecuteDataResp dataResp;

        String bizId = loadParam.getBizId();
        if (StringUtils.isNotBlank(loadParam.getVisitPlanInfoId())) {
            if (StringUtils.isBlank(loadParam.getStepCode())) {
                throw new BusinessException("步骤编码为空");
            }
            dataResp = buildDataResp(loadParam.getVisitPlanInfoId(), loadParam.getStepCode(), null);
            return dataResp;
        }
        if (StringUtils.isBlank(bizId)) {
            SfaClientData clientData = SfaClientHelper.loadClientData(loadParam.getClientType(), loadParam.getClientCode());
            if (StringUtils.isBlank(loadParam.getStepCode())) {
                throw new BusinessException("步骤编码为空");
            }
            dataResp = new CompetitorStepExecuteDataResp() {{
                List list = Lists.newArrayList();
                this.setSfaVisitPictureReqVos(list);
                this.setSfaVisitStepColletItemReqVos(list);
            }};
            dataResp.setSfaVisitStepFrom(this.getFormData(loadParam.getClientType(), loadParam.getStepCode(), loadParam.getVisitBigType(), clientData.getClientSubclass()));
            return dataResp;
        } else {
            dataResp = buildDataResp(null, null, bizId);
            return dataResp;
        }
    }

    /**
     * 查询竟品采集详情
     * @return
     */
    protected CompetitorStepExecuteDataResp buildDataResp(String visitPlanInfoId,String stepCode,String bizId){
        //初始一个查询方法
        LambdaQueryChainWrapper<SfaVisitStepColletEntity> colletLambdaQuery = sfaVisitStepColletService.lambdaQuery();
        SfaVisitStepColletEntity colletEntity = colletLambdaQuery
                .eq(StringUtils.isNotBlank(stepCode),SfaVisitStepColletEntity::getStepCode,stepCode)
                .eq(StringUtils.isNotBlank(visitPlanInfoId),SfaVisitStepColletEntity::getVisitPlanInfoId, visitPlanInfoId)
                .eq(StringUtils.isNotBlank(bizId),SfaVisitStepColletEntity::getId,bizId)
                .one();

        CompetitorStepExecuteDataResp dataResp = CrmBeanUtil.copy(colletEntity, CompetitorStepExecuteDataResp.class);
        List<SfaVisitStepColletItemEntity> itemEntities = sfaVisitStepColletItemService.lambdaQuery()
                .eq(SfaVisitStepColletItemEntity::getColletId, colletEntity.getId())
                .eq(SfaVisitStepColletItemEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode())
                .list();
        List<CompetitorStepExecuteData.ColletItemReqVo> sfaVisitStepColletItemReqVos = CrmBeanUtil.copyList(itemEntities, CompetitorStepExecuteData.ColletItemReqVo.class);
        dataResp.setSfaVisitStepColletItemReqVos(sfaVisitStepColletItemReqVos);
        List<CrmAttachment> attachments = CrmBeanUtil.copyList(SfaAttachmentUtil.getList(AttachmentBizTypeEnum.VISIT_STEP_COLLET, colletEntity.getId()), CrmAttachment.class);
        dataResp.setSfaVisitPictureReqVos(attachments);
        this.controlDataToObj(dataResp);
        return dataResp;
    }



    private CompetitorStepExecuteDataResp buildDataResp(SfaVisitStepColletEsData redisData) {
        if (null == redisData) {
            throw new BusinessException("未查询到该数据详细信息!");
        }
        CompetitorStepExecuteDataResp dataResp = CrmBeanUtil.copy(redisData, CompetitorStepExecuteDataResp.class);
        dataResp.setSfaVisitPictureReqVos(redisData.getSfaVisitPictureReqVos());
        dataResp.setSfaVisitStepColletItemReqVos(redisData.getSfaVisitStepColletItemReqVos());
        dataResp.setSfaVisitStepFrom(redisData.getSfaVisitStepFrom());
        return dataResp;
    }

    /**
     * 将数据传输到关系数据库
     *
     * @param loadParam
     * @return
     */
    @Override
    protected List<? extends VisitStepListener.VisitStepListenerCommittedData> loadRedisDataList(ExecutorLoadReq loadParam) {
        SfaVisitStepColletRedisData redisData = (SfaVisitStepColletRedisData) this.redisService
                .hmget(SfaVisitStepColletRedisData.getInstance().redisHash(loadParam.getRedisHashKey(), loadParam.getStepCode()).toString(), loadParam.getRedisHashKey());
        if (null == redisData) {
            log.warn("将数据传输到ES: 没有执行数据需要传输（可能用户没有执行该步骤），executorLoadReq={}", JsonPropertyUtil.toJsonString(loadParam));
            return null;
        }
//        redisData = this.sfaVisitStepColletService.save(redisData);
        return Lists.newArrayList(redisData);
    }


}
