package com.biz.crm.moblie.controller.visit.component.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.collection.controller.resp.VisitStepResp;
import com.biz.crm.collection.service.ISfaVisitRoleDirectoryService;
import com.biz.crm.customer.controller.SfaBusinessDetailListener;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepListener;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepRedisExecutor;
import com.biz.crm.moblie.controller.visit.component.VisitDataDurabilityService;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.moblie.controller.visit.req.ClientReq;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorWorkbenchLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.HelpScoreStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.StepExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.HelpScoreStepExecuteDataResp;
import com.biz.crm.util.*;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.model.SfaVisitStepHelpScoreEsData;
import com.biz.crm.visitstep.model.SfaVisitStepHelpScoreRedisData;
import com.biz.crm.visitstep.repositories.SfaVisitStepHelpScoreEsDataRepositories;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstep.service.impl.SfaVisitStepHelpScoreServiceImpl;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;


/**
 * 拜访步骤执行器-协访评价
 *  @author: luoqi
 *  @Date: 2021-3-5 16:13
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
@Component
@ConditionalOnMissingBean(name = "helpScoreVisitStepExecutorExpandImpl")
public class HelpScoreVisitStepExecutor<ExecuteReq extends HelpScoreStepExecuteData> extends AbstractVisitStepRedisExecutor<ExecuteReq, HelpScoreStepExecuteDataResp, ExecutorLoadReq> {

    @Resource
    private SfaVisitStepHelpScoreEsDataRepositories sfaVisitStepHelpScoreEsDataRepositories;
    @Resource
    private ISfaVisitRoleDirectoryService sfaVisitRoleDirectoryService;
    @Resource
    private SfaVisitStepHelpScoreServiceImpl visitDataDurabilityService;
    @Override
    protected VisitDataDurabilityService getVisitDataDurabilityService() {
        return visitDataDurabilityService;
    }

    @Override
    protected String visitStepRegistry() {
        return SfaVisitEnum.visitStep.VISIT_STEP_HELP_SCORE.getVal();
    }
    /**
     * 对监听器列表的个性化扩展
     * @param listeners
     */
    @Override
    protected List<AbstractVisitStepListener> customerListeners(List<AbstractVisitStepListener> listeners){
        if(null == listeners){
            return null;
        }
        //屏蔽客户业务动态监听器对该步骤的监听
        return listeners.stream().filter(v -> !(v instanceof SfaBusinessDetailListener)).collect(Collectors.toList());
    }



    @Override
    public void execute(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());

        this.check(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        SfaVisitStepHelpScoreRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        this.buildEntity(sfaVisitPlanInfoEntity, redisData);
        redisData.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());

        redisData.setCoverHelpOrgCode(sfaVisitPlanInfoEntity.getCoverHelpOrgCode());
        redisData.setCoverHelpOrgName(sfaVisitPlanInfoEntity.getCoverHelpOrgName());
        redisData.setCoverHelpPosCode(sfaVisitPlanInfoEntity.getCoverHelpPosCode());
        redisData.setCoverHelpPosName(sfaVisitPlanInfoEntity.getCoverHelpPosName());
        redisData.setCoverHelpRealName(sfaVisitPlanInfoEntity.getCoverHelpRealName());
        redisData.setCoverHelpUserName(sfaVisitPlanInfoEntity.getCoverHelpUserName());
        redisData.setHelpDefenseId(sfaVisitPlanInfoEntity.getVisitPlanCode());

        redisData.setLineType(SfaVisitEnum.VISIT_OFF_LINE.online);

        //更新步骤状态
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode(), visitRedisHashKey.getVisitBigType());

        //保存到redis
        this.redisService.hmset(redisData.redisHash(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode()).toString()
                , redisData.buildRedisDataForWrite(), SfaVisitPlanInfoEntity.CACHE_TIME);
    }

    @Override
    public void executeOffLine(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());

        this.check(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        SfaVisitStepHelpScoreRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        this.buildEntity(sfaVisitPlanInfoEntity, redisData);
        redisData.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());

        redisData.setCoverHelpOrgCode(sfaVisitPlanInfoEntity.getCoverHelpOrgCode());
        redisData.setCoverHelpOrgName(sfaVisitPlanInfoEntity.getCoverHelpOrgName());
        redisData.setCoverHelpPosCode(sfaVisitPlanInfoEntity.getCoverHelpPosCode());
        redisData.setCoverHelpPosName(sfaVisitPlanInfoEntity.getCoverHelpPosName());
        redisData.setCoverHelpRealName(sfaVisitPlanInfoEntity.getCoverHelpRealName());
        redisData.setCoverHelpUserName(sfaVisitPlanInfoEntity.getCoverHelpUserName());
        redisData.setHelpDefenseId(sfaVisitPlanInfoEntity.getVisitPlanCode());

        redisData.setLineType(SfaVisitEnum.VISIT_OFF_LINE.offline);

        //更新步骤状态
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode(), visitRedisHashKey.getVisitBigType());

        //保存到redis
        this.redisService.hmset(redisData.redisHash(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode()).toString()
                , redisData.buildRedisDataForWrite(), SfaVisitPlanInfoEntity.CACHE_TIME);
    }


    /**
     * 组装 RedisData 数据对象
     * @param visitStepExecuteReq
     * @return
     */
    protected SfaVisitStepHelpScoreRedisData buildRedisData(VisitStepExecuteReq<? extends HelpScoreStepExecuteData> visitStepExecuteReq){
        HelpScoreStepExecuteData executeData = visitStepExecuteReq.getStepExecuteData();
        SfaVisitStepHelpScoreRedisData redisData = CrmBeanUtil.copy(executeData, SfaVisitStepHelpScoreRedisData.class);
        redisData.setRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        redisData.setFormId(visitStepExecuteReq.getFormId());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        redisData.setStepCode(fromRespVo.getStepCode());
        redisData.setAttachmentExt1(executeData.getAttachmentExt1());
        redisData.setAttachmentExt2(executeData.getAttachmentExt2());
        redisData.setHelpScoreDetailList(executeData.getHelpScoreDetailList());
        return redisData;
    }

    /**
     * 步骤执行数据加载
     *
     * @param redisHashKey
     */
    @Override
    protected HelpScoreStepExecuteDataResp doLoad(ExecutorLoadReq redisHashKey) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(redisHashKey.getRedisHashKey());
        final SfaVisitPlanInfoEntity planInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(redisHashKey.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(redisHashKey.getFormId());
        SfaVisitStepHelpScoreRedisData redisData = (SfaVisitStepHelpScoreRedisData)this.redisService
                .hmget(SfaVisitStepHelpScoreRedisData.getInstance().redisHash(redisHashKey.getRedisHashKey(), fromRespVo.getStepCode()).toString(), redisHashKey.getRedisHashKey());

        if(null == redisData){
            redisData = new SfaVisitStepHelpScoreRedisData(){{
                this.setHelpScoreDetailList(loadCoverVisitStepList(planInfoEntity));
                List list = Lists.newArrayList();
                this.setAttachmentExt1(list);
                this.setAttachmentExt2(list);
            }};
        }
        HelpScoreStepExecuteDataResp dataResp = CrmBeanUtil.copy(redisData, HelpScoreStepExecuteDataResp.class);
        dataResp.setHelpScoreDetailList(redisData.getHelpScoreDetailList());
        dataResp.setAttachmentExt1(redisData.getAttachmentExt1());
        dataResp.setAttachmentExt2(redisData.getAttachmentExt2());
        dataResp.setSfaVisitStepFrom(fromRespVo);
        return dataResp;
    }

    /**
     * 加载被协防人的拜访步骤列表
     * @param planInfoEntity
     * @return
     */
    protected List<HelpScoreStepExecuteData.HelpScoreDetailReqVo> loadCoverVisitStepList(SfaVisitPlanInfoEntity planInfoEntity){
        String coverHelpUserName = planInfoEntity.getCoverHelpUserName();
        String coverHelpPosCode = planInfoEntity.getCoverHelpPosCode();
        if(StringUtils.isBlank(coverHelpPosCode)){
            coverHelpPosCode = coverHelpUserName;
        }
        //被协防人的拜访步骤列表
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(planInfoEntity.getVisitDate()
                ,coverHelpUserName , coverHelpPosCode, SfaVisitEnum.VisitBigType.VISIT.getVal(), planInfoEntity.getClientType(), planInfoEntity.getClientCode());

        Map<String, VisitStepResp> roleVisitStepMap = sfaVisitRoleDirectoryService.findRoleVisitStepMap(visitRedisHashKey, planInfoEntity.getClientSubclass());
        Map<String, String> dict = DictUtil.getDictValueMapsByCodes(SfaVisitEnum.SfaVisitQualified.DICT_CODE);
        List<HelpScoreStepExecuteData.HelpScoreDetailReqVo> helpScoreDetailList = roleVisitStepMap.values().stream().map(v -> {
            HelpScoreStepExecuteData.HelpScoreDetailReqVo temp = CrmBeanUtil.copy(v, HelpScoreStepExecuteData.HelpScoreDetailReqVo.class);
            temp.setQualified(SfaVisitEnum.SfaVisitQualified.QUALIFIED.getVal());
            temp.setQualifiedName(dict.get(temp.getQualified()));
            return temp;
        }).sorted(Comparator.comparing(HelpScoreStepExecuteData.HelpScoreDetailReqVo :: getSort)).collect(Collectors.toList());
        return helpScoreDetailList;
    }

    /**
     * 查询ES的执行数据
     *
     * @param visitPlanInfoId
     * @param stepCode
     * @return
     */
    @Override
    public StepExecuteDataResp getEsDataByVisitPlanInfo(String visitPlanInfoId, String stepCode) {
        StepExecuteDataResp esData = this.sfaVisitStepHelpScoreEsDataRepositories.findByVisitPlanInfoIdAndStepCode(visitPlanInfoId, stepCode);
        return esData;
    }

    /**
     * 查询ES的执行数据
     * @param id
     * @return
     */
    @Override
    public StepExecuteDataResp getEsDataById(String id) {
        Optional<SfaVisitStepHelpScoreEsData> optional = this.sfaVisitStepHelpScoreEsDataRepositories.findById(id);
        if(optional.isPresent()){
            return optional.get();
        }else{
            throw new BusinessException("未查询到该数据详细信息!");
        }
    }

    /**
     * 加载工作台编辑页面数据
     *
     * @param loadParam
     */
    @Override
    protected HelpScoreStepExecuteDataResp doLoadEditPageForWorkbench(ExecutorWorkbenchLoadReq loadParam) {
        String bizId = loadParam.getBizId();
        String visitPlanInfoId = loadParam.getVisitPlanInfoId();
        if(StringUtils.isNotBlank(visitPlanInfoId)){
            if(StringUtils.isBlank(loadParam.getStepCode())){
                throw new BusinessException("步骤编码为空");
            }
            SfaVisitStepHelpScoreEsData redisData = (SfaVisitStepHelpScoreEsData) this.getEsDataByVisitPlanInfo(visitPlanInfoId, loadParam.getStepCode());
            return this.buildDataResp(redisData);
        }
        if(StringUtils.isBlank(bizId)){
            throw new BusinessException("请指定业务ID!");
        }else{
            SfaVisitStepHelpScoreEsData esData = (SfaVisitStepHelpScoreEsData)this.getEsDataById(bizId);
            return this.buildDataResp(esData);

        }
    }
    private HelpScoreStepExecuteDataResp buildDataResp(SfaVisitStepHelpScoreEsData esData){
        if(null == esData){
            throw new BusinessException("未查询到该数据详细信息!");
        }
        HelpScoreStepExecuteDataResp dataResp = CrmBeanUtil.copy(esData, HelpScoreStepExecuteDataResp.class);
        dataResp.setHelpScoreDetailList(esData.getHelpScoreDetailList());
        dataResp.setAttachmentExt1(esData.getAttachmentExt1());
        dataResp.setAttachmentExt2(esData.getAttachmentExt2());
        dataResp.setSfaVisitStepFrom(esData.getSfaVisitStepFrom());
        return dataResp;
    }

    /**
     * 组装参数，可扩展
     * @param sfaVisitPlanInfoEntity
     * @param redisData
     */
    protected void buildEntity(ClientReq sfaVisitPlanInfoEntity, SfaVisitStepHelpScoreRedisData redisData){
        this.checkClientReq(sfaVisitPlanInfoEntity);
        CrmBaseEntity.buildDefEntityData(redisData);

        if(sfaVisitPlanInfoEntity instanceof SfaVisitPlanInfoEntity){
            this.buildClientData(redisData, (SfaVisitPlanInfoEntity)sfaVisitPlanInfoEntity);
        }else {
            this.buildClientData(redisData, sfaVisitPlanInfoEntity.getClientCode(), sfaVisitPlanInfoEntity.getClientType());
        }
        redisData.setScoreTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        redisData.setScoreDate(LocalDateTime.now().format(CrmDateUtils.yyyyMMdd));
        redisData.setScoreYearMonth(LocalDateTime.now().format(CrmDateUtils.yyyyMM));
        redisData.setScoreYear(LocalDateTime.now().format(CrmDateUtils.yyyy));

        UserRedis userRedis = UserUtils.getUser();
        redisData.setUserName(userRedis.getUsername());
        redisData.setRealName(userRedis.getUsername());
        redisData.setPosCode(userRedis.getPoscode());
        redisData.setPosName(userRedis.getPosname());
        redisData.setOrgCode(userRedis.getOrgcode());
        redisData.setOrgName(userRedis.getOrgname());

    }

    /**
     * 校验数据，可扩展
     * @param sfaVisitPlanInfoEntity
     * @param visitStepExecuteReq
     */
    protected void check(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq){
        super.check(visitStepExecuteReq);

        HelpScoreStepExecuteData executeData = visitStepExecuteReq.getStepExecuteData();
        if(null == executeData){
            throw new BusinessException("执行数据为空");
        }
        if(StringUtils.isBlank(executeData.getKeyQuestions())){
            throw new BusinessException("重点问题记录为空");
        }
        if(StringUtils.isBlank(executeData.getHelpDefenseSummary())){
            throw new BusinessException("协访总结为空");
        }
        //评价明细校验
        this.checkHelpScoreDetail(sfaVisitPlanInfoEntity, executeData);
    }

    /**
     * 评价明细校验
     * @param executeData
     */
    protected void checkHelpScoreDetail(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, HelpScoreStepExecuteData executeData){
        List<HelpScoreStepExecuteData.HelpScoreDetailReqVo> helpScoreDetailList = executeData.getHelpScoreDetailList();
        if(null == helpScoreDetailList){
            return;
        }
        StringJoiner joiner = new StringJoiner(",");
        for (HelpScoreStepExecuteData.HelpScoreDetailReqVo helpScoreDetailReqVo : helpScoreDetailList) {
            if(StringUtils.isBlank(helpScoreDetailReqVo.getIcon())){
                throw new BusinessException("协访评价步骤图片为空");
            }
            if(StringUtils.isBlank(helpScoreDetailReqVo.getStepCode())){
                throw new BusinessException("协访评价步骤编码为空");
            }
            if(StringUtils.isBlank(helpScoreDetailReqVo.getStepName())){
                throw new BusinessException("协访评价步骤名称为空");
            }

            if(StringUtils.isBlank(helpScoreDetailReqVo.getQualified())){
                joiner.add(helpScoreDetailReqVo.getStepName());

            }
        }
        if(joiner.length() > 0){
            throw new BusinessException("步骤[" + joiner.toString() + "]未完成协访评价");
        }
    }

    /**
     * 将数据传输到关系数据库
     *
     * @param loadParam
     * @return
     */
    @Override
    protected List<? extends VisitStepListener.VisitStepListenerCommittedData> loadRedisDataList(ExecutorLoadReq loadParam) {
        SfaVisitStepHelpScoreRedisData redisData = (SfaVisitStepHelpScoreRedisData)this.redisService
                .hmget(SfaVisitStepHelpScoreRedisData.getInstance().redisHash(loadParam.getRedisHashKey(), loadParam.getStepCode()).toString(), loadParam.getRedisHashKey());
        if(null == redisData){
            log.warn("将数据传输到ES: 没有执行数据需要传输（可能用户没有执行该步骤），executorLoadReq={}", JsonPropertyUtil.toJsonString(loadParam));
            return null;
        }
        return Lists.newArrayList(redisData);
    }




}
