package com.biz.crm.moblie.controller.visit.component.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.achievement.controller.AchievementRecordsMQSend;
import com.biz.crm.achievement.service.ISfaAchievementAccomplishRecordService;
import com.biz.crm.asexecution.service.ISfaAsExecutionService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.SfaClientData;
import com.biz.crm.base.SfaClientHelper;
import com.biz.crm.base.utils.ProcessUtil;
import com.biz.crm.enums.SfaOrderSourceEnum;
import com.biz.crm.eunm.ActivitiEnum;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepRedisExecutor;
import com.biz.crm.moblie.controller.visit.component.VisitDataDurabilityService;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.moblie.controller.visit.req.ClientReq;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorWorkbenchLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.OrderStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.StepExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.OrderAsExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.OrderStepExecuteDataResp;
import com.biz.crm.moblie.controller.workbench.req.OrderAsDataReq;
import com.biz.crm.moblie.controller.workbench.req.OrderWorkbenchDataReq;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.sfa.achievement.req.SfaAchievementAccomplishRecordReqVo;
import com.biz.crm.nebular.sfa.asexecution.req.SfaAsExecuteOrderProductReqVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActRespVo;
import com.biz.crm.tpmact.mapper.SfaTpmActMapper;
import com.biz.crm.util.*;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.model.*;
import com.biz.crm.visitstep.repositories.SfaVisitStepOrderEsDataRepositories;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderItemService;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderService;
import com.biz.crm.visitstep.service.impl.SfaVisitStepOrderServiceImpl;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;


/**
 * 拜访步骤执行器-订单采集
 *
 * @author: luoqi
 * @Date: 2021-3-5 16:13
 * @version: V1.0
 * @Description:
 */
@Slf4j
@Component()
@ConditionalOnMissingBean(name = "orderVisitStepExecutorExpandImpl")
public class OrderVisitStepExecutor<ExecuteReq extends OrderStepExecuteData> extends AbstractVisitStepRedisExecutor<ExecuteReq, OrderStepExecuteDataResp, ExecutorLoadReq> {

    @Resource
    private SfaVisitStepOrderEsDataRepositories sfaVisitStepOrderEsDataRepositories;
    @Resource
    private ISfaAsExecutionService sfaAsExecutionService;
    @Resource
    private ISfaAchievementAccomplishRecordService sfaAchievementAccomplishRecordService;
    @Resource
    protected SfaVisitStepOrderServiceImpl sfaVisitStepOrderServiceImpl;
    @Resource
    private ISfaVisitStepOrderService sfaVisitStepOrderService;
    @Resource
    private ISfaVisitStepOrderItemService sfaVisitStepOrderItemService;
    @Resource
    private SfaTpmActMapper sfaTpmActMapper;


    @Override
    protected VisitDataDurabilityService getVisitDataDurabilityService() {
        return sfaVisitStepOrderServiceImpl;
    }

    @Override
    protected String visitStepRegistry() {
        return SfaVisitEnum.visitStep.VISIT_STEP_ORDER.getVal();
    }


    /**
     * 步骤执行
     *
     * @param visitStepExecuteReq
     */
    @Override
    public void execute(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());

        this.check(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        SfaVisitStepOrderRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        this.buildEntity(sfaVisitPlanInfoEntity, redisData);
        redisData.setOrderSource(SfaOrderSourceEnum.VISIT.getCode());
        redisData.setOrderSourceName(SfaOrderSourceEnum.VISIT.getDesc());
        redisData.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());
        redisData.setLineType(SfaVisitEnum.VISIT_OFF_LINE.online);
        //更新步骤状态
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode(), visitRedisHashKey.getVisitBigType());
        //保存到redis
        this.redisService.hmset(redisData.redisHash(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode()).toString()
                , redisData.buildRedisDataForWrite(), SfaVisitPlanInfoEntity.CACHE_TIME);
    }

    @Override
    public void executeOffLine(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());

        super.check(visitStepExecuteReq);
        this.checkHead(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        this.checkBizData(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        SfaVisitStepOrderRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        this.buildEntity(sfaVisitPlanInfoEntity, redisData);
        redisData.setOrderSource(SfaOrderSourceEnum.VISIT.getCode());
        redisData.setOrderSourceName(SfaOrderSourceEnum.VISIT.getDesc());
        redisData.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());
        redisData.setLineType(SfaVisitEnum.VISIT_OFF_LINE.offline);
        //更新步骤状态
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode(), visitRedisHashKey.getVisitBigType());
        //保存到redis
        this.redisService.hmset(redisData.redisHash(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode()).toString()
                , redisData.buildRedisDataForWrite(), SfaVisitPlanInfoEntity.CACHE_TIME);
    }

    /**
     * 工作台-订单采集-执行
     *
     * @param visitStepExecuteReq
     */
    public void executeForWorkbench(VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        //获取业务数据
        OrderWorkbenchDataReq dataReq = (OrderWorkbenchDataReq) visitStepExecuteReq.getStepExecuteData();
        dataReq.convert();
//        dataReq.convert();

//        visitStepExecuteReq.get
        SfaVisitStepOrderEsData sfaVisitStepOrderEsData = null;
        //判断新增还是更新
        if (com.biz.crm.util.StringUtils.isNotEmpty(dataReq.getId())) {
            Optional<SfaVisitStepOrderEsData> optionalVisitStepOrderEsData = this.sfaVisitStepOrderEsDataRepositories.findById(dataReq.getId());
            if (!optionalVisitStepOrderEsData.isPresent()) {
                throw new BusinessException("修改失败未在ES找到id对应数据");
            }
            sfaVisitStepOrderEsData = optionalVisitStepOrderEsData.get();
            OrderStepExecuteData stepExecuteData = visitStepExecuteReq.getStepExecuteData();
            stepExecuteData.setOrderSource(sfaVisitStepOrderEsData.getOrderSource());
        }
        this.checkForWorkbench(null, visitStepExecuteReq);

        //判断新增还是更新
        if (null != sfaVisitStepOrderEsData) {

            this.updateOrderEsData(visitStepExecuteReq, sfaVisitStepOrderEsData);
            this.buildRedisDataForUpate(sfaVisitStepOrderEsData, visitStepExecuteReq.getStepExecuteData());
            this.dataDurability(Lists.newArrayList(sfaVisitStepOrderEsData), sfaVisitStepOrderEsData.getSfaVisitStepFrom());
            return;
        }
        SfaVisitStepOrderRedisData redisData = this.buildRedisData(visitStepExecuteReq);

        String id = UUIDGenerator.generate();
        redisData.setId(id);
        redisData.setRedisHashKey(id);
        redisData.setVisitPlanInfoId(id);
        this.doExecuteForWorkbench(redisData, visitStepExecuteReq, SfaOrderSourceEnum.WORKBENCH);

    }

    /**
     * 泛型使用 OrderWorkbenchDataReq ，商品项泛型使用 OrderItemAsReqVo
     * 订单采集-执行-方案活动
     *
     * @param
     */
    public void executeForAs(OrderAsDataReq<OrderAsDataReq.OrderItemAsReqVo> dataReq) {
        dataReq.convert();
        VisitStepExecuteReq visitStepExecuteReq = new VisitStepExecuteReq();
        visitStepExecuteReq.setRedisHashKey(VisitStepExecuteReq.REDIS_HASH_KEY_DEF);
        visitStepExecuteReq.setFormId(SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_ORDER.getVal());
        visitStepExecuteReq.setStepExecuteData(dataReq);
//        this.checkHead(null, visitStepExecuteReq);
//        this.check(null, visitStepExecuteReq);
//        this.checkForWorkbench(null, visitStepExecuteReq);
        this.checkForAs(null, visitStepExecuteReq);
        Optional<SfaVisitStepOrderEsData> optionalVisitStepOrderEsData = this.sfaVisitStepOrderEsDataRepositories.findById(dataReq.getId());
        if (optionalVisitStepOrderEsData.isPresent()) {
            SfaVisitStepOrderEsData sfaVisitStepOrderEsData = optionalVisitStepOrderEsData.get();
            this.updateOrderEsData(visitStepExecuteReq, sfaVisitStepOrderEsData);
            return;
        }
        SfaVisitStepOrderRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        redisData.setId(dataReq.getId());
        if (StringUtils.isBlank(dataReq.getVisitPlanInfoId())) {
            redisData.setVisitPlanInfoId(dataReq.getId());
        } else {
            redisData.setVisitPlanInfoId(dataReq.getVisitPlanInfoId());
        }
        this.buildEntity(dataReq, redisData);
        this.doExecuteForWorkbench(redisData, visitStepExecuteReq, SfaOrderSourceEnum.SCHEME);
    }

    /**
     * 工作台-订单采集-执行
     *
     * @param visitStepExecuteReq
     * @param orderSourceEnum
     */
    protected void doExecuteForWorkbench(SfaVisitStepOrderRedisData redisData, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq, SfaOrderSourceEnum orderSourceEnum) {

        redisData.setOrderSource(orderSourceEnum.getCode());
        redisData.setOrderSourceName(orderSourceEnum.getDesc());
        ClientReq dataReq = (ClientReq) visitStepExecuteReq.getStepExecuteData();
        this.buildEntity(dataReq, redisData);
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        this.dataDurability(Lists.newArrayList(redisData), fromRespVo);
//        //新增订单不走审批，直接将数据写入绩效记录表
//        UserRedis user = UserUtils.getUser();
//        SfaAchievementAccomplishRecordReqVo reqVo = CrmBeanUtil.copy(dataReq, SfaAchievementAccomplishRecordReqVo.class);
//        reqVo.setRelationId(redisData.getId())
//                .setIndexCode(SfaVisitEnum.indexType.XD.getCode())
//                .setCustomerCode(dataReq.getClientCode())
//                .setUsername(user.getUsername())
//                .setObjectPosCode(user.getPoscode())
//                .setCreateOrgCode(user.getOrgcode());
//        AchievementRecordsMQSend.saveAchievementRecordsMQ(reqVo);
//        this.doTransToEs(redisData, fromRespVo);
    }


    /**
     * 订单审批状态修改——用于审批流回调
     *
     * @param activitiCallBackVo 审批流回调对象
     * @return void
     * @method updateOrderApprovalStatus
     * @date: 2021/3/19 11:34
     * @author: YuanZiJian
     */
    public void updateOrderApprovalStatus(ActivitiCallBackVo activitiCallBackVo) {
        String processState = activitiCallBackVo.getProcessState().toString();
        Optional<SfaVisitStepOrderEsData> repositoriesById = this.sfaVisitStepOrderEsDataRepositories.findById(activitiCallBackVo.getFormNo());
        AssertUtils.isTrue(repositoriesById.isPresent(), "拜访步骤不存在或已删除！");
        SfaVisitStepOrderEsData sfaVisitStepOrderEsData = repositoriesById.get();
        if (ActivitiEnum.processState.PASS.getVal().equals(processState)) {
            //审批通过
            //设置审批状态
            sfaVisitStepOrderEsData.setApprovalStatus(SfaCommonEnum.orderApporvalEnum.NORMAL.getValue());
            sfaVisitStepOrderEsData.setApprovalStatusName(SfaCommonEnum.orderApporvalEnum.NORMAL.getDesc());
            //审批通过，绩效记录生效
            sfaAchievementAccomplishRecordService.reuseByRelationId(sfaVisitStepOrderEsData.getId());
            if (SfaOrderSourceEnum.SCHEME.getCode().equals(sfaVisitStepOrderEsData.getOrderSource())) {
                //将订单商品 转换成 方案活动套餐列表
                OrderAsExecuteDataResp orderAsExecuteDataResp = new OrderAsExecuteDataResp();
                orderAsExecuteDataResp.setSfaVisitStepOrderItems(sfaVisitStepOrderEsData.getSfaVisitStepOrderItems());
                orderAsExecuteDataResp.convert();
                SfaAsExecuteOrderProductReqVo sfaAsExecuteOrderProductReqVo = new SfaAsExecuteOrderProductReqVo();
                sfaAsExecuteOrderProductReqVo.setExecuteId(sfaVisitStepOrderEsData.getId());
                sfaAsExecuteOrderProductReqVo.setSfaActSchemeSetmealRespVos(orderAsExecuteDataResp.getSfaActSchemeSetmealRespVos());
                //订单修改商品会同步修改活动执行商品信息
                sfaAsExecutionService.updateExecutionProduct(sfaAsExecuteOrderProductReqVo);
            }
        }
        if (ActivitiEnum.processState.REJECT.getVal().equals(processState)) {
            //审批驳回
            sfaVisitStepOrderEsData.setApprovalStatus(SfaCommonEnum.orderApporvalEnum.REJECT.getValue());
            sfaVisitStepOrderEsData.setApprovalStatusName(SfaCommonEnum.orderApporvalEnum.REJECT.getDesc());
        }
        if (ActivitiEnum.processState.ROLLBACK.getVal().equals(processState)) {
            //审批追回
            sfaVisitStepOrderEsData.setApprovalStatus(SfaCommonEnum.orderApporvalEnum.ROLLBACK.getValue());
            sfaVisitStepOrderEsData.setApprovalStatusName(SfaCommonEnum.orderApporvalEnum.ROLLBACK.getDesc());
        }
        this.dataDurability(Lists.newArrayList(sfaVisitStepOrderEsData), sfaVisitStepOrderEsData.getSfaVisitStepFrom());
    }

    /**
     * 订单修改操作
     *
     * @param visitStepExecuteReq
     * @return void
     * @method updateOrderEsData
     * @date: 2021/3/18 19:48
     * @author: YuanZiJian
     */
    private void updateOrderEsData(VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq, SfaVisitStepOrderEsData sfaVisitStepOrderEsData) {
        OrderStepExecuteData orderStepExecuteData = visitStepExecuteReq.getStepExecuteData();


        CrmBeanUtil.copyPropertiesIgnoreEmpty(orderStepExecuteData, sfaVisitStepOrderEsData);
        sfaVisitStepOrderEsData.setSfaVisitStepOrderItems(orderStepExecuteData.getSfaVisitStepOrderItems());
        sfaVisitStepOrderEsData.setApprovalStatus(SfaCommonEnum.orderApporvalEnum.APPROVAL.getValue());
        sfaVisitStepOrderEsData.setApprovalStatusName(SfaCommonEnum.orderApporvalEnum.APPROVAL.getDesc());
        //提交审批
        sfaVisitStepOrderEsData.setProcessNo(ProcessUtil.startProcess(sfaVisitStepOrderEsData.getId(), ActivitiEnum.FormTypeEnum.ORDER));
        //修改订单，绩效记录失效
        sfaAchievementAccomplishRecordService.deleteByRelationId(sfaVisitStepOrderEsData.getId());
//        //更新订单的sfa业务信息
//        this.sfaVisitStepOrderEsDataRepositories.save(sfaVisitStepOrderEsData);
    }

    /**
     * 组装 RedisData 数据对象
     *
     * @param visitStepExecuteReq
     * @return
     */
    protected SfaVisitStepOrderRedisData buildRedisData(VisitStepExecuteReq<? extends OrderStepExecuteData> visitStepExecuteReq) {
        OrderStepExecuteData executeData = visitStepExecuteReq.getStepExecuteData();
        SfaVisitStepOrderRedisData redisData = CrmBeanUtil.copy(executeData, SfaVisitStepOrderRedisData.class);

        redisData.setFormId(visitStepExecuteReq.getFormId());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        redisData.setStepCode(fromRespVo.getStepCode());
        redisData.setRedisHashKey(visitStepExecuteReq.getRedisHashKey());


        redisData.setOrderTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        redisData.setOrderDate(LocalDateTime.now().format(CrmDateUtils.yyyyMMdd));
        redisData.setOrderYearMonth(LocalDateTime.now().format(CrmDateUtils.yyyyMM));
        redisData.setOrderYear(LocalDateTime.now().format(CrmDateUtils.yyyy));
        redisData.setApprovalStatus(SfaCommonEnum.orderApporvalEnum.NORMAL.getValue());
        redisData.setApprovalStatusName(SfaCommonEnum.orderApporvalEnum.NORMAL.getDesc());
        redisData.setCustomerCode(executeData.getCustomerCode());
        redisData.setCustomerName(executeData.getCustomerName());

        this.buildRedisDataForUpate(redisData, executeData);

        return redisData;
    }

    protected void buildRedisDataForUpate(SfaVisitStepOrderRedisData redisData, OrderStepExecuteData executeData) {
        List<OrderAsDataReq.OrderItemAsReqVo> itemAsReqVos = executeData.getSfaVisitStepOrderItems();
        redisData.setSfaVisitStepOrderItems(itemAsReqVos);
        redisData.setAddress(executeData.getAddress());
        redisData.setContacts(executeData.getContacts());
        redisData.setTelephone(executeData.getTelephone());
        redisData.setExpectReceive(executeData.getExpectReceive());
        if (StringUtils.isNotEmpty(executeData.getRemarks())) {
            redisData.setRemarks(executeData.getRemarks());
        }
        BigDecimal price = BigDecimal.ZERO;
        for (OrderAsDataReq.OrderItemAsReqVo itemAsReqVo : itemAsReqVos) {
            if (null != itemAsReqVo.getPrice() && null != itemAsReqVo.getQuantity()) {
                price = price.add(itemAsReqVo.getPrice().multiply(itemAsReqVo.getQuantity()));
            }
        }
        redisData.setTotalPrice(price);
    }

    /**
     * 组装参数，可扩展
     *
     * @param sfaVisitPlanInfoEntity
     * @param redisData
     */
    protected void buildEntity(ClientReq sfaVisitPlanInfoEntity, SfaVisitStepOrderRedisData redisData) {
        this.checkClientReq(sfaVisitPlanInfoEntity);
        CrmBaseEntity.buildDefEntityData(redisData);
        if (sfaVisitPlanInfoEntity instanceof SfaVisitPlanInfoEntity) {
            this.buildClientData(redisData, (SfaVisitPlanInfoEntity) sfaVisitPlanInfoEntity);
        } else {
            this.buildClientData(redisData, sfaVisitPlanInfoEntity.getClientCode(), sfaVisitPlanInfoEntity.getClientType());
        }
        UserRedis userRedis = UserUtils.getUser();
        redisData.setUserName(userRedis.getUsername());
        redisData.setRealName(userRedis.getRealname());
        redisData.setPosCode(userRedis.getPoscode());
        redisData.setPosName(userRedis.getPosname());
        redisData.setOrgCode(userRedis.getOrgcode());
        redisData.setOrgName(userRedis.getOrgname());

    }

    protected void checkHead(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        OrderStepExecuteData stepExecuteData = visitStepExecuteReq.getStepExecuteData();
        if (null == stepExecuteData) {
            throw new BusinessException("执行数据为空");
        }
        //非方案活动，校验收货地址
        if (!SfaOrderSourceEnum.SCHEME.getCode().equals(stepExecuteData.getOrderSource())) {
            if (StringUtils.isBlank(stepExecuteData.getAddress())) {
                throw new BusinessException("收货地址为空");
            }
        }

        if (StringUtils.isBlank(stepExecuteData.getContacts())) {
            throw new BusinessException("联系人为空");
        }

//        if(StringUtils.isBlank(stepExecuteData.getCustomerCode())){
//            throw new BusinessException("上级客户编码为空");
//        }
//        if(StringUtils.isBlank(stepExecuteData.getCustomerName())){
//            throw new BusinessException("上级客户名称为空");
//        }
        if (StringUtils.isBlank(stepExecuteData.getTelephone())) {
            throw new BusinessException("联系人电话为空");
        }
    }

    /**
     * 校验数据，可扩展
     *
     * @param entity
     * @param visitStepExecuteReq
     */
    protected void check(SfaVisitPlanInfoEntity entity, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        OrderStepExecuteData stepExecuteData = visitStepExecuteReq.getStepExecuteData();
        if (StringUtils.isBlank(stepExecuteData.getId())) {
            super.check(visitStepExecuteReq);
        }
        //进行数据的转换
        this.controlDataTrans(visitStepExecuteReq);
        //判断拜访客户经纬度不为空
        super.checkLongitudeAndLatitude(visitStepExecuteReq, entity, stepExecuteData.getLongitude(), stepExecuteData.getLatitude());
//        if (entity != null && entity.getLatitude() != null && entity.getLatitude() != null) {
//            SfaVisitStepFromEntity stepFromEntity = sfaVisitStepFromService.lambdaQuery().eq(SfaVisitStepFromEntity::getId, visitStepExecuteReq.getFormId()).one();
//            if (stepFromEntity != null && stepFromEntity.getLocateType().equals(YesNoEnum.yesNoEnum.Y.getValue())) {
//                if (com.biz.crm.util.StringUtils.isNotEmpty(stepFromEntity.getDistance())) {
//                    if (StringUtils.isBlank(stepExecuteData.getLongitude())) {
//                        throw new BusinessException("经度为空");
//                    }
//                    if (StringUtils.isBlank(stepExecuteData.getLatitude())) {
//                        throw new BusinessException("纬度为空");
//                    }
//                    BigDecimal distance = new BigDecimal(stepFromEntity.getDistance()).setScale(2, BigDecimal.ROUND_HALF_DOWN);
//                    log.info("当前步骤配置的距离:{}",distance);
//                    log.info("当前位置的经度:{},纬度:{},拜访客户的经度:{},纬度:{}",stepExecuteData.getLongitude(),stepExecuteData.getLatitude(),entity.getLongitude(),entity.getLatitude());
//                    double data = LocationUtils.getDistance(new BigDecimal(stepExecuteData.getLongitude()),
//                            new BigDecimal(stepExecuteData.getLatitude()), entity.getLongitude(), entity.getLatitude());
//                    BigDecimal nowDistance = new BigDecimal(data).setScale(2, BigDecimal.ROUND_HALF_DOWN);
//                    log.info("当前位置距离拜访客户的距离:{}",nowDistance);
//                    if (distance.compareTo(nowDistance) == -1) {
//                        throw new BusinessException("您未在客户距离" + distance + "M内，请前往客户地址进行操作！");
//                    }
//                }
//            }
//        }
        this.checkHead(entity, visitStepExecuteReq);
        this.checkBizData(entity, visitStepExecuteReq);
    }

    protected void checkBizData(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        OrderStepExecuteData stepExecuteData = visitStepExecuteReq.getStepExecuteData();
        List<OrderStepExecuteData.OrderItemReqVo> sfaVisitStepOrderItems = (List<OrderStepExecuteData.OrderItemReqVo>) stepExecuteData.getSfaVisitStepOrderItems();
        if (CollectionUtils.isEmpty(sfaVisitStepOrderItems)) {
            throw new BusinessException("商品清单为空");
        }
        OrderStepExecuteData.OrderItemReqVo sfaVisitStepOrderItemTemp = null;
        for (OrderStepExecuteData.OrderItemReqVo sfaVisitStepOrderItem : sfaVisitStepOrderItems) {
//            if(StringUtils.isBlank(sfaVisitStepOrderItem.getPicUrl())){
//                throw new BusinessException("商品照片为空");
//            }
            if (StringUtils.isBlank(sfaVisitStepOrderItem.getProductCode())) {
                throw new BusinessException("商品编码为空");
            }
            if (StringUtils.isBlank(sfaVisitStepOrderItem.getProductName())) {
                throw new BusinessException("商品名称为空");
            }
            if (StringUtils.isBlank(sfaVisitStepOrderItem.getSeriesCode())) {
                throw new BusinessException("商品系列编码为空");
            }
            if (StringUtils.isBlank(sfaVisitStepOrderItem.getSeriesName())) {
                throw new BusinessException("商品系列名称为空");
            }
            //非方案活动，校验商品单位
            if (!SfaOrderSourceEnum.SCHEME.getCode().equals(stepExecuteData.getOrderSource())) {
                if (StringUtils.isBlank(sfaVisitStepOrderItem.getUnit())) {
                    throw new BusinessException("商品单位为空");
                }
                if (StringUtils.isBlank(sfaVisitStepOrderItem.getUnitName())) {
                    throw new BusinessException("商品单位名称为空");
                }
            }

            if (null == sfaVisitStepOrderItem.getQuantity()) {
                throw new BusinessException("商品数量为空");
            }
//            if(null == sfaVisitStepOrderItem.getPrice()){
//                throw new BusinessException("商品价格为空");
//            }
            sfaVisitStepOrderItemTemp = sfaVisitStepOrderItem;

        }
        //sfa订单明细对象转换成方案活动订单明细对象，解决redis反序列问题
        if (sfaVisitStepOrderItemTemp instanceof OrderStepExecuteData.OrderItemReqVo) {
            List<OrderAsDataReq.OrderItemAsReqVo> orderItemAsReqVos = CrmBeanUtil.copyList(sfaVisitStepOrderItems, OrderAsDataReq.OrderItemAsReqVo.class);
            stepExecuteData.setSfaVisitStepOrderItems(orderItemAsReqVos);
        }
    }

    /**
     * 工作台请求来源校验
     *
     * @param sfaVisitPlanInfoEntity
     * @param visitStepExecuteReq
     */
    protected void checkForWorkbench(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        if (StringUtils.isBlank(visitStepExecuteReq.getFormId())) {
            throw new BusinessException("请指定表单id");
        }
        this.checkHead(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        this.checkBizData(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        OrderWorkbenchDataReq stepExecuteData = (OrderWorkbenchDataReq) visitStepExecuteReq.getStepExecuteData();
        if (StringUtils.isBlank(stepExecuteData.getClientCode())) {
            throw new BusinessException("网点编码为空");
        }
        if (StringUtils.isBlank(stepExecuteData.getClientName())) {
            throw new BusinessException("网点名称为空");
        }
        if (StringUtils.isBlank(stepExecuteData.getClientType())) {
            throw new BusinessException("网点类型为空");
        }
    }

    /**
     * 方案活动校验
     *
     * @param visitStepExecuteReq
     */
    protected void checkForAs(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        OrderStepExecuteData stepExecuteData = visitStepExecuteReq.getStepExecuteData();
        if (null == stepExecuteData) {
            throw new BusinessException("执行数据为空");
        }
//        if(StringUtils.isBlank(stepExecuteData.getAddress())){
//            throw new BusinessException("收货地址为空");
//        }
//        if(StringUtils.isBlank(stepExecuteData.getContacts())){
//            throw new BusinessException("联系人为空");
//        }

//        if(StringUtils.isBlank(stepExecuteData.getCustomerCode())){
//            throw new BusinessException("上级客户编码为空");
//        }
//        if(StringUtils.isBlank(stepExecuteData.getCustomerName())){
//            throw new BusinessException("上级客户名称为空");
//        }
//        if(StringUtils.isBlank(stepExecuteData.getTelephone())){
//            throw new BusinessException("联系人电话为空");
//        }

        List<OrderAsDataReq.OrderItemAsReqVo> sfaVisitStepOrderItems = (List<OrderAsDataReq.OrderItemAsReqVo>) stepExecuteData.getSfaVisitStepOrderItems();
        if (StringUtils.isBlank(stepExecuteData.getId())) {
            throw new BusinessException("订单id为空");
        }
        if (CollectionUtils.isEmpty(sfaVisitStepOrderItems)) {
            throw new BusinessException("商品清单为空");
        }
        for (OrderAsDataReq.OrderItemAsReqVo sfaVisitStepOrderItem : sfaVisitStepOrderItems) {
//            if(StringUtils.isBlank(sfaVisitStepOrderItem.getExecutionId())){
//                throw new BusinessException("订单商品方案执行id为空");
//            }
            if (StringUtils.isBlank(sfaVisitStepOrderItem.getItmeType())) {
                throw new BusinessException("订单商品类型为空");
            }
            if (StringUtils.isBlank(sfaVisitStepOrderItem.getSetmealId())) {
                throw new BusinessException("订单商品方案套餐id为空");
            }
//            if(StringUtils.isBlank(sfaVisitStepOrderItem.getSetmealName())){
//                throw new BusinessException("订单商品方案套餐名称为空");
//            }

        }
    }

    /**
     * 查询ES的执行数据
     *
     * @param visitPlanInfoId
     * @param stepCode
     * @return
     */
    @Override
    public StepExecuteDataResp getEsDataByVisitPlanInfo(String visitPlanInfoId, String stepCode) {
        StepExecuteDataResp esData = this.sfaVisitStepOrderEsDataRepositories.findByVisitPlanInfoIdAndStepCode(visitPlanInfoId, stepCode);
        return esData;
    }

    /**
     * 查询ES的执行数据
     *
     * @param id
     * @return
     */
    @Override
    public StepExecuteDataResp getEsDataById(String id) {
        Optional<SfaVisitStepOrderEsData> optional = this.sfaVisitStepOrderEsDataRepositories.findById(id);
        if (optional.isPresent()) {
            return optional.get();
        } else {
            throw new BusinessException("未查询到该数据详细信息!");
        }
    }

    /**
     * 加载工作台编辑页面数据
     *
     * @param loadParam
     */
    @Override
    protected OrderStepExecuteDataResp doLoadEditPageForWorkbench(ExecutorWorkbenchLoadReq loadParam) {
        String bizId = loadParam.getBizId();
        String visitPlanInfoId = loadParam.getVisitPlanInfoId();
        if (StringUtils.isNotBlank(visitPlanInfoId)) {
            if (StringUtils.isBlank(loadParam.getStepCode())) {
                throw new BusinessException("步骤编码为空");
            }
            return this.buildDataResp(visitPlanInfoId, loadParam.getStepCode(), null);
        }
        if (StringUtils.isBlank(bizId)) {
            SfaClientData clientData = SfaClientHelper.loadClientData(loadParam.getClientType(), loadParam.getClientCode());
            if (StringUtils.isBlank(loadParam.getStepCode())) {
                throw new BusinessException("步骤编码为空");
            }
            OrderStepExecuteDataResp dataResp = new OrderStepExecuteDataResp() {{
                List list = Lists.newArrayList();
                this.setSfaVisitStepOrderItems(list);
            }};
            dataResp.setSfaVisitStepFrom(this.getFormData(loadParam.getClientType(), loadParam.getStepCode(), loadParam.getVisitBigType(), clientData.getClientSubclass()));
            return dataResp;
        } else {
            return this.buildDataResp(null, null, bizId);
        }

    }

    private OrderStepExecuteDataResp buildDataResp(SfaVisitStepOrderEsData esData) {
        if (null == esData) {
            throw new BusinessException("未查询到该数据详细信息!");
        }
        OrderStepExecuteDataResp dataResp;
        if (SfaOrderSourceEnum.SCHEME.getCode().equals(esData.getOrderSource())) {
            dataResp = CrmBeanUtil.copy(esData, OrderAsExecuteDataResp.class);
            dataResp.setSfaVisitStepOrderItems(CrmBeanUtil.copyList(esData.getSfaVisitStepOrderItems(), OrderAsDataReq.OrderItemAsReqVo.class));
        } else {
            dataResp = CrmBeanUtil.copy(esData, OrderStepExecuteDataResp.class);
            dataResp.setSfaVisitStepOrderItems(esData.getSfaVisitStepOrderItems());
        }

        dataResp.convert();
        dataResp.setSfaVisitStepFrom(esData.getSfaVisitStepFrom());
        List<OrderStepExecuteData.OrderItemReqVo> itemReqVos = dataResp.getSfaVisitStepOrderItems();
        BigDecimal totalPrice = BigDecimal.ZERO;
        totalPrice.setScale(2, BigDecimal.ROUND_UP);
        if (null != itemReqVos) {
            for (OrderStepExecuteData.OrderItemReqVo itemReqVo : itemReqVos) {
                BigDecimal temp = itemReqVo.getPrice();
                BigDecimal quantity = itemReqVo.getQuantity();
                if (null != temp && null != quantity) {
                    totalPrice = totalPrice.add(temp.multiply(quantity));
                }
            }
        }
        dataResp.setTotalPrice(totalPrice);
        return dataResp;
    }

    /**
     * 组装详情数据信息
     *
     * @param visitPlanInfoId
     * @param stepCode
     * @param bizId
     * @return
     */
    private OrderStepExecuteDataResp buildDataResp(String visitPlanInfoId, String stepCode, String bizId) {
        OrderStepExecuteDataResp dataResp;
        LambdaQueryChainWrapper<SfaVisitStepOrderEntity> wrapper = sfaVisitStepOrderService.lambdaQuery();
        SfaVisitStepOrderEntity orderEntity = wrapper
                .eq(StringUtils.isNotBlank(visitPlanInfoId), SfaVisitStepOrderEntity::getVisitPlanInfoId, visitPlanInfoId)
                .eq(StringUtils.isNotBlank(stepCode), SfaVisitStepOrderEntity::getStepCode, stepCode)
                .eq(StringUtils.isNotBlank(bizId), SfaVisitStepOrderEntity::getId, bizId).one();
        if (SfaOrderSourceEnum.SCHEME.getCode().equals(orderEntity.getOrderSource())) {
            dataResp = CrmBeanUtil.copy(orderEntity, OrderAsExecuteDataResp.class);
            List<SfaVisitStepOrderItemEntity> list = sfaVisitStepOrderItemService.lambdaQuery()
                    .eq(SfaVisitStepOrderItemEntity::getOrderId, orderEntity.getId())
                    .list();
            dataResp.setSfaVisitStepOrderItems(CrmBeanUtil.copyList(list, OrderAsDataReq.OrderItemAsReqVo.class));
        } else {
            dataResp = CrmBeanUtil.copy(orderEntity, OrderStepExecuteDataResp.class);
            if (null != orderEntity) {
                List<SfaVisitStepOrderItemEntity> itemEntityList = sfaVisitStepOrderItemService.lambdaQuery()
                        .eq(SfaVisitStepOrderItemEntity::getOrderId, orderEntity.getId()).list();
                List<OrderStepExecuteData.OrderItemReqVo> itemReqVos = CrmBeanUtil.copyList(itemEntityList, OrderStepExecuteData.OrderItemReqVo.class);
                dataResp.setSfaVisitStepOrderItems(itemReqVos);
            }
        }
        dataResp.convert();
        if (StringUtils.isNotBlank(orderEntity.getFormId())) {
            dataResp.setSfaVisitStepFrom(this.getFormData(orderEntity.getFormId()));
        }
        List<OrderStepExecuteData.OrderItemReqVo> itemReqVos = dataResp.getSfaVisitStepOrderItems();
        BigDecimal totalPrice = BigDecimal.ZERO;
        totalPrice.setScale(2, BigDecimal.ROUND_UP);
        if (null != itemReqVos) {
            for (OrderStepExecuteData.OrderItemReqVo itemReqVo : itemReqVos) {
                BigDecimal temp = itemReqVo.getPrice();
                BigDecimal quantity = itemReqVo.getQuantity();
                if (null != temp && null != quantity) {
                    totalPrice = totalPrice.add(temp.multiply(quantity));
                }
            }
        }
        dataResp.setTotalPrice(totalPrice);
        //判断是tpm活动
        if (orderEntity.getOrderSource().equals(SfaOrderSourceEnum.TPMACT.getCode())) {
            SfaTpmActRespVo tpmActInfo = sfaTpmActMapper.findTpmActInfo(orderEntity.getActDetailCode());
            dataResp.setSfaTpmActRespVo(tpmActInfo);
        }
        return dataResp;
    }

    /**
     * 步骤执行数据加载
     *
     * @param redisHashKey
     */
    @Override
    protected OrderStepExecuteDataResp doLoad(ExecutorLoadReq redisHashKey) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(redisHashKey.getRedisHashKey());
        this.loadAndCheckSfaVisitPlanInfoEntity(redisHashKey.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(redisHashKey.getFormId());
        SfaVisitStepOrderRedisData redisData = (SfaVisitStepOrderRedisData) this.redisService
                .hmget(SfaVisitStepOrderRedisData.getInstance().redisHash(redisHashKey.getRedisHashKey(), fromRespVo.getStepCode()).toString(), redisHashKey.getRedisHashKey());
        if (null == redisData) {
            redisData = new SfaVisitStepOrderRedisData() {{
                List list = Lists.newArrayList();
                this.setSfaVisitStepOrderItems(list);
            }};
        }

        OrderStepExecuteDataResp dataResp = CrmBeanUtil.copy(redisData, OrderStepExecuteDataResp.class);
        dataResp.setSfaVisitStepOrderItems(redisData.getSfaVisitStepOrderItems());
        dataResp.setSfaVisitStepFrom(fromRespVo);
        this.controlDataToObj(dataResp);
        return dataResp;
    }


    /**
     * 将数据传输到关系数据库
     *
     * @param loadParam
     * @return
     */
    @Override
    protected List<? extends VisitStepListener.VisitStepListenerCommittedData> loadRedisDataList(ExecutorLoadReq loadParam) {
        SfaVisitStepOrderRedisData redisData = (SfaVisitStepOrderRedisData) this.redisService
                .hmget(SfaVisitStepOrderRedisData.getInstance().redisHash(loadParam.getRedisHashKey(), loadParam.getStepCode()).toString(), loadParam.getRedisHashKey());
        if (null == redisData) {
            log.warn("将数据传输到ES: 没有执行数据需要传输（可能用户没有执行该步骤），executorLoadReq={}", JsonPropertyUtil.toJsonString(loadParam));
            return null;
        }
//        redisData = this.sfaVisitStepOrderService.save(redisData);
        return Lists.newArrayList(redisData);
    }


}
