package com.biz.crm.moblie.controller.visit.component.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.SfaClientData;
import com.biz.crm.base.SfaClientHelper;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepRedisExecutor;
import com.biz.crm.moblie.controller.visit.component.VisitDataDurabilityService;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.moblie.controller.visit.req.ClientReq;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorWorkbenchLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.StockInventoryStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.StepExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.StockInventoryStepExecuteDataResp;
import com.biz.crm.moblie.controller.workbench.req.StockInventoryWorkbenchDataReq;
import com.biz.crm.util.*;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.model.SfaVisitStepFromEntity;
import com.biz.crm.visitstep.repositories.SfaVisitStepStockInventoryEsDataRepositories;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstep.service.ISfaVisitStepStockService;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockDetailEntity;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockInventoryEntity;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockInventoryEsData;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockInventoryRedisData;
import com.biz.crm.visitstepdetail.service.ISfaVisitStepStockDetailService;
import com.biz.crm.visitstepdetail.service.ISfaVisitStepStockInventoryService;
import com.biz.crm.visitstepdetail.service.impl.SfaVisitStepStockInventoryServiceEsImpl;
import com.biz.crm.visitstepdetail.service.impl.SfaVisitStepStockInventoryServiceImpl;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;


/**
 * 库存盘点
 *
 * @author: luoqi
 * @Date: 2021-1-19 13:54
 * @version: V1.0
 * @Description:
 */
@Slf4j
@Component()
@ConditionalOnMissingBean(name = "stockInventoryVisitStepExecutorExpandImpl")
public class StockInventoryVisitStepExecutor<ExecuteReq extends StockInventoryStepExecuteData> extends AbstractVisitStepRedisExecutor<ExecuteReq, StockInventoryStepExecuteDataResp, ExecutorLoadReq> {
    @Resource
    private SfaVisitStepStockInventoryEsDataRepositories sfaVisitStepStockInventoryEsDataRepositories;
    @Resource
    private SfaVisitStepStockInventoryServiceEsImpl sfaVisitStepStockInventoryServiceEsImpl;
    @Resource
    private SfaVisitStepStockInventoryServiceImpl sfaVisitStepStockInventoryServiceImpl;
    @Resource
    private ISfaVisitStepStockInventoryService sfaVisitStepStockInventoryService;
    @Resource
    private ISfaVisitStepStockDetailService sfaVisitStepStockDetailService;

    @Override
    protected VisitDataDurabilityService getVisitDataDurabilityService() {
        return sfaVisitStepStockInventoryServiceImpl;
    }

    @Override
    protected String visitStepRegistry() {
        return SfaVisitEnum.visitStep.VISIT_STEP_STOCK.getVal();
    }

    /**
     * 步骤执行
     *
     * @param visitStepExecuteReq
     */
    @Override
    public void execute(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());

        this.check(sfaVisitPlanInfoEntity, visitStepExecuteReq, SfaVisitEnum.VISIT_OFF_LINE.online);
        SfaVisitStepStockInventoryRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        this.buildEntity(sfaVisitPlanInfoEntity, redisData);
        redisData.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());
        //更新步骤状态
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode(), visitRedisHashKey.getVisitBigType());
        //保存到redis
        this.redisService.hmset(redisData.redisHash(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode()).toString()
                , redisData.buildRedisDataForWrite(), SfaVisitPlanInfoEntity.CACHE_TIME);
    }

    @Override
    public void executeOffLine(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());

        this.check(sfaVisitPlanInfoEntity, visitStepExecuteReq, SfaVisitEnum.VISIT_OFF_LINE.offline);
        SfaVisitStepStockInventoryRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        this.buildEntity(sfaVisitPlanInfoEntity, redisData);
        redisData.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());
        //更新步骤状态
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode(), visitRedisHashKey.getVisitBigType());
        //保存到redis
        this.redisService.hmset(redisData.redisHash(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode()).toString()
                , redisData.buildRedisDataForWrite(), SfaVisitPlanInfoEntity.CACHE_TIME);
    }

    /**
     * 工作台-库存盘点-执行
     *
     * @param visitStepExecuteReq
     */
    public void executeForWorkbench(VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        String id = UUIDGenerator.generate();
        visitStepExecuteReq.setRedisHashKey(VisitStepExecuteReq.REDIS_HASH_KEY_DEF);
        this.check(null, visitStepExecuteReq, SfaVisitEnum.VISIT_OFF_LINE.online);
        SfaVisitStepStockInventoryRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        StockInventoryWorkbenchDataReq dataReq = (StockInventoryWorkbenchDataReq) visitStepExecuteReq.getStepExecuteData();
        this.buildEntity(dataReq, redisData);
        redisData.setId(id);
        redisData.setVisitPlanInfoId(id);
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        this.dataDurability(Lists.newArrayList(redisData), fromRespVo);
    }

    /**
     * 组装 RedisData 数据对象
     *
     * @param visitStepExecuteReq
     * @return
     */
    protected SfaVisitStepStockInventoryRedisData buildRedisData(VisitStepExecuteReq<? extends StockInventoryStepExecuteData> visitStepExecuteReq) {
        StockInventoryStepExecuteData executeData = visitStepExecuteReq.getStepExecuteData();
        SfaVisitStepStockInventoryRedisData redisData = CrmBeanUtil.copy(executeData, SfaVisitStepStockInventoryRedisData.class);
        redisData.setRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        redisData.setFormId(visitStepExecuteReq.getFormId());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        redisData.setStepCode(fromRespVo.getStepCode());
        redisData.setVisitStepStockList(executeData.getVisitStepStockList());
        redisData.setStockTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        redisData.setStockDate(LocalDateTime.now().format(CrmDateUtils.yyyyMMdd));
        redisData.setStockYearMonth(LocalDateTime.now().format(CrmDateUtils.yyyyMM));
        redisData.setStockYear(LocalDateTime.now().format(CrmDateUtils.yyyy));
        return redisData;
    }

    /**
     * 组装参数，可扩展
     *
     * @param sfaVisitPlanInfoEntity
     * @param redisData
     */
    protected void buildEntity(ClientReq sfaVisitPlanInfoEntity, SfaVisitStepStockInventoryRedisData redisData) {
        this.checkClientReq(sfaVisitPlanInfoEntity);
        CrmBaseEntity.buildDefEntityData(redisData);
        if (sfaVisitPlanInfoEntity instanceof SfaVisitPlanInfoEntity) {
            this.buildClientData(redisData, (SfaVisitPlanInfoEntity) sfaVisitPlanInfoEntity);
        } else {
            this.buildClientData(redisData, sfaVisitPlanInfoEntity.getClientCode(), sfaVisitPlanInfoEntity.getClientType());
        }
        UserRedis userRedis = UserUtils.getUser();
        redisData.setUserName(userRedis.getUsername());
        redisData.setRealName(userRedis.getRealname());
        redisData.setPosCode(userRedis.getPoscode());
        redisData.setPosName(userRedis.getPosname());
        redisData.setOrgCode(userRedis.getOrgcode());
        redisData.setOrgName(userRedis.getOrgname());

    }

    /**
     * 校验数据，可扩展
     *
     * @param entity
     * @param visitStepExecuteReq
     */
    protected void check(SfaVisitPlanInfoEntity entity, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq, SfaVisitEnum.VISIT_OFF_LINE lineType) {
        super.check(visitStepExecuteReq);
        //进行数据的转换
        this.controlDataTrans(visitStepExecuteReq);
        StockInventoryStepExecuteData stepExecuteData = visitStepExecuteReq.getStepExecuteData();
        if (null == stepExecuteData) {
            throw new BusinessException("执行数据为空");
        }

        if (lineType.equals(SfaVisitEnum.VISIT_OFF_LINE.online)) {
            if (StringUtils.isBlank(stepExecuteData.getStockAddress())) {
                throw new BusinessException("地址为空");
            }
            //判断拜访客户经纬度不为空
            if (entity != null && entity.getLatitude() != null && entity.getLatitude() != null) {
                SfaVisitStepFromEntity stepFromEntity = sfaVisitStepFromService.lambdaQuery().eq(SfaVisitStepFromEntity::getId, visitStepExecuteReq.getFormId()).one();
                if (stepFromEntity != null && stepFromEntity.getLocateType().equals(YesNoEnum.yesNoEnum.Y.getValue())) {
                    if (com.biz.crm.util.StringUtils.isNotEmpty(stepFromEntity.getDistance())) {
                        if (StringUtils.isBlank(stepExecuteData.getLatitude())) {
                            throw new BusinessException("维度为空");
                        }
                        if (StringUtils.isBlank(stepExecuteData.getLongitude())) {
                            throw new BusinessException("经度为空");
                        }
                        BigDecimal distance = new BigDecimal(stepFromEntity.getDistance()).setScale(2, BigDecimal.ROUND_HALF_DOWN);
                        log.info("当前步骤配置的距离:{}", distance);
                        log.info("当前位置的经度:{},纬度:{},拜访客户的经度:{},纬度:{}", stepExecuteData.getLongitude(), stepExecuteData.getLatitude(), entity.getLongitude(), entity.getLatitude());
                        double data = LocationUtils.getDistance(new BigDecimal(stepExecuteData.getLongitude()),
                                new BigDecimal(stepExecuteData.getLatitude()), entity.getLongitude(), entity.getLatitude());
                        BigDecimal nowDistance = new BigDecimal(data).setScale(2, BigDecimal.ROUND_HALF_DOWN);
                        log.info("当前位置距离拜访客户的距离:{}", nowDistance);
                        if (distance.compareTo(nowDistance) == -1) {
                            throw new BusinessException("您未在客户距离" + distance + "M内，请前往客户地址进行操作！");
                        }
                    }
                }
            }
        }
        List<StockInventoryStepExecuteData.StockDetailReqVo> visitStepStockList = stepExecuteData.getVisitStepStockList();
        if (CollectionUtils.isEmpty(visitStepStockList)) {
            throw new BusinessException("盘点明细为空");
        }
        for (StockInventoryStepExecuteData.StockDetailReqVo stockDetailReqVo : visitStepStockList) {
            if (StringUtils.isBlank(stockDetailReqVo.getProductLevelCode())) {
                throw new BusinessException("系列编码为空");
            }
            if (StringUtils.isBlank(stockDetailReqVo.getProductLevelName())) {
                throw new BusinessException("系列名称为空");
            }
            if (StringUtils.isBlank(stockDetailReqVo.getProductCode())) {
                throw new BusinessException("产品编码为空");
            }
            if (StringUtils.isBlank(stockDetailReqVo.getProductName())) {
                throw new BusinessException("产品名称为空");
            }
            if (StringUtils.isBlank(stockDetailReqVo.getSaleUnit())) {
                throw new BusinessException("单位编码为空");
            }
            if (StringUtils.isBlank(stockDetailReqVo.getSaleUnitName())) {
                throw new BusinessException("单位名称为空");
            }

            if (null == stockDetailReqVo.getQuantity()) {
                throw new BusinessException("产品数量为空");
            }
        }

    }


    /**
     * 步骤执行数据加载
     *
     * @param redisHashKey
     */
    @Override
    protected StockInventoryStepExecuteDataResp doLoad(ExecutorLoadReq redisHashKey) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(redisHashKey.getRedisHashKey());
        this.loadAndCheckSfaVisitPlanInfoEntity(redisHashKey.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(redisHashKey.getFormId());
        SfaVisitStepStockInventoryRedisData redisData = (SfaVisitStepStockInventoryRedisData) this.redisService
                .hmget(SfaVisitStepStockInventoryRedisData.getInstance().redisHash(redisHashKey.getRedisHashKey(), fromRespVo.getStepCode()).toString(), redisHashKey.getRedisHashKey());
        if (null == redisData) {
            redisData = new SfaVisitStepStockInventoryRedisData() {{
                List list = Lists.newArrayList();
                this.setVisitStepStockList(list);
            }};
        }
        StockInventoryStepExecuteDataResp dataResp = CrmBeanUtil.copy(redisData, StockInventoryStepExecuteDataResp.class);
        dataResp.setVisitStepStockList(redisData.getVisitStepStockList());
        dataResp.setSfaVisitStepFrom(fromRespVo);
        this.controlDataToObj(dataResp);
        return dataResp;
    }

    /**
     * 查询ES的执行数据
     *
     * @param visitPlanInfoId
     * @param stepCode
     * @return
     */
    @Override
    public StepExecuteDataResp getEsDataByVisitPlanInfo(String visitPlanInfoId, String stepCode) {
        StepExecuteDataResp esData = this.sfaVisitStepStockInventoryEsDataRepositories.findByVisitPlanInfoIdAndStepCode(visitPlanInfoId, stepCode);
        return esData;
    }

    /**
     * 查询ES的执行数据
     *
     * @param id
     * @return
     */
    @Override
    public StepExecuteDataResp getEsDataById(String id) {
        Optional<SfaVisitStepStockInventoryEsData> optional = this.sfaVisitStepStockInventoryEsDataRepositories.findById(id);
        if (optional.isPresent()) {
            return optional.get();
        } else {
            throw new BusinessException("未查询到该数据详细信息!");
        }
    }

    /**
     * 加载工作台编辑页面数据
     *
     * @param loadParam
     */
    @Override
    protected StockInventoryStepExecuteDataResp doLoadEditPageForWorkbench(ExecutorWorkbenchLoadReq loadParam) {

        String bizId = loadParam.getBizId();
        String visitPlanInfoId = loadParam.getVisitPlanInfoId();
        if (StringUtils.isNotBlank(visitPlanInfoId)) {
            if (StringUtils.isBlank(loadParam.getStepCode())) {
                throw new BusinessException("步骤编码为空");
            }
            return this.buildDataResp(visitPlanInfoId, loadParam.getStepCode(), null);
        }
        if (StringUtils.isBlank(bizId)) {
            SfaClientData clientData = SfaClientHelper.loadClientData(loadParam.getClientType(), loadParam.getClientCode());
            if (StringUtils.isBlank(loadParam.getStepCode())) {
                throw new BusinessException("步骤编码为空");
            }
            StockInventoryStepExecuteDataResp dataResp = new StockInventoryStepExecuteDataResp() {{
                List list = Lists.newArrayList();
                this.setVisitStepStockList(list);
            }};
            dataResp.setSfaVisitStepFrom(this.getFormData(loadParam.getClientType(), loadParam.getStepCode(), loadParam.getVisitBigType(), clientData.getClientSubclass()));
            return dataResp;
        } else {
            return this.buildDataResp(null, null, bizId);
        }

    }


    /**
     * 查询库存盘点详细信息
     *
     * @param visitPlanInfoId
     * @param stepCode
     * @param bizId
     * @return
     */
    protected StockInventoryStepExecuteDataResp buildDataResp(String visitPlanInfoId, String stepCode, String bizId) {
        StockInventoryStepExecuteDataResp dataResp;
        LambdaQueryChainWrapper<SfaVisitStepStockInventoryEntity> wrapper = this.sfaVisitStepStockInventoryService.lambdaQuery();
        SfaVisitStepStockInventoryEntity entity = wrapper
                .eq(StringUtils.isNotBlank(visitPlanInfoId), SfaVisitStepStockInventoryEntity::getVisitPlanInfoId, visitPlanInfoId)
                .eq(StringUtils.isNotBlank(stepCode), SfaVisitStepStockInventoryEntity::getStepCode, stepCode)
                .eq(StringUtils.isNotBlank(bizId), SfaVisitStepStockInventoryEntity::getId, bizId).one();
        dataResp = CrmBeanUtil.copy(entity, StockInventoryStepExecuteDataResp.class);
        List<SfaVisitStepStockDetailEntity> detailEntities = sfaVisitStepStockDetailService.lambdaQuery()
                .eq(SfaVisitStepStockDetailEntity::getStockInventoryId, entity.getId()).list();
        List<StockInventoryStepExecuteData.StockDetailReqVo> detailReqVos = CrmBeanUtil.copyList(detailEntities, StockInventoryStepExecuteData.StockDetailReqVo.class);
        dataResp.setVisitStepStockList(detailReqVos);
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(entity.getFormId());
        if (fromRespVo!=null){
            dataResp.setSfaVisitStepFrom(fromRespVo);
        }
        this.controlDataToObj(dataResp);
        return dataResp;
    }

    private StockInventoryStepExecuteDataResp buildDataResp(SfaVisitStepStockInventoryEsData esData) {
        if (null == esData) {
            throw new BusinessException("未查询到该数据详细信息!");
        }
        StockInventoryStepExecuteDataResp dataResp = CrmBeanUtil.copy(esData, StockInventoryStepExecuteDataResp.class);
        dataResp.setVisitStepStockList(esData.getVisitStepStockList());
        dataResp.setSfaVisitStepFrom(esData.getSfaVisitStepFrom());
        return dataResp;
    }

    /**
     * 将数据传输到关系数据库
     *
     * @param loadParam
     * @return
     */
    @Override
    protected List<? extends VisitStepListener.VisitStepListenerCommittedData> loadRedisDataList(ExecutorLoadReq loadParam) {
        SfaVisitStepStockInventoryRedisData redisData = (SfaVisitStepStockInventoryRedisData) this.redisService
                .hmget(SfaVisitStepStockInventoryRedisData.getInstance().redisHash(loadParam.getRedisHashKey(), loadParam.getStepCode()).toString(), loadParam.getRedisHashKey());
        if (null == redisData) {
            log.warn("将数据传输到ES: 没有执行数据需要传输（可能用户没有执行该步骤），executorLoadReq={}", JsonPropertyUtil.toJsonString(loadParam));
            return null;
        }
//        redisData = this.sfaVisitStepStockInventoryService.save(redisData);
        return Lists.newArrayList(redisData);
    }


}
