package com.biz.crm.moblie.controller.visit.component.impl;

import com.biz.crm.base.*;
import com.biz.crm.base.attachment.ISfaAttachmentService;
import com.biz.crm.base.attachment.SfaAttachmentEntity;
import com.biz.crm.base.utils.SfaAttachmentUtil;
import com.biz.crm.eunm.sfa.AttachmentBizTypeEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepRedisExecutor;
import com.biz.crm.moblie.controller.visit.component.VisitDataDurabilityService;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.moblie.controller.visit.req.ClientReq;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorWorkbenchLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.StoreCheckStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.StepExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.StoreCheckStepExecuteDataResp;
import com.biz.crm.moblie.controller.workbench.req.StoreCheckWorkbenchDataReq;
import com.biz.crm.util.*;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.model.SfaVisitStepStoreCheckEntity;
import com.biz.crm.visitstep.model.SfaVisitStepStoreCheckEsData;
import com.biz.crm.visitstep.model.SfaVisitStepStoreCheckRedisData;
import com.biz.crm.visitstep.repositories.SfaVisitStepStoreCheckEsDataRepositories;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.biz.crm.visitstep.service.ISfaVisitStepStoreCheckService;
import com.biz.crm.visitstep.service.impl.SfaVisitStepStoreCheckServiceImpl;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;


/**
 * 拜访步骤执行器-店面检查
 *
 * @author: luoqi
 * @Date: 2021-3-5 16:13
 * @version: V1.0
 * @Description:
 */
@Slf4j
@Component()
@ConditionalOnMissingBean(name = "storeCheckVisitStepExecutorExpandImpl")
public class StoreCheckVisitStepExecutor<ExecuteReq extends StoreCheckStepExecuteData> extends AbstractVisitStepRedisExecutor<ExecuteReq, StoreCheckStepExecuteDataResp, ExecutorLoadReq> {

    @Resource
    private SfaVisitStepStoreCheckEsDataRepositories sfaVisitStepStoreCheckEsDataRepositories;
    @Resource
    private SfaVisitStepStoreCheckServiceImpl sfaVisitStepStoreCheckServiceImpl;
    @Resource
    private ISfaVisitStepStoreCheckService sfaVisitStepStoreCheckService;
    @Resource
    private ISfaAttachmentService sfaAttachmentService;

    @Override
    protected VisitDataDurabilityService getVisitDataDurabilityService() {
        return sfaVisitStepStoreCheckServiceImpl;
    }

    @Override
    protected String visitStepRegistry() {
        return SfaVisitEnum.visitStep.VISIT_STEP_STORE_CHECK.getVal();
    }


    @Override
    public void execute(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());

        this.check(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        SfaVisitStepStoreCheckRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        this.buildEntity(sfaVisitPlanInfoEntity, redisData);
        redisData.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());
        //设置数据为在线
        redisData.setLineEnum(SfaVisitEnum.VISIT_OFF_LINE.online);
        //更新步骤状态
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode(), visitRedisHashKey.getVisitBigType());

        //保存到redis
        this.redisService.hmset(redisData.redisHash(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode()).toString()
                , redisData.buildRedisDataForWrite(), SfaVisitPlanInfoEntity.CACHE_TIME);
    }

    /**
     * 离线数据处理，离线数据，不进行验证
     *
     * @param visitStepExecuteReq
     */
    @Override
    public void executeOffLine(VisitStepExecuteReq<ExecuteReq> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());

        super.check(visitStepExecuteReq);
        SfaVisitStepStoreCheckRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        this.buildEntity(sfaVisitPlanInfoEntity, redisData);
        redisData.setVisitPlanInfoId(sfaVisitPlanInfoEntity.getId());
        //设置数据为在线
        redisData.setLineEnum(SfaVisitEnum.VISIT_OFF_LINE.offline);
        //更新步骤状态
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode(), visitRedisHashKey.getVisitBigType());

        //保存到redis
        this.redisService.hmset(redisData.redisHash(visitStepExecuteReq.getRedisHashKey(), redisData.getStepCode()).toString()
                , redisData.buildRedisDataForWrite(), SfaVisitPlanInfoEntity.CACHE_TIME);
    }


    /**
     * 工作台-店面检查-执行
     *
     * @param visitStepExecuteReq
     */
    public void executeForWorkbench(VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        String id = UUIDGenerator.generate();
        visitStepExecuteReq.setRedisHashKey(id);
        this.check(null, visitStepExecuteReq);
        SfaVisitStepStoreCheckRedisData redisData = this.buildRedisData(visitStepExecuteReq);
        StoreCheckWorkbenchDataReq dataReq = (StoreCheckWorkbenchDataReq) visitStepExecuteReq.getStepExecuteData();
        this.buildEntity(dataReq, redisData);
        //设置数据为在线
        redisData.setLineEnum(SfaVisitEnum.VISIT_OFF_LINE.online);
        redisData.setId(id);
        redisData.setVisitPlanInfoId(id);
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        this.dataDurability(Lists.newArrayList(redisData), fromRespVo);
    }

    /**
     * 组装 RedisData 数据对象
     *
     * @param visitStepExecuteReq
     * @return
     */
    protected SfaVisitStepStoreCheckRedisData buildRedisData(VisitStepExecuteReq<? extends StoreCheckStepExecuteData> visitStepExecuteReq) {
        StoreCheckStepExecuteData executeData = visitStepExecuteReq.getStepExecuteData();
        SfaVisitStepStoreCheckRedisData redisData = CrmBeanUtil.copy(executeData, SfaVisitStepStoreCheckRedisData.class);
        redisData.setRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        redisData.setFormId(visitStepExecuteReq.getFormId());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(visitStepExecuteReq.getFormId());
        redisData.setStepCode(fromRespVo.getStepCode());
        redisData.setRegularShelfDisplayList(executeData.getRegularShelfDisplayList());
        redisData.setMaterialDisplayList(executeData.getMaterialDisplayList());
        redisData.setPriceList(executeData.getPriceList());

        SfaAttachmentUtil.copy(executeData, redisData);

        return redisData;
    }

    /**
     * 步骤执行数据加载
     *
     * @param redisHashKey
     */
    @Override
    protected StoreCheckStepExecuteDataResp doLoad(ExecutorLoadReq redisHashKey) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(redisHashKey.getRedisHashKey());
        this.loadAndCheckSfaVisitPlanInfoEntity(redisHashKey.getRedisHashKey(), visitRedisHashKey.getVisitBigType());
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(redisHashKey.getFormId());
        SfaVisitStepStoreCheckRedisData redisData = (SfaVisitStepStoreCheckRedisData) this.redisService
                .hmget(SfaVisitStepStoreCheckRedisData.getInstance().redisHash(redisHashKey.getRedisHashKey(), fromRespVo.getStepCode()).toString(), redisHashKey.getRedisHashKey());

        if (null == redisData) {
            redisData = new SfaVisitStepStoreCheckRedisData() {{
                List list = Lists.newArrayList();
                this.setRegularShelfDisplayList(list);
                this.setMaterialDisplayList(list);
                this.setPriceList(list);
                this.initAttachmentExt6();
            }};
        }
        StoreCheckStepExecuteDataResp dataResp = CrmBeanUtil.copy(redisData, StoreCheckStepExecuteDataResp.class);
        dataResp.setRegularShelfDisplayList(redisData.getRegularShelfDisplayList());
        dataResp.setMaterialDisplayList(redisData.getMaterialDisplayList());
        dataResp.setPriceList(redisData.getPriceList());
        SfaAttachmentUtil.copy(redisData, dataResp);

        dataResp.setSfaVisitStepFrom(fromRespVo);
        this.controlDataToObj(dataResp);
        return dataResp;
    }

    /**
     * 查询ES的执行数据
     *
     * @param visitPlanInfoId
     * @param stepCode
     * @return
     */
    @Override
    public StepExecuteDataResp getEsDataByVisitPlanInfo(String visitPlanInfoId, String stepCode) {
        StepExecuteDataResp esData = this.sfaVisitStepStoreCheckEsDataRepositories.findByVisitPlanInfoIdAndStepCode(visitPlanInfoId, stepCode);
        return esData;
    }

    /**
     * 查询ES的执行数据
     *
     * @param id
     * @return
     */
    @Override
    public StepExecuteDataResp getEsDataById(String id) {
        Optional<SfaVisitStepStoreCheckEsData> optional = this.sfaVisitStepStoreCheckEsDataRepositories.findById(id);
        if (optional.isPresent()) {
            return optional.get();
        } else {
            throw new BusinessException("未查询到该数据详细信息!");
        }
    }

    /**
     * 加载工作台编辑页面数据
     *
     * @param loadParam
     */
    @Override
    protected StoreCheckStepExecuteDataResp doLoadEditPageForWorkbench(ExecutorWorkbenchLoadReq loadParam) {

        String bizId = loadParam.getBizId();
        String visitPlanInfoId = loadParam.getVisitPlanInfoId();
        if (StringUtils.isNotBlank(visitPlanInfoId)) {
            if (StringUtils.isBlank(loadParam.getStepCode())) {
                throw new BusinessException("步骤编码为空");
            }
            return this.buildDataResp(visitPlanInfoId, loadParam.getStepCode(), null);
        }
        if (StringUtils.isBlank(bizId)) {
            SfaClientData clientData = SfaClientHelper.loadClientData(loadParam.getClientType(), loadParam.getClientCode());
            if (StringUtils.isBlank(loadParam.getStepCode())) {
                throw new BusinessException("步骤编码为空");
            }
            StoreCheckStepExecuteDataResp dataResp = new StoreCheckStepExecuteDataResp() {{
                List list = Lists.newArrayList();
                this.setRegularShelfDisplayList(list);
                this.setMaterialDisplayList(list);
                this.setPriceList(list);
                this.initAttachmentExt6();
            }};
            dataResp.setSfaVisitStepFrom(this.getFormData(loadParam.getClientType(), loadParam.getStepCode(), loadParam.getVisitBigType(), clientData.getClientSubclass()));
            return dataResp;
        } else {
            return this.buildDataResp(null, null, bizId);
        }

    }

    /**
     * 查询详情
     *
     * @param visitPlanInfoId
     * @param stepCode
     * @param bizId
     * @return
     */
    protected StoreCheckStepExecuteDataResp buildDataResp(String visitPlanInfoId, String stepCode, String bizId) {
        StoreCheckStepExecuteDataResp dataResp;
        SfaVisitStepStoreCheckEntity entity = sfaVisitStepStoreCheckService.lambdaQuery()
                .eq(StringUtils.isNotBlank(visitPlanInfoId), SfaVisitStepStoreCheckEntity::getVisitPlanInfoId, visitPlanInfoId)
                .eq(StringUtils.isNotBlank(stepCode), SfaVisitStepStoreCheckEntity::getStepCode, stepCode)
                .eq(StringUtils.isNotBlank(bizId), SfaVisitStepStoreCheckEntity::getId, bizId).one();
        List<String> type = Lists.newArrayList(AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_REGULAR_SHELF_DISPLAY.getVal(),
                AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_MATERIAL_DISPLAY.getVal(),
                AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_PRICE.getVal());
        dataResp = CrmBeanUtil.copy(entity, StoreCheckStepExecuteDataResp.class);
        Map<String, List<SfaAttachmentEntity>> attachmentMap = sfaAttachmentService.lambdaQuery()
                .eq(SfaAttachmentEntity::getBizId, entity.getId())
                .in(SfaAttachmentEntity::getAttachmentBizType, type)
                .list()
                .stream().collect(Collectors.groupingBy(SfaAttachmentEntity::getAttachmentBizType));
        attachmentMap.entrySet().forEach(data -> {
            List<CrmAttachment> attachments = CrmBeanUtil.copyList(data.getValue(), CrmAttachment.class);
            if (AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_REGULAR_SHELF_DISPLAY.getVal().equals(data.getKey())) {
                dataResp.setRegularShelfDisplayList(attachments);
            } else if (AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_PRICE.getVal().equals(data.getKey())) {
                dataResp.setPriceList(attachments);
            } else if (AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_MATERIAL_DISPLAY.getVal().equals(data.getKey())) {
                dataResp.setMaterialDisplayList(attachments);
            }
        });
        SfaVisitStepFromRespVo fromRespVo = this.getFormData(entity.getFormId());
        if (fromRespVo!=null){
            dataResp.setSfaVisitStepFrom(fromRespVo);
        }
        this.controlDataToObj(dataResp);
        return dataResp;
    }

    private StoreCheckStepExecuteDataResp buildDataResp(SfaVisitStepStoreCheckEsData redisData) {
        if (null == redisData) {
            throw new BusinessException("未查询到该数据详细信息!");
        }
        StoreCheckStepExecuteDataResp dataResp = CrmBeanUtil.copy(redisData, StoreCheckStepExecuteDataResp.class);
        dataResp.setRegularShelfDisplayList(redisData.getRegularShelfDisplayList());
        dataResp.setMaterialDisplayList(redisData.getMaterialDisplayList());
        dataResp.setPriceList(redisData.getPriceList());
        SfaAttachmentUtil.copy(redisData, dataResp);
        dataResp.setSfaVisitStepFrom(redisData.getSfaVisitStepFrom());
        return dataResp;
    }


    /**
     * 组装参数，可扩展
     *
     * @param sfaVisitPlanInfoEntity
     * @param storeCheckRedisData
     */
    protected void buildEntity(ClientReq sfaVisitPlanInfoEntity, SfaVisitStepStoreCheckRedisData storeCheckRedisData) {
        this.checkClientReq(sfaVisitPlanInfoEntity);
        CrmBaseEntity.buildDefEntityData(storeCheckRedisData);
        StringJoiner checkType = new StringJoiner(",");
        StringJoiner checkTypeDesc = new StringJoiner(",");
        if (!CollectionUtils.isEmpty(storeCheckRedisData.getRegularShelfDisplayList())) {
            checkType.add(AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_REGULAR_SHELF_DISPLAY.getVal());
            checkTypeDesc.add(AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_REGULAR_SHELF_DISPLAY.getDesc());
        }
        if (!CollectionUtils.isEmpty(storeCheckRedisData.getMaterialDisplayList())) {
            checkType.add(AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_MATERIAL_DISPLAY.getVal());
            checkTypeDesc.add(AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_MATERIAL_DISPLAY.getDesc());
        }
        if (!CollectionUtils.isEmpty(storeCheckRedisData.getPriceList())) {
            checkType.add(AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_PRICE.getVal());
            checkTypeDesc.add(AttachmentBizTypeEnum.VISIT_STEP_STORE_CHECK_PRICE.getDesc());
        }
        storeCheckRedisData.setCheckType(checkType.toString());
        storeCheckRedisData.setCheckTypeDesc(checkTypeDesc.toString());

        if (sfaVisitPlanInfoEntity instanceof SfaVisitPlanInfoEntity) {
            this.buildClientData(storeCheckRedisData, (SfaVisitPlanInfoEntity) sfaVisitPlanInfoEntity);
        } else {
            this.buildClientData(storeCheckRedisData, sfaVisitPlanInfoEntity.getClientCode(), sfaVisitPlanInfoEntity.getClientType());
        }
        storeCheckRedisData.setCheckTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        storeCheckRedisData.setCheckDate(LocalDateTime.now().format(CrmDateUtils.yyyyMMdd));
        storeCheckRedisData.setCheckYearMonth(LocalDateTime.now().format(CrmDateUtils.yyyyMM));
        storeCheckRedisData.setCheckYear(LocalDateTime.now().format(CrmDateUtils.yyyy));

        UserRedis userRedis = UserUtils.getUser();
        storeCheckRedisData.setUserName(userRedis.getUsername());
        storeCheckRedisData.setRealName(userRedis.getRealname());
        storeCheckRedisData.setPosCode(userRedis.getPoscode());
        storeCheckRedisData.setPosName(userRedis.getPosname());
        storeCheckRedisData.setOrgCode(userRedis.getOrgcode());
        storeCheckRedisData.setOrgName(userRedis.getOrgname());

    }

    /**
     * 校验数据，可扩展
     *
     * @param entity
     * @param visitStepExecuteReq
     */
    protected void check(SfaVisitPlanInfoEntity entity, VisitStepExecuteReq<? extends ExecuteReq> visitStepExecuteReq) {
        //进行数据的转换
        this.controlDataTrans(visitStepExecuteReq);
        StoreCheckStepExecuteData storeCheckStepExecuteData = visitStepExecuteReq.getStepExecuteData();
        if (null == storeCheckStepExecuteData) {
            throw new BusinessException("执行数据为空");
        }
        if (StringUtils.isBlank(storeCheckStepExecuteData.getCheckAddress())) {
            throw new BusinessException("定位地址信息为空");
        }

        //判断拜访客户经纬度不为空
        super.checkLongitudeAndLatitude(visitStepExecuteReq, entity, storeCheckStepExecuteData.getLongitude(), storeCheckStepExecuteData.getLatitude());
//        if (entity != null && entity.getLatitude() != null && entity.getLatitude() != null) {
//            SfaVisitStepFromEntity stepFromEntity = sfaVisitStepFromService.lambdaQuery().eq(SfaVisitStepFromEntity::getId, visitStepExecuteReq.getFormId()).one();
//            if (stepFromEntity != null && stepFromEntity.getLocateType().equals(YesNoEnum.yesNoEnum.Y.getValue())) {
//                if (com.biz.crm.util.StringUtils.isNotEmpty(stepFromEntity.getDistance())) {
//                    if (StringUtils.isBlank(storeCheckStepExecuteData.getLongitude())) {
//                        throw new BusinessException("经度为空");
//                    }
//                    if (StringUtils.isBlank(storeCheckStepExecuteData.getLatitude())) {
//                        throw new BusinessException("纬度为空");
//                    }
//                    BigDecimal distance = new BigDecimal(stepFromEntity.getDistance()).setScale(2, BigDecimal.ROUND_HALF_DOWN);
//                    log.info("当前步骤配置的距离:{}",distance);
//                    log.info("当前位置的经度:{},纬度:{},拜访客户的经度:{},纬度:{}",storeCheckStepExecuteData.getLongitude(),storeCheckStepExecuteData.getLatitude(),entity.getLongitude(),entity.getLatitude());
//                    double data = LocationUtils.getDistance(new BigDecimal(storeCheckStepExecuteData.getLongitude()),
//                            new BigDecimal(storeCheckStepExecuteData.getLatitude()), entity.getLongitude(), entity.getLatitude());
//                    BigDecimal nowDistance = new BigDecimal(data).setScale(2, BigDecimal.ROUND_HALF_DOWN);
//                    log.info("当前位置距离拜访客户的距离:{}",nowDistance);
//                    if (distance.compareTo(nowDistance) == -1) {
//                        throw new BusinessException("您未在客户距离" + distance + "M内，请前往客户地址进行操作！");
//                    }
//                }
//            }
//        }
        this.checkPics(storeCheckStepExecuteData.getRegularShelfDisplayList(), 1, 5, "常规货架陈列");
        this.checkPics(storeCheckStepExecuteData.getMaterialDisplayList(), 1, 5, "物料陈列为空");
        this.checkPics(storeCheckStepExecuteData.getPriceList(), 1, 5, "价格签为空");
    }

    /**
     * 将数据传输到关系数据库
     *
     * @param loadParam
     * @return
     */
    @Override
    protected List<? extends VisitStepListener.VisitStepListenerCommittedData> loadRedisDataList(ExecutorLoadReq loadParam) {
        SfaVisitStepStoreCheckRedisData redisData = (SfaVisitStepStoreCheckRedisData) this.redisService
                .hmget(SfaVisitStepStoreCheckRedisData.getInstance().redisHash(loadParam.getRedisHashKey(), loadParam.getStepCode()).toString(), loadParam.getRedisHashKey());
        if (null == redisData) {
            log.warn("将数据传输到ES: 没有执行数据需要传输（可能用户没有执行该步骤），executorLoadReq={}", JsonPropertyUtil.toJsonString(loadParam));
            return null;
        }
//        redisData = this.sfaVisitStepStoreCheckService.save(redisData);
        return Lists.newArrayList(redisData);
    }


}
