package com.biz.crm.moblie.controller.visit.component.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepRedisExecutor;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorWorkbenchLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.SummaryStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.StepExecuteDataResp;
import com.biz.crm.moblie.controller.visit.resp.step.SummaryStepExecuteDataResp;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.LocationUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoExecuteRedisData;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoRedisData;
import com.biz.crm.visitstep.model.SfaVisitStepFromEntity;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;


/**
 * 拜访总结
 *
 * @author: luoqi
 * @Date: 2021-1-19 13:54
 * @version: V1.0
 * @Description:
 */
@Component()
@Slf4j
@ConditionalOnMissingBean(name = "summaryVisitStepExecutorExpandImpl")
public class SummaryVisitStepExecutor extends AbstractVisitStepRedisExecutor<SummaryStepExecuteData, SummaryStepExecuteDataResp, ExecutorLoadReq> {
    @Override
    protected String visitStepRegistry() {
        return SfaVisitEnum.visitStep.VISIT_STEP_SUMMARY.getVal();
    }

    /**
     * 步骤执行
     *
     * @param visitStepExecuteReq
     */
    @Override
    public void execute(VisitStepExecuteReq<SummaryStepExecuteData> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        String nowDate = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());

        this.check(sfaVisitPlanInfoEntity, visitStepExecuteReq, SfaVisitEnum.VISIT_OFF_LINE.online);
        SummaryStepExecuteData executeData = visitStepExecuteReq.getStepExecuteData();


        SfaVisitPlanInfoRedisData redisData = (SfaVisitPlanInfoRedisData) this.redisService
                .hmget(SfaVisitPlanInfoRedisData.getInstance().redisHashCurrent(nowDate, visitRedisHashKey.getVisitBigType()).toString(), visitStepExecuteReq.getRedisHashKey());

        redisData.setLineType(SfaVisitEnum.VISIT_OFF_LINE.online);
        //拜访计划明细执行
        SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData = redisData.getSfaVisitPlanInfoExecuteRedisData();
        sfaVisitPlanInfoExecuteRedisData.setFormIdAsSummary(visitStepExecuteReq.getFormId());
        //总结
        sfaVisitPlanInfoExecuteRedisData.setVisitSummary(executeData.getVisitSummary());
        //步骤状态
        this.changeStepStatus(redisData, SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_SUMMARY.getVal());
        sfaVisitPlanInfoExecuteRedisData.setVisitDetailStep(redisData.summaryStepStatus());
        //保存到redis
        this.redisService.hmset(redisData.redisHashCurrent(nowDate, visitRedisHashKey.getVisitBigType()).toString()
                , redisData.buildRedisDataForWrite(), SfaVisitPlanInfoEntity.CACHE_TIME);
    }

    @Override
    public void executeOffLine(VisitStepExecuteReq<SummaryStepExecuteData> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        String nowDate = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey(), visitRedisHashKey.getVisitBigType());

        this.check(sfaVisitPlanInfoEntity, visitStepExecuteReq, SfaVisitEnum.VISIT_OFF_LINE.offline);
        SummaryStepExecuteData executeData = visitStepExecuteReq.getStepExecuteData();


        SfaVisitPlanInfoRedisData redisData = (SfaVisitPlanInfoRedisData) this.redisService
                .hmget(SfaVisitPlanInfoRedisData.getInstance().redisHashCurrent(nowDate, visitRedisHashKey.getVisitBigType()).toString(), visitStepExecuteReq.getRedisHashKey());

        redisData.setLineType(SfaVisitEnum.VISIT_OFF_LINE.offline);
        //拜访计划明细执行
        SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData = redisData.getSfaVisitPlanInfoExecuteRedisData();
        sfaVisitPlanInfoExecuteRedisData.setFormIdAsSummary(visitStepExecuteReq.getFormId());
        //总结
        sfaVisitPlanInfoExecuteRedisData.setVisitSummary(executeData.getVisitSummary());
        //步骤状态
        this.changeStepStatus(redisData, SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_SUMMARY.getVal());
        sfaVisitPlanInfoExecuteRedisData.setVisitDetailStep(redisData.summaryStepStatus());
        //保存到redis
        this.redisService.hmset(redisData.redisHashCurrent(nowDate, visitRedisHashKey.getVisitBigType()).toString()
                , redisData.buildRedisDataForWrite(), SfaVisitPlanInfoEntity.CACHE_TIME);
    }


    /**
     * 校验数据，可扩展
     *
     * @param entity
     * @param visitStepExecuteReq
     */
    protected void check(SfaVisitPlanInfoEntity entity, VisitStepExecuteReq<SummaryStepExecuteData> visitStepExecuteReq, SfaVisitEnum.VISIT_OFF_LINE lineType) {
        super.check(visitStepExecuteReq);
        //进行数据的转换
        this.controlDataTrans(visitStepExecuteReq);
        SummaryStepExecuteData stepExecuteData = visitStepExecuteReq.getStepExecuteData();
        if (null == stepExecuteData) {
            throw new BusinessException("执行数据为空");
        }
        if (StringUtils.isBlank(stepExecuteData.getVisitSummary())) {
            throw new BusinessException("请填写拜访总结");
        }

        if (lineType.equals(SfaVisitEnum.VISIT_OFF_LINE.online)) {
            //判断拜访客户经纬度不为空
            if (entity != null && entity.getLatitude() != null && entity.getLatitude() != null) {
                SfaVisitStepFromEntity stepFromEntity = sfaVisitStepFromService.lambdaQuery().eq(SfaVisitStepFromEntity::getId, visitStepExecuteReq.getFormId()).one();
                if (stepFromEntity != null && stepFromEntity.getLocateType().equals(YesNoEnum.yesNoEnum.Y.getValue())) {
                    if (com.biz.crm.util.StringUtils.isNotEmpty(stepFromEntity.getDistance())) {
                        if (StringUtils.isBlank(stepExecuteData.getLongitude())) {
                            throw new BusinessException("经度为空");
                        }
                        if (StringUtils.isBlank(stepExecuteData.getLatitude())) {
                            throw new BusinessException("纬度为空");
                        }
                        BigDecimal distance = new BigDecimal(stepFromEntity.getDistance()).setScale(2, BigDecimal.ROUND_HALF_DOWN);
                        log.info("当前步骤配置的距离:{}", distance);
                        log.info("当前位置的经度:{},纬度:{},拜访客户的经度:{},纬度:{}", stepExecuteData.getLongitude(), stepExecuteData.getLatitude(), entity.getLongitude(), entity.getLatitude());
                        double data = LocationUtils.getDistance(new BigDecimal(stepExecuteData.getLongitude()),
                                new BigDecimal(stepExecuteData.getLatitude()), entity.getLongitude(), entity.getLatitude());
                        BigDecimal nowDistance = new BigDecimal(data).setScale(2, BigDecimal.ROUND_HALF_DOWN);
                        log.info("当前位置距离拜访客户的距离:{}", nowDistance);
                        if (distance.compareTo(nowDistance) == -1) {
                            throw new BusinessException("您未在客户距离" + distance + "M内，请前往客户地址进行操作！");
                        }
                    }
                }
            }
        }
    }


    /**
     * 步骤执行数据加载
     *
     * @param redisHashKey
     */
    @Override
    protected SummaryStepExecuteDataResp doLoad(ExecutorLoadReq redisHashKey) {
        if (StringUtils.isBlank(redisHashKey.getRedisHashKey())) {
            throw new BusinessException("redisHashKey为空");
        }
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(redisHashKey.getRedisHashKey());
        String nowDate = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        SfaVisitPlanInfoRedisData redisData = (SfaVisitPlanInfoRedisData) this.redisService
                .hmget(SfaVisitPlanInfoRedisData.getInstance().redisHashCurrent(nowDate, visitRedisHashKey.getVisitBigType()).toString(), redisHashKey.getRedisHashKey());


        if (null == redisData) {
            throw new BusinessException("不存在的拜访计划，或该计划不在今日计划内！");
        }
        //拜访计划明细执行
        SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData = redisData.getSfaVisitPlanInfoExecuteRedisData();

        SummaryStepExecuteDataResp dataResp = CrmBeanUtil.copy(sfaVisitPlanInfoExecuteRedisData, SummaryStepExecuteDataResp.class);
        dataResp.setVisitDetailStep(redisData.summaryStepStatus());
        this.controlDataToObj(dataResp);
        return dataResp;
    }

    @Override
    protected SummaryStepExecuteDataResp doLoadEditPageForWorkbench(ExecutorWorkbenchLoadReq loadParam) {


        return null;
    }

    /**
     * 查询ES的执行数据
     *
     * @param id
     * @return
     */
    @Override
    public StepExecuteDataResp getEsDataById(String id) {
        return null;
    }

    /**
     * 查询ES的执行数据
     *
     * @param visitPlanInfoId
     * @param stepCode
     * @return
     */
    @Override
    public StepExecuteDataResp getEsDataByVisitPlanInfo(String visitPlanInfoId, String stepCode) {
        return null;
    }


}
