package com.biz.crm.moblie.controller.visit.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
@ApiModel("查询用户指定日期的拜访列表-请求参数")
public class GetVisitListReq {
    @ApiModelProperty("用户")
    private String visitUserName;

    @ApiModelProperty("用户职位编码")
    private String visitPositionCode;

    @ApiModelProperty("拜访日期yyyy-MM-dd")
    private String visitDate;

    @ApiModelProperty("拜访大类（VISIT:拜访，HELP_VISIT:协访）")
    private String visitBigType;

    @ApiModelProperty("定位经度")
    private BigDecimal longitude;

    @ApiModelProperty("定位纬度")
    private BigDecimal latitude;

    @Data
    @ApiModel("查询用户指定日期的拜访列表-额外扩展参数")
    public static class MoreReq extends GetVisitListReq{
        @ApiModelProperty("网点类型")
        private String clientType;
        @ApiModelProperty("客户编码/名称搜索")
        private String keyWord;
    }
}
