package com.biz.crm.moblie.controller.visit.req.step;

import com.biz.crm.base.CrmAttachment;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.nebular.mdm.ExtTenObjVo;
import com.biz.crm.nebular.mdm.ExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;


/**
 *
 *  @author: luoqi
 *  @Date: 2021-3-6 11:33
 *  @version: V1.0
 *  @Description:
 */
@Data
@ApiModel("拜访步骤-活动执行-执行数据请求VO")
public class ActivityStepExecuteData extends ExtTenObjVo implements VisitStepExecuteReq.StepExecuteDataReq {
    @ApiModelProperty("活动执行明细id")
    private String id;

    @ApiModelProperty("活动描述（执行）")
    private String remarks;

//    @ApiModelProperty("活动执行ID（活动ID）")
//    private String activityExecutionId;

//    @ApiModelProperty("活动类型")
//    private String activityType;
    /**
     * 活动执行地址
     */
    @ApiModelProperty("定位地址")
    private String activityExecutionAddress;

    /**
     * 经度
     */
    @ApiModelProperty("经度")
    private String longitude;

    /**
     * 纬度
     */
    @ApiModelProperty("纬度")
    private String latitude;


    @ApiModelProperty("活动执行要求")
    private List<ActivityRequireReqVo> activityRequireReqVoList;





    /**
     * 活动执行要求
     *  @author: luoqi
     *  @Date: 2021-3-5 14:50
     *  @version: V1.0
     *  @Description:
     */
    @Data
    @ApiModel("拜访步骤-活动执行-执行数据请求VO-活动执行要求")
    public static class ActivityRequireReqVo{
        @ApiModelProperty("活动执行要求(0-活动照,1-门头照,2-陈列照)")
        private String activityRequire;

        @ApiModelProperty("活动执行要求")
        private String activityRequireName;

        @ApiModelProperty("照片列表")
        private List<CrmAttachment> pictureList;
    }

}


