package com.biz.crm.moblie.controller.visit.req.step;

import com.biz.crm.base.CrmAttachment;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.nebular.mdm.ExtTenObjVo;
import com.biz.crm.nebular.mdm.ExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;


@Data
@ApiModel("拜访步骤-竞品采集-执行数据请求VO")
public class CompetitorStepExecuteData extends ExtTenObjVo implements VisitStepExecuteReq.StepExecuteDataReq {

    /**
     * 活动名称
     */
    @ApiModelProperty("活动名称")
    private String activityInfo;

    /**
     * 经度
     */
    @ApiModelProperty("经度")
    private String longitude;

    /**
     * 维度
     */
    @ApiModelProperty("维度")
    private String latitude;



    @ApiModelProperty("竞品商品清单")
    private List<ColletItemReqVo> sfaVisitStepColletItemReqVos;
    @ApiModelProperty("竞品图片列表")
    private List<CrmAttachment> sfaVisitPictureReqVos;


    /**
     * 竞品
     *  @author: luoqi
     *  @Date: 2021-3-5 14:50
     *  @version: V1.0
     *  @Description:
     */
    @Data
    @ApiModel("拜访步骤-竞品采集-执行数据请求VO-竞品")
    public static class ColletItemReqVo extends ExtTenVo{
        @ApiModelProperty("竞品品牌")
        private String brand;

        @ApiModelProperty("竞品系列")
        private String series;

        @ApiModelProperty("竞品产品编码")
        private String productCode;

        @ApiModelProperty("竞品产品名称")
        private String productName;

        @ApiModelProperty("铺货数量")
        private BigDecimal quantity;

        @ApiModelProperty("单位")
        private String unit;

        @ApiModelProperty("竞品批发价")
        private BigDecimal batchPrice;

        @ApiModelProperty("竞品销售价")
        private BigDecimal price;
    }
}
