package com.biz.crm.moblie.controller.visit.req.step;

import com.biz.crm.base.CrmAttachment;
import com.biz.crm.base.CrmAttachmentContainer6;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.nebular.mdm.ExtTenObjVo;
import com.biz.crm.nebular.mdm.ExtTenVo;
import com.biz.crm.visitstep.model.SfaVisitStepStoreCheckEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
@ApiModel("拜访步骤-店面检查-执行数据请求VO")
public class StoreCheckStepExecuteData extends ExtTenObjVo implements CrmAttachmentContainer6, VisitStepExecuteReq.StepExecuteDataReq {
    /**
     * 检查地址
     */
    @ApiModelProperty("地址")
    private String checkAddress;

    /**
     * 经度
     */
    @ApiModelProperty("经度")
    private String longitude;

    /**
     * 维度
     */
    @ApiModelProperty("维度")
    private String latitude;



    @ApiModelProperty("常规货架陈列")
    private List<CrmAttachment> regularShelfDisplayList;
    @ApiModelProperty("物料陈列")
    private List<CrmAttachment> materialDisplayList;
    @ApiModelProperty("价格签")
    private List<CrmAttachment> priceList;

    //  #############附件容器############

    @ApiModelProperty("附件容器1")
    private List<CrmAttachment> attachmentExt1;

    @ApiModelProperty("附件容器2")
    private List<CrmAttachment> attachmentExt2;

    @ApiModelProperty("附件容器3")
    private List<CrmAttachment> attachmentExt3;
    @ApiModelProperty("附件容器4")
    private List<CrmAttachment> attachmentExt4;

    @ApiModelProperty("附件容器5")
    private List<CrmAttachment> attachmentExt5;

    @ApiModelProperty("附件容器6")
    private List<CrmAttachment> attachmentExt6;


    /**
     * 附件容器命名空间,建议返回表名
     *
     * @return
     */
    @Override
    public String attachmentNameScope() {
        return SfaVisitStepStoreCheckEntity.TABLE_NAME;
    }
}
