package com.biz.crm.moblie.controller.visit.resp;

import com.biz.crm.collection.controller.resp.VisitStepResp;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@Data
@ApiModel("查询用户指定日期的拜访列表VO")
public class SfaVisitResp extends SfaTaskResp{
    @ApiModelProperty("拜访列表")
    private List<SfaVisitPlanInfoResp> planInfoEntities;

    @Data
    public static class SfaVisitPlanInfoResp extends CrmExtTenVo {
        @ApiModelProperty("redisHashKey")
        private String redisHashKey;


        @ApiModelProperty("进店表单id")
        private String formIdAsInStore;


        @ApiModelProperty("离店表单id")
        private String formIdAsOutStore;



        @ApiModelProperty("距离(公里)")
        private BigDecimal distance;
        @ApiModelProperty("距离单位(公里)")
        private String unit = "Km";

        @ApiModelProperty("拜访日期yyyy-MM-dd")
        private String visitDate;

        @ApiModelProperty("拜访/协访状态")
        private String visitStatus;

        @ApiModelProperty("拜访/协访状态名称")
        private String visitStatusName;

        @ApiModelProperty("数据状态(offline-离线，online-在线)")
        private String lineStatus;

        /**
         * 网点编码
         */
        @ApiModelProperty("网点编码")
        private String clientCode;

        /**
         * 网点名称
         */
        @ApiModelProperty("网点名称")
        private String clientName;

        /**
         * 网点类型
         */
        @ApiModelProperty("网点类型")
        private String clientType;
        /**
         * 网点类型名称
         */
        @ApiModelProperty("网点类型名称")
        private String clientTypeName;

        @ApiModelProperty("客户细类")
        private String clientSubclass;

        @ApiModelProperty("客户细类")
        private String clientSubclassName;
        /**
         * 网点地址
         */
        @ApiModelProperty("网点地址")
        private String clientAddress;
        /**
         * 网点经度
         */
        @ApiModelProperty("网点经度")
        private BigDecimal longitude;

        /**
         * 网点纬度
         */
        @ApiModelProperty("网点纬度")
        private BigDecimal latitude;


        /**
         * 网点照片
         */
        @ApiModelProperty("网点照片")
        private String clientPhoto;

        /**
         * 网点联系人
         */
        @ApiModelProperty("网点联系人")
        private String clientContacts;

        /**
         * 网点电话 网点电话
         */
        @ApiModelProperty("网点电话")
        private String clientPhone;



        @ApiModelProperty("按钮")
        private Map<String,String> buttons;

        /**
         * 拜访类型(临时拜访/计划拜访)
         */
        @ApiModelProperty("拜访类型(临时拜访/计划拜访)")
        private String visitType;

        /**
         * 维度类型 维度类型（线路组、网点、频率）
         */
        @ApiModelProperty("维度类型（线路组、网点、频率）")
        private String routeType;

        @ApiModelProperty("拜访大类（VISIT:拜访，HELP_VISIT:协访，UNFAMILIAR_VISIT:陌拜）")
        private String visitBigType;

        /**
         * 拜访大类
         */
        @ApiModelProperty("拜访/协访大类（VISIT:拜访，HELP_VISIT:协访）")
        private String visitBigTypeName;

        @ApiModelProperty("拜访/协访人")
        private String visitUserName;

        /**
         * 人员姓名;人员姓名
         */
        @ApiModelProperty("拜访/协访人")
        private String visitRealName;

        /**
         * 被协访人员账号
         */
        @ApiModelProperty("被协访人员账号")
        private String coverHelpUserName;

        /**
         * 被协访人员姓名
         */
        @ApiModelProperty("被协访人员姓名")
        private String coverHelpRealName;
        /**
         * 计划拜访顺序
         */
        @ApiModelProperty("计划拜访顺序")
        private Integer visitSort;

//        @ApiModelProperty("协访状态,0:待协访,1:协访中,2:已协访,3:已过期")
//        private String helpVisitStatus;
//        @ApiModelProperty("协访状态,0:待协访,1:协访中,2:已协访,3:已过期")
//        private String helpVisitStatusName;
        public void buildFormId( Map<String, Map<String, VisitStepResp>> stepRespMap){
            Map<String, VisitStepResp> clientTypeStep = stepRespMap.get(this.getVisitBigType() + this.getClientType());
            if(null == clientTypeStep){
                return;
            }
            VisitStepResp inStore = null, outStore = null;
            Collection<VisitStepResp> values = clientTypeStep.values();
            for (VisitStepResp value : values) {
                if(SfaVisitEnum.visitStep.VISIT_STEP_IN_STORE.getVal().equals(value.getPageCode())){
                    inStore = value;
                }
                if(SfaVisitEnum.visitStep.VISIT_STEP_OUT_STORE.getVal().equals(value.getPageCode())){
                    outStore = value;
                }
            }
            if(null != inStore){
                this.setFormIdAsInStore(inStore.getFormId());
            }
//            else{
//                this.setFormIdAsInStore(SfaVisitEnum.SfaStepCode.SFA_STEP_CODE_IN_STORE.getVal());
//            }
            if(null != outStore){
                this.setFormIdAsOutStore(outStore.getFormId());
            }
//            else{
//                this.setFormIdAsOutStore(SfaVisitEnum.SfaStepCode.SFA_STEP_CODE_OUT_STORE.getVal());
//            }
        }

        @ApiModelProperty("商圈标签")
        private String busiLabel;
        @ApiModelProperty("渠道")
        private String channel;
        @ApiModelProperty("业态")
        private String busiType;

        @ApiModelProperty("省编码")
        private String pcode;
        @ApiModelProperty("市编码")
        private String citycode;
        @ApiModelProperty("区编码")
        private String adcode;

    }
}
