package com.biz.crm.moblie.controller.visit.resp.step;

import com.biz.crm.eunm.sfa.SfaActivityEnum;
import com.biz.crm.moblie.controller.workbench.req.OrderAsDataReq;
import com.biz.crm.nebular.sfa.actscheme.resp.SfaActSchemeProductRespVo;
import com.biz.crm.nebular.sfa.actscheme.resp.SfaActSchemeSetmealRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Data
@ApiModel("拜访步骤-竞品采集-查询表单执行数据-方案活动")
public class OrderAsExecuteDataResp extends OrderStepExecuteDataResp {

    @ApiModelProperty("活动方案套餐列表")
    private List<SfaActSchemeSetmealRespVo> sfaActSchemeSetmealRespVos;

    @Override
    public void convert() {
        //TODO 方案活动转换逻辑  将订单商品 转换成 方案活动套餐列表
        List<OrderAsDataReq.OrderItemAsReqVo> sfaVisitStepOrderItems = this.getSfaVisitStepOrderItems();
        if(null == sfaVisitStepOrderItems){
            sfaVisitStepOrderItems = Lists.newArrayList();
        }
        this.sfaActSchemeSetmealRespVos = Lists.newArrayList();
        //根据方案套餐分组
        Map<String, List<OrderAsDataReq.OrderItemAsReqVo>> itemSetmealMap =
                sfaVisitStepOrderItems.stream().collect(Collectors.groupingBy(OrderAsDataReq.OrderItemAsReqVo::getSetmealId));

        for(Map.Entry<String, List<OrderAsDataReq.OrderItemAsReqVo>> entry : itemSetmealMap.entrySet()){
            String setmealId = entry.getKey();
            List<OrderAsDataReq.OrderItemAsReqVo> orderItem = entry.getValue();
            SfaActSchemeSetmealRespVo vo = new SfaActSchemeSetmealRespVo();
            vo.setActSchemeId(setmealId);
            //行类型分组
            Map<String, List<OrderAsDataReq.OrderItemAsReqVo>> itemTypeMap = orderItem.stream()
                    .collect(Collectors.groupingBy(OrderAsDataReq.OrderItemAsReqVo::getItmeType));
            List<OrderAsDataReq.OrderItemAsReqVo> bp = itemTypeMap.get(SfaActivityEnum.bpItemType.bp.getVal());
            List<OrderAsDataReq.OrderItemAsReqVo> zp = itemTypeMap.get(SfaActivityEnum.bpItemType.zp.getVal());
            if(null == bp){
                bp = Lists.newArrayList();
            }
            if(null == zp){
                zp = Lists.newArrayList();
            }

            //本品列表
            vo.setBpSchemeProductList(bp.stream().map(v -> {
                SfaActSchemeProductRespVo temp = CrmBeanUtil.copy(v, SfaActSchemeProductRespVo.class);
                temp.setPrice(null == v.getPrice() ? null : v.getPrice().setScale(2, BigDecimal.ROUND_UP).toString());
                return temp;
            }).collect(Collectors.toList()));
            //赠品列表
            vo.setZpSchemeProductList(zp.stream().map(v -> {
                SfaActSchemeProductRespVo temp = CrmBeanUtil.copy(v, SfaActSchemeProductRespVo.class);
                temp.setPrice(null == v.getPrice() ? null : v.getPrice().setScale(2, BigDecimal.ROUND_UP).toString());
                return temp;
            }).collect(Collectors.toList()));
            //赠品列表
//            vo.setBpSchemeProductList(CrmBeanUtil.copyList(itemTypeMap.get(SfaActivityEnum.bpItemType.zp.getVal()), SfaActSchemeProductRespVo.class));
            this.sfaActSchemeSetmealRespVos.add(vo);
        }
        this.setSfaVisitStepOrderItems(Lists.newArrayList());
    }
}
