package com.biz.crm.moblie.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * SfaContact实体
 * @author YuanZiJian
 * @date 2021/1/20 14:39
 * @version: V1.0
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_client_contact")
@CrmTable(name = "sfa_client_contact", tableNote = "保存客户的相关联系人",indexes = {
        @Index(name = "sfa_client_contact_index1",columnList = "client_id")
})
public class SfaContactEntity extends CrmExtTenEntity {

    @ApiModelProperty("客户编码")
    @CrmColumn(name = "client_id", length = 64, note = "控件id")
    private String clientId;

    @ApiModelProperty("联系人姓名")
    @CrmColumn(name = "contact_name", length = 64, note = "联系人姓名")
    private String contactName;

    @ApiModelProperty("联系人电话")
    @CrmColumn(name = "contact_phone", length = 64, note = "联系人电话")
    private String contactPhone;

    @ApiModelProperty("主联系人,1是0否")
    @CrmColumn(name = "contact_main", length = 64, note = "主联系人,1是0否")
    private String contactMain;

    @ApiModelProperty("联系人所属类型：1是终端 ，0 经销商")
    @CrmColumn(name = "type", length = 1, note = "联系人所属类型：1是终端 ，0 经销商")
    private String type;
}
