package com.biz.crm.moblie.service;


import com.biz.crm.collection.controller.resp.SfaUnfamiliarVisitRecordDetailRespVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.moblie.controller.visit.resp.SfaVisitResp;
import com.biz.crm.nebular.sfa.moblie.req.SfaNearbyCustomerReqVo;
import com.biz.crm.nebular.sfa.moblie.req.SfaUnfamiliarVisitRecordReqVo;
import com.biz.crm.nebular.sfa.moblie.resp.SfaUnfamiliarVisitRecordRespVo;

/**
 * 附近客户 接口
 *
 * @author yangshan
 * @date 2021/3/9 14:39
 */

public interface ISfaNearbyCustomerService {

    /**
     * 根据经纬度查询未合作客户
     *
     * @param reqVo
     * @return
     */
    SfaVisitResp findNotCooperationCustomerList(SfaNearbyCustomerReqVo reqVo);

    /**
     * 根据经纬度查询已合作客户
     * @param reqVo
     * @return
     */
    SfaVisitResp findCooperationCustomerList(SfaNearbyCustomerReqVo reqVo);

    /**
     * 查询陌拜记录
     * @param reqVo
     * @return
     */
    PageResult<SfaUnfamiliarVisitRecordRespVo> findUnfamiliarVisitRecord(SfaUnfamiliarVisitRecordReqVo reqVo);

    /**
     * 获取陌拜详情
     * @param visitPlanInfoId
     * @return
     */
    SfaUnfamiliarVisitRecordDetailRespVo getUnfamiliarVisitRecordDetail(String visitPlanInfoId);

}
