package com.biz.crm.moblie.service;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.act.req.ReadCopyTaskReqVO;
import com.biz.crm.nebular.activiti.task.resp.OptRecordRspVO;
import com.biz.crm.nebular.activiti.task.resp.ProcessInfoRspVO;
import com.biz.crm.nebular.sfa.worksign.req.*;
import com.biz.crm.nebular.sfa.worksign.resp.*;
import com.biz.crm.util.Result;

import java.util.List;
import java.util.Map;

/**
 * @author ren.gang
 * @ClassName ISfaWorkSignAuditService.java
 * @Description 考勤审批业务处理
 * @createTime 2020年11月26日 15:14:00
 */
public interface ISfaWorkSignAuditService {

    /**
     *
     * @return
     */
    Map<String, Integer> backlogCount();

    /**
     * 请假审批-提交审核信息
     * @param reqVo
     * @return
     */
    Result auditCommit(SfaAuditReqVo reqVo);

    /**
     * 请假审批-待审批列表
     * @return
     */
    PageResult<SfaAuditListLeaveRespVo> auditListLeave(SfaLeaveListReqVo reqVo);

    /**
     * 工作日调整-待审批列表
     * @return
     */
    PageResult<SfaAuditListOvertimeRespVo> auditListOvertime(SfaWorkOvertimeListReqVo reqVo);

    /**
     * 异常报备-待审批列表
     * @return
     */
    PageResult<SfaAuditListExceptionRespVo> auditListException(SfaExceptionReportListReqVo reqVo);

    /**
     * 销假审批-列表
     * @return
     */
    PageResult<SfaAuditListLeaveCancelRespVo> auditListLeaveCancel(SfaAuditListLeaveCancelReqVo reqVo);

    /**
     * 出差申请-待审批列表
     * @return
     */
    PageResult<SfaAuditListTravelRespVo> auditListTravel(SfaTravelReqVo reqVo);

    /**
     * 抄送给我的-列表
     * @param reqVO
     */
    PageResult<SfaCopyTaskRespVo> copyTaskList(SfaCopyTaskReqVo reqVO);

    /**
     * 抄送节点已阅
     * @param readCopyTaskReqVO
     * @return
     */
    Result readCopyTask(ReadCopyTaskReqVO readCopyTaskReqVO);

    /**
     * 查询流程审批记录
     * @param reqVo
     * @return
     */
    List<OptRecordRspVO> findAuditRecords(SfaAuditReportListReqVo reqVo);

    /**
     * 查询流程详细信息
     * @param reqVo
     * @return
     */
    ProcessInfoRspVO getProcessInfo(SfaAuditReportListReqVo reqVo);

    /**
     * 审核完成回调
     * @return
     */
    void auditFinish(SfaAuditFinishReqVo reqVo);
}
