package com.biz.crm.moblie.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.moblie.model.SfaTerminalEntity;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.mdm.PageVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.sfa.moblie.req.SfaTerminalMsgReqVo;
import com.biz.crm.nebular.sfa.moblie.req.SfaTerminalReqVo;
import com.biz.crm.nebular.sfa.moblie.resp.SfaTerminalMsgRespVo;
import com.biz.crm.util.Result;

import java.util.List;

/**
 * 对终端操作的接口
 * @author YuanZiJian
 * @date 2020/12/29 15:47
 * @version: V1.0
 */
public interface SfaTerminalService extends IService<SfaTerminalEntity> {

    /**
     * 查询终端列表
     * 默认查询登陆用户的职位及其下级职位的所有终端
     * @method findTerminal
     * @date: 2020/12/29 15:48
     * @author: YuanZiJian
     * @return com.biz.crm.util.Result<java.util.List<com.biz.crm.nebular.mdm.terminal.MdmTerminalVo>>
     */
    Result<List<MdmTerminalVo>> findTerminal();

    /**
     * 新增终端
     * @method saveTerminal
     * @date: 2020/12/30 10:18
     * @author: YuanZiJian
     * @param sfaTerminalMsgReqVo 终端实体
     * @return void
     */
    void saveTerminal(SfaTerminalMsgReqVo sfaTerminalMsgReqVo);

    /**
     * 更新终端
     * @method updateTerminal
     * @date: 2020/12/30 10:36
     * @author: YuanZiJian
     * @param mdmTerminalVo
     * @return void
     */
    void updateTerminal(SfaTerminalMsgReqVo sfaTerminalMsgReqVo);


    /**
     * 更新审批状态
     * @method updateActApproveStatus
     * @date: 2021/1/5 15:07
     * @author: YuanZiJian
     * @param activitiCallBackVo 审批状态
     * @return void
     */
    void updateActApproveStatus (ActivitiCallBackVo activitiCallBackVo);

    /**
     * 查询所有在sfa审核表中的终端数据-小程序端
     * @method findAllTerminal
     * @date: 2021/1/6 10:27
     * @author: YuanZiJian
     * @param pageVo 分页参数
     * @return com.biz.crm.util.Result<com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.nebular.mdm.terminal.MdmTerminalVo>>
     */
    PageResult<SfaTerminalMsgRespVo> findAllSfaTerminal (SfaTerminalReqVo sfaTerminalReqVo);

    /**
     * 更新终端审批状态——小程序端
     * @param id 终端id
     * @param remark 审批备注
     * @param actApproveStatus 审批状态
     */
    void updateSfaActApproveStatus(String id,String remark,String actApproveStatus);

    /**
     * 根据id获取审批终端的信息-小程序端
     * @method querySfaTerminalVo
     * @date: 2021/1/6 13:48
     * @author: YuanZiJian
     * @param id 终端id
     * @return com.biz.crm.util.Result<com.biz.crm.nebular.mdm.terminal.MdmTerminalVo>
     */
    Result<SfaTerminalMsgRespVo> querySfaTerminalVo(String id);
    /**
     * 待处理的终端审批信息数量
     *
     * @return com.biz.crm.util.Result<java.lang.Integer>
     * @method countCustomer
     * @date: 2021/1/6 18:19
     * @author: YuanZiJian
     */
    Result<Integer> countTerminal();

    /**
     * 新增终端（转mdm）后，绩效积分结算
     * @param mdmTerminalVo
     * @param fromType
     */
    void countAchievementAndIntegral(MdmTerminalVo mdmTerminalVo, String fromType);
}
