package com.biz.crm.moblie.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.enums.SfaVisitStatusEnum;
import com.biz.crm.moblie.service.ISfaVisitClientStepDisplayService;
import com.biz.crm.nebular.sfa.picture.req.SfaVisitPictureReqVo;
import com.biz.crm.nebular.sfa.picture.resp.SfaVisitPictureRespVo;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoRespVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitDisplayConfigReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepDisplayReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitDisplayConfigRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepDisplayRespVo;
import com.biz.crm.picture.service.ISfaVisitPictureService;
import com.biz.crm.util.StringUtils;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.biz.crm.visitstep.service.ISfaVisitDisplayConfigService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@Service
@ConditionalOnMissingBean(name = "SfaVisitClientStepDisplayServiceExpandImpl")
public class SfaVisitClientStepDisplayServiceImpl implements ISfaVisitClientStepDisplayService {

    @Resource
    private ISfaVisitDisplayConfigService iSfaVisitDisplayConfigService;

    @Resource
    private ISfaVisitPictureService iSfaVisitPictureService;

    @Resource
    private ISfaVisitPlanInfoService iSfaVisitPlanInfoService;

    @Deprecated
    @Override
    public List<SfaVisitStepDisplayRespVo> visitDisplayList(SfaVisitStepDisplayReqVo vo) {
        List<SfaVisitStepDisplayRespVo> list = new ArrayList<>();

        //查询陈列执行规则
        List<SfaVisitDisplayConfigRespVo> configList = iSfaVisitDisplayConfigService.getConfig(new SfaVisitDisplayConfigReqVo());
        if (configList != null && configList.size() > 0) {

            for (SfaVisitDisplayConfigRespVo item :
                    configList) {

                SfaVisitStepDisplayRespVo sfaVisitStepDisplayRespVo = new SfaVisitStepDisplayRespVo();
                sfaVisitStepDisplayRespVo.setLabelName(item.getLabelName());
                sfaVisitStepDisplayRespVo.setLabelDesc(item.getLabelDesc());
                sfaVisitStepDisplayRespVo.setPicLimit(item.getPicLimit());
                sfaVisitStepDisplayRespVo.setPicType(item.getPicType());

                //查询拜访图片
                SfaVisitPictureReqVo sfaVisitPictureReqVo = new SfaVisitPictureReqVo();
                sfaVisitPictureReqVo.setVisitId(vo.getVisitId());
                sfaVisitPictureReqVo.setPicType(item.getPicType());
                List<SfaVisitPictureRespVo> pictureList = iSfaVisitPictureService.findSfaVisitPictureList(sfaVisitPictureReqVo);
                sfaVisitStepDisplayRespVo.setPictureList(pictureList);

                list.add(sfaVisitStepDisplayRespVo);
            }
        }
        return list;
    }

    @Deprecated
    @Override
    public void saveVisitDisplay(SfaVisitStepDisplayReqVo vo) {

        SfaVisitPlanInfoReqVo sfaVisitPlanInfoReqVo = new SfaVisitPlanInfoReqVo();
        sfaVisitPlanInfoReqVo.setId(vo.getVisitId());

        SfaVisitPlanInfoRespVo visitPlan = iSfaVisitPlanInfoService.query(sfaVisitPlanInfoReqVo);
        if (visitPlan == null) {
            throw new BusinessException("无效的拜访编码");
        }
        if (SfaVisitStatusEnum.TODO.getCode().equals(visitPlan.getVisitStatus())) {
            throw new BusinessException("请先进店");
        }
        if (SfaVisitStatusEnum.FINISHED.getCode().equals(visitPlan.getVisitStatus())) {
            throw new BusinessException("已经离店，不能操作");
        }

        //图片参数转map  key：图片类型；value：图片list
        List<SfaVisitPictureReqVo> pictureReqList = vo.getPictureList();
        if (pictureReqList == null || pictureReqList.size() == 0) {
            throw new BusinessException("请上传图片");
        }

        Map<String, List<SfaVisitPictureReqVo>> pictureTypeMap = new HashMap<>();
        for (SfaVisitPictureReqVo item :
                pictureReqList) {
            if (StringUtils.isEmpty(item.getPicType())) {
                throw new BusinessException("缺失图片类型");
            }
            List<SfaVisitPictureReqVo> list = new ArrayList<>();
            if (pictureTypeMap.containsKey(item.getPicType())) {
                list.addAll(pictureTypeMap.get(item.getPicType()));
            }
            list.add(item);
            pictureTypeMap.put(item.getPicType(), list);
        }

        //本次需要新增的图片
        List<SfaVisitPictureReqVo> addPictureList = new ArrayList<>();
        //本次需要删除的图片id
        List<String> deletePictureList = new ArrayList<>();

        //查询规则和已保存图片
        List<SfaVisitStepDisplayRespVo> oldList = this.visitDisplayList(vo);
        for (SfaVisitStepDisplayRespVo item :
                oldList) {
            List<SfaVisitPictureReqVo> pictureItemList = pictureTypeMap.get(item.getPicType());
            if (item.getPicLimit() != pictureItemList.size()) {
                throw new BusinessException(item.getLabelName() + "请上传要求的照片数量");
            }

            Map<String, SfaVisitPictureReqVo> newPictureItemIdMap = new HashMap<>();
            for (SfaVisitPictureReqVo pictureItem :
                    pictureItemList) {
                if (StringUtils.isEmpty(pictureItem.getId())) {
                    addPictureList.add(pictureItem);
                } else {
                    newPictureItemIdMap.put(pictureItem.getId(), pictureItem);
                }
            }
            List<SfaVisitPictureRespVo> oldPictureItemList = item.getPictureList();
            for (SfaVisitPictureRespVo oldPictureItem :
                    oldPictureItemList) {
                if (newPictureItemIdMap.containsKey(oldPictureItem.getId())) {
                    continue;
                }
                deletePictureList.add(oldPictureItem.getId());
            }
        }

        if (addPictureList.size() > 0) {
            for (SfaVisitPictureReqVo item :
                    addPictureList) {
                iSfaVisitPictureService.save(item);
            }
        }
        if (deletePictureList.size() > 0) {
            SfaVisitPictureReqVo sfaVisitPictureReqVo = new SfaVisitPictureReqVo();
            sfaVisitPictureReqVo.setIds(deletePictureList);
            iSfaVisitPictureService.deleteBatch(sfaVisitPictureReqVo);
        }
    }
}
