package com.biz.crm.moblie.visitoffline;

import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.moblie.visitoffline.stepcomponent.photoutil.SfaVisitStepOffLineUtil;
import com.biz.crm.moblie.visitoffline.stepdatavo.req.SfaVisitOffLineReqVo;
import com.biz.crm.moblie.visitoffline.stepdatavo.req.VisitStepOffLineExecuteReq;
import com.biz.crm.nebular.activiti.vo.AttachmentOffLineVo;
import com.biz.crm.nebular.sfa.visitstep.visitoffline.VisitOfflineReqVo;
import com.biz.crm.util.Result;
import org.apache.poi.ss.formula.functions.T;

import java.util.List;

/**
 * @author lf
 * @describe
 * @project crm
 * @package com.biz.crm.moblie.visitoffline
 * @date 2021/6/23 17:25
 */
public class SfaVisitStepOffLineValidator {



    private SfaVisitStepOffLineStrategy strategy;

    public SfaVisitStepOffLineValidator(String stepCode){
        this.strategy = SpringApplicationContextUtil.getApplicationContext()
                .getBean(stepCode+SfaVisitStepConstant.EXPAND_BEAN_NAME,SfaVisitStepOffLineStrategy.class);
        strategy.setStepCode(stepCode);
    }

    /**
     * 组装离线数据
     * @param reqVo
     * @return
     */
    public Object buildVisitStepOffLineData(VisitOfflineReqVo reqVo){
        Object obj =  strategy.buildVisitStepOffLineData(reqVo);
        return obj;
    }

    /**
     * 保存离线数据
     * @param req
     */
    public Result saveVisitStepOffLine(VisitStepOffLineExecuteReq req){
        return strategy.saveVisitStepOffLine(req);
    }

    /**
     * 保存离线图片
     * @param list
     */
    public void saveVisitStepOffLineFile(List<AttachmentOffLineVo> list, SfaVisitStepOffLineUtil util){
        strategy.saveVisitStepOffLineFile(list,util);
    }
}
