package com.biz.crm.moblie.visitoffline.stepcomponent;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.attachment.SfaAttachmentEntity;
import com.biz.crm.base.utils.SfaAttachmentUtil;
import com.biz.crm.moblie.controller.visit.component.impl.StockInventoryVisitStepExecutor;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.StockInventoryStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.step.StockInventoryStepExecuteDataResp;
import com.biz.crm.moblie.visitoffline.SfaVisitStepConstant;
import com.biz.crm.moblie.visitoffline.SfaVisitStepOffLineStrategy;
import com.biz.crm.moblie.visitoffline.stepcomponent.photoutil.SfaVisitStepOffLineUtil;
import com.biz.crm.moblie.visitoffline.stepdatavo.SfaVisitStepStockVo;
import com.biz.crm.moblie.visitoffline.stepdatavo.req.SfaVisitOffLineReqVo;
import com.biz.crm.moblie.visitoffline.stepdatavo.req.VisitStepOffLineExecuteReq;
import com.biz.crm.nebular.activiti.vo.AttachmentOffLineVo;
import com.biz.crm.nebular.sfa.visitstep.visitoffline.VisitOfflineReqVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockInventoryEntity;
import com.biz.crm.visitstepdetail.service.ISfaVisitStepStockInventoryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author lf
 * @describe 库存盘点
 * @project crm
 * @package com.biz.crm.moblie.visitoffline.stepcomponent
 * @date 2021/6/23 19:24
 */
@Component(SfaVisitStepConstant.SFA_STEP_CODE_STOCK+SfaVisitStepConstant.EXPAND_BEAN_NAME)
@ConditionalOnMissingBean(name = "SfaStepStockComponentExpandImpl")
@Slf4j
public class SfaStepStockComponent implements SfaVisitStepOffLineStrategy {

    private static String STEP_CODE;

    @Resource
    private StockInventoryVisitStepExecutor stockInventoryVisitStepExecutor;
    @Resource
    private ISfaVisitStepStockInventoryService sfaVisitStepStockInventoryService;

    @Override
    public Object buildVisitStepOffLineData( VisitOfflineReqVo reqVo) {
         SfaVisitStepStockVo vo = new  SfaVisitStepStockVo();
        ExecutorLoadReq req = CrmBeanUtil.copy(reqVo,ExecutorLoadReq.class);
        StockInventoryStepExecuteDataResp dataResp = (StockInventoryStepExecuteDataResp) stockInventoryVisitStepExecutor.load(req);
        vo.setSfaVisitStepFrom(dataResp.getSfaVisitStepFrom());
        return vo;
    }

    @Override
    public Result saveVisitStepOffLine(VisitStepOffLineExecuteReq req) {
        Result result = new Result();
        try {
            VisitStepExecuteReq<StockInventoryStepExecuteData> visitStepExecuteReq = CrmBeanUtil.copy(req,VisitStepExecuteReq.class);
            StockInventoryStepExecuteData executeData = JSONObject.parseObject(JSONObject.toJSONString(req.getStepExecuteData()),StockInventoryStepExecuteData.class);
            visitStepExecuteReq.setStepExecuteData(executeData);
            stockInventoryVisitStepExecutor.executeOffLine(visitStepExecuteReq);
        }catch (BusinessException e){
            log.warn("库存盘点错误信息:{}",e.getMsg());
            result.setSuccess(false);
            result.setMessage("库存盘点:错误信息["+e.getMsg()+"]");
        }
        return result;
    }

    /**
     * 离线图片保存
     * @param list
     * @param util
     */
    @Override
    public void saveVisitStepOffLineFile(List<AttachmentOffLineVo> list, SfaVisitStepOffLineUtil util) {
        SfaVisitStepStockInventoryEntity entity = sfaVisitStepStockInventoryService.lambdaQuery()
                .eq(SfaVisitStepStockInventoryEntity::getVisitPlanInfoId,util.getVisitPlanInfoId())
                .eq(SfaVisitStepStockInventoryEntity::getStepCode,util.getStepCode())
                .select(SfaVisitStepStockInventoryEntity::getId).one();
        if (null != entity){
            List<SfaAttachmentEntity> fileEntity = list.stream().map(data->{
                SfaAttachmentEntity file = CrmBeanUtil.copy(data,SfaAttachmentEntity.class);
                file.setBizId(entity.getId());
                file.setAttachmentBizType(util.getType());
                file.setAttachmentBizTypeName(util.getTypeName());
                return file;
            }).collect(Collectors.toList());
            SfaAttachmentUtil.insert(fileEntity);
        }
    }

    @Override
    public String getStepCode() {
        return STEP_CODE;
    }

    @Override
    public void setStepCode(String stepCode) {
        this.STEP_CODE = stepCode;
    }
}
