package com.biz.crm.moblie.visitoffline.stepcomponent;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.base.BusinessException;
import com.biz.crm.moblie.controller.visit.component.impl.SummaryVisitStepExecutor;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.SummaryStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.step.SummaryStepExecuteDataResp;
import com.biz.crm.moblie.visitoffline.SfaVisitStepConstant;
import com.biz.crm.moblie.visitoffline.SfaVisitStepOffLineStrategy;
import com.biz.crm.moblie.visitoffline.stepcomponent.photoutil.SfaVisitStepOffLineUtil;
import com.biz.crm.moblie.visitoffline.stepdatavo.req.SfaVisitOffLineReqVo;
import com.biz.crm.moblie.visitoffline.stepdatavo.req.VisitStepOffLineExecuteReq;
import com.biz.crm.nebular.activiti.vo.AttachmentOffLineVo;
import com.biz.crm.nebular.sfa.visitstep.visitoffline.VisitOfflineReqVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author lf
 * @describe 拜访总结
 * @project crm
 * @package com.biz.crm.moblie.visitoffline.stepcomponent
 * @date 2021/6/23 19:28
 */
@Component(SfaVisitStepConstant.SFA_STEP_CODE_SUMMARY + SfaVisitStepConstant.EXPAND_BEAN_NAME)
@ConditionalOnMissingBean(name = "SfaStepSummaryComponentExpandImpl")
@Slf4j
public class SfaStepSummaryComponent implements SfaVisitStepOffLineStrategy {

    private static String STEP_CODE;

    @Resource
    private SummaryVisitStepExecutor summaryVisitStepExecutor;


    /**
     * build 拜访步骤离线数据data
     *
     * @param reqVo
     * @return
     */
    @Override
    public Object buildVisitStepOffLineData(VisitOfflineReqVo reqVo) {
        ExecutorLoadReq loadReq = CrmBeanUtil.copy(reqVo, ExecutorLoadReq.class);
        SummaryStepExecuteDataResp dataResp = summaryVisitStepExecutor.load(loadReq);
        return dataResp;
    }

    /**
     * 保存拜访离线数据vo
     *
     * @param req
     */
    @Override
    public Result saveVisitStepOffLine(VisitStepOffLineExecuteReq req) {
        Result result = new Result();
        try {
            VisitStepExecuteReq<SummaryStepExecuteData> visitStepExecuteReq = CrmBeanUtil.copy(req, VisitStepExecuteReq.class);
            SummaryStepExecuteData executeData = JSONObject.parseObject(JSONObject.toJSONString(req.getStepExecuteData()),SummaryStepExecuteData.class);
            visitStepExecuteReq.setStepExecuteData(executeData);
            summaryVisitStepExecutor.executeOffLine(visitStepExecuteReq);
        }catch (BusinessException e){
            log.error("拜访总结错误信息:{}",e.getMsg());
            result.setSuccess(false);
            result.setMessage("拜访总结:错误信息["+e.getMsg()+"]");
        }
        return result;
    }


    @Override
    public void saveVisitStepOffLineFile(List<AttachmentOffLineVo> list, SfaVisitStepOffLineUtil util) {

    }

    @Override
    public String getStepCode() {
        return STEP_CODE;
    }

    @Override
    public void setStepCode(String stepCode) {
        this.STEP_CODE = stepCode;
    }
}
