package com.biz.crm.moblie.visitoffline.stepcomponent.photoutil;

import com.biz.crm.common.param.RedisParam;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.*;

/**
 * @author lf
 * @describe
 * @project crm
 * @package com.biz.crm.moblie.visitoffline.stepcomponent.photoutil
 * @date 2021/6/25 19:04
 */
@ApiModel("离线步骤拜访")
public class SfaVisitStepOffLineUtil implements SfaVisitStepOffLineBase, Serializable {

    private final static String SFA_VISIT_STEP_OFF_LINE_PHOTO = "SFA_VISIT_STEP_OFF_LINE_PHOTO";

    private final static String SFA_VISIT_OFF_LINE = "sfa_visit_off_line";

    public final static long REDIS_EXPIRE_TIME = 60 * 60 * 12;


    private List<String> photoKeyData;

    private String stepCode;

    private String visitPlanInfoId;

    private String type;

    private String typeName;

    private String actCode;

    private String sfaVisitOffLineKey;

    private String userName;

    private String posCode;

    public SfaVisitStepOffLineUtil(String stepCode, String visitPlanInfoId) {
        this.stepCode = stepCode;
        this.visitPlanInfoId = visitPlanInfoId;
    }

    public SfaVisitStepOffLineUtil(String offLinePhotoKey) {
        String[] keys = offLinePhotoKey.split(RedisParam.DELIMITER);
        List<String> keyList = Arrays.asList(keys);
        this.photoKeyData = keyList;
        this.visitPlanInfoId = keyList.get(1);
        this.stepCode = keyList.get(2);
        this.type = keyList.get(3);
        this.typeName = keyList.get(4);
        if (keyList.size()>=6){
            this.actCode = keyList.get(5);
        }
    }

    public SfaVisitStepOffLineUtil() {
        UserRedis userRedis = UserUtils.getUser();
        this.userName = userRedis.getUsername();
        this.posCode = userRedis.getPoscode();
    }

    /**
     * 获取离线数据照片key
     *
     * @param type
     * @param typeName
     * @return
     */
    public String getPhotoOffLineKey(String type, String typeName) {
        StringJoiner visitStepPhotoKey = new StringJoiner(RedisParam.DELIMITER);
        visitStepPhotoKey.add(SFA_VISIT_STEP_OFF_LINE_PHOTO).add(visitPlanInfoId).add(stepCode).add(type).add(typeName);
        return visitStepPhotoKey.toString();
    }


    /**
     * 获取离线数据照片key
     *
     * @param type
     * @param typeName
     * @return
     */
    public String getPhotoOffLineKey(String type, String typeName,String actCode) {
        StringJoiner visitStepPhotoKey = new StringJoiner(RedisParam.DELIMITER);
        visitStepPhotoKey.add(SFA_VISIT_STEP_OFF_LINE_PHOTO).add(visitPlanInfoId).add(stepCode).add(type).add(typeName).add(actCode);
        return visitStepPhotoKey.toString();
    }


    public String getRedisHashKey(String visitType) {
        String now = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        StringJoiner redisHashKey = new StringJoiner(RedisParam.DELIMITER);
        this.sfaVisitOffLineKey = redisHashKey.add(SFA_VISIT_OFF_LINE).add(visitType).add(userName).add(posCode).add(now).toString();
        return sfaVisitOffLineKey;
    }

    public Map<String, SfaVisitPlanInfoEntity> buildOffLineMap(String clientCode, String visitType, SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity) {
        String key = getFiled(clientCode, visitType);
        Map<String, SfaVisitPlanInfoEntity> map = new HashMap<>();
        map.put(key, sfaVisitPlanInfoEntity);
        return map;
    }

    public String getFiled(String clientCode, String visitType) {
        String now = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        StringJoiner key = new StringJoiner(RedisParam.DELIMITER);
        key.add(SFA_VISIT_OFF_LINE).add(visitType).add(userName).add(posCode).add(now).add(clientCode);
        return key.toString();
    }


    public List<String> getPhotoKeyData() {
        return photoKeyData;
    }

    @Override
    public String getStepCode() {
        return stepCode;
    }

    @Override
    public String getVisitPlanInfoId() {
        return visitPlanInfoId;
    }

    @Override
    public String getType() {
        return type;
    }

    @Override
    public String getTypeName() {
        return typeName;
    }

    @Override
    public String getActCode() {
        return actCode;
    }

    @Override
    public void setStepCode(String stepCode) {
        this.stepCode = stepCode;
    }

    @Override
    public void setVisitPlanInfoId(String visitPlanInfoId) {
        this.visitPlanInfoId = visitPlanInfoId;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Override
    public void setActCode(String actCode) {
        this.actCode = actCode;
    }

    @Override
    public void setPhotoKeyData(List<String> photoKeyData) {
        this.photoKeyData = photoKeyData;
    }
}
