package com.biz.crm.mqconsumer;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.eunm.tpm.ActSendMessageTypeEnum;
import com.biz.crm.mq.AbstractRocketMQConsumer;
import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.nebular.tpm.act.req.TpmActSendMessageVo;
import com.biz.crm.tpmact.service.ISfaTpmActService;
import com.biz.crm.util.JsonPropertyUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Description: excel-export 监听消息
 * @project：crm
 * @package：com.biz.crm.excel.consumer
 * @author：lifei
 * @create：2020/12/10 10:41 上午
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = "${rocketmq.topic}" + "${rocketmq.environment-variable}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag定义在 RocketMQConstant.CRM_MQ_TAG 内统一维护
        */
        selectorExpression = RocketMQConstant.CRM_MQ_TAG.TPM_ACT_APPROVED_AND_CLOSED,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup定义在 RocketMQConstant.CONSUMER_GROUP 内统一维护
        */
        consumerGroup = RocketMQConstant.CONSUMER_GROUP.TPM_ACT_APPROVED_AND_CLOSED + "${rocketmq.environment-variable}",
        /**
         * 默认集群消费， 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.ORDERLY)
public class TpmActivityConsumer extends AbstractRocketMQConsumer {

    @Autowired
    private ISfaTpmActService sfaTpmActService;

    //获取消息
    @Override
    protected Object handleMessage(RocketMQMessageBody message) throws InterruptedException {
        String result = message.getMsgBody();
        log.warn("接收消息:{}",result);
        JSONObject jsonObject = JSONObject.parseObject(result);
        TpmActSendMessageVo tpmActSendMessageVo = JsonPropertyUtil.toObject(jsonObject,TpmActSendMessageVo.class);
        if (null != tpmActSendMessageVo && null != tpmActSendMessageVo.getType()){
            if (tpmActSendMessageVo.getType().equals(ActSendMessageTypeEnum.APPROVED.getCode())){
                sfaTpmActService.saveTpmAct(tpmActSendMessageVo.getActId());
                return "活动审批通过传输成功!";
            }else if (tpmActSendMessageVo.getType().equals(ActSendMessageTypeEnum.CLOSED.getCode())){
                sfaTpmActService.closedTpmAct(tpmActSendMessageVo.getActId());
                return "活动关闭传输成功";
            }else if (tpmActSendMessageVo.getType().equals(ActSendMessageTypeEnum.ALL_AUDIT.getCode())){
                sfaTpmActService.allAudit(tpmActSendMessageVo.getActId());
                return "活动明细核销传输成功!";
            }
        }
        return "活动传输成功!";
    }
}
