package com.biz.crm.notice.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.notice.req.SfaNoticeReadReqVo;
import com.biz.crm.nebular.sfa.notice.resp.SfaNoticeReadRespVo;
import com.biz.crm.notice.service.ISfaNoticeReadService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 公告读取信息 
 *
 * @author liuhongming
 * @date 2020-09-17 19:12:50
 */
@Slf4j
@RestController
@RequestMapping("/sfaNoticeReadController")
@Api(tags = "公告读取信息 ")
public class SfaNoticeReadController {
    @Autowired
    private ISfaNoticeReadService sfaNoticeReadService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaNoticeReadRespVo>> list(@RequestBody SfaNoticeReadReqVo sfaNoticeReadReqVo) {
        PageResult<SfaNoticeReadRespVo> result=sfaNoticeReadService.findList(sfaNoticeReadReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaNoticeReadRespVo> query(@RequestBody SfaNoticeReadReqVo sfaNoticeReadReqVo) {
        SfaNoticeReadRespVo respVo=sfaNoticeReadService.query(sfaNoticeReadReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "公告读取新增",httpMethod = "GET")
    @GetMapping("/readSign")
    @CrmLog
    public Result save(@RequestParam("noticeCode") String noticeCode) {
        sfaNoticeReadService.save(noticeCode);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaNoticeReadReqVo sfaNoticeReadReqVo) {
        sfaNoticeReadService.update(sfaNoticeReadReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        sfaNoticeReadService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        sfaNoticeReadService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        sfaNoticeReadService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
}
