package com.biz.crm.notice.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.notice.service.ISfaNoticeReceivingService;
import com.biz.crm.nebular.sfa.notice.resp.SfaNoticeReceivingRespVo;
import com.biz.crm.nebular.sfa.notice.req.SfaNoticeReceivingReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.List;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 公告发布范围 
 *
 * @author liuhongming
 * @date 2020-09-17 17:14:43
 */
@Slf4j
@RestController
@RequestMapping("/sfaNoticeReceivingController")
@Api(tags = "公告发布范围 ")
public class SfaNoticeReceivingController {
    @Autowired
    private ISfaNoticeReceivingService sfaNoticeReceivingService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaNoticeReceivingRespVo>> list(@RequestBody SfaNoticeReceivingReqVo sfaNoticeReceivingReqVo) {
        PageResult<SfaNoticeReceivingRespVo> result=sfaNoticeReceivingService.findList(sfaNoticeReceivingReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaNoticeReceivingRespVo> query(@RequestBody SfaNoticeReceivingReqVo sfaNoticeReceivingReqVo) {
        SfaNoticeReceivingRespVo respVo=sfaNoticeReceivingService.query(sfaNoticeReceivingReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaNoticeReceivingReqVo sfaNoticeReceivingReqVo) {
        sfaNoticeReceivingService.save(sfaNoticeReceivingReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaNoticeReceivingReqVo sfaNoticeReceivingReqVo) {
        sfaNoticeReceivingService.update(sfaNoticeReceivingReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        sfaNoticeReceivingService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        sfaNoticeReceivingService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        sfaNoticeReceivingService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
}
