package com.biz.crm.notice.mapper;

import com.biz.crm.nebular.sfa.notice.req.SfaNoticeMiniReqVo;
import com.biz.crm.notice.model.SfaNoticeEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;
import org.apache.ibatis.annotations.Mapper;
import com.biz.crm.nebular.sfa.notice.resp.SfaNoticeRespVo;
import com.biz.crm.nebular.sfa.notice.req.SfaNoticeReqVo;
import java.util.List;
import java.util.Map;

/**
 * 公告管理 
 * 
 * @author liuhongming
 * @date 2020-09-17 17:14:42
 */
public interface SfaNoticeMapper extends BaseMapper<SfaNoticeEntity> {
    /**
     * 列表
     * @param page
     * @param sfaNoticeReqVo
     * @return
     */
    List<SfaNoticeRespVo> findList(Page<SfaNoticeRespVo> page, @Param("vo") SfaNoticeReqVo sfaNoticeReqVo);

    /**
     * 删除
     * @param sfaNoticeReqVo
     */
    void deleteProductsByParams(@Param("vo") SfaNoticeReqVo sfaNoticeReqVo);

    /**
     * 小程序公告列表
     * @param page
     * @param sfaNoticeReqVo
     * @return
     */
    List<SfaNoticeRespVo> findListMiniPrg(Page<SfaNoticeRespVo> page, @Param("vo") SfaNoticeMiniReqVo sfaNoticeReqVo);

    /**
     * 小程序详情
     * @param id
     * @return
     */
    SfaNoticeRespVo queyMimiPrg(@Param("id") String id);

    /**
     * 查询上一页/下一页
     * @param id
     * @param upStatus
     * @return
     */
    String queryMinPrgUpOrBelow(@Param("id") String id, @Param("upStatus") String upStatus, @Param("orgCode") String orgCode);


}
