package com.biz.crm.notice.mapper;

import com.biz.crm.notice.model.SfaNoticeReadEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;
import org.apache.ibatis.annotations.Mapper;
import com.biz.crm.nebular.sfa.notice.resp.SfaNoticeReadRespVo;
import com.biz.crm.nebular.sfa.notice.req.SfaNoticeReadReqVo;
import java.util.List;
import java.util.Map;

/**
 * 公告读取信息 
 * 
 * @author liuhongming
 * @date 2020-09-17 19:12:50
 */
public interface SfaNoticeReadMapper extends BaseMapper<SfaNoticeReadEntity> {
    /**
     * 列表
     * @param page
     * @param sfaNoticeReadReqVo
     * @return
     */
    List<SfaNoticeReadRespVo> findList(Page<SfaNoticeReadRespVo> page, @Param("vo") SfaNoticeReadReqVo sfaNoticeReadReqVo);

    /**
     * 根据notice_code 当前职位和账号 查询公告是否已读
     * @param notices
     * @return
     */
    @MapKey("notice_code")
    Map<String,Object> findIsItRight(@Param("notices") List<String> notices, @Param("userName") String userName, @Param("thisPost") String thisPost, @Param("thisOrg") String thisOrg);

    /**
     * 查是否存在
     * @param req
     * @return
     */
    Integer findReadSignCount(@Param("vo") SfaNoticeReadReqVo req);

}
