package com.biz.crm.notice.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 公告读取信息 实体类
 *
 * @author liuhongming
 * @date 2020-09-17 19:12:50
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_notice_read")
@CrmTable(name = "sfa_notice_read", tableNote = "公告读取信息")
public class SfaNoticeReadEntity extends CrmExtTenEntity<SfaNoticeReadEntity> {

    /**
     * 读取人账号 读取人账号
     */
    @CrmColumn(name = "user_name", length = 32, note = "读取人账号 读取人账号")
    private String userName;

    /**
     * 读取人岗位 读取人岗位
     */
    @CrmColumn(name = "pos_code", length = 32, note = "读取人岗位 读取人岗位")
    private String posCode;

    /**
     * 公告编码 公告编码
     */
    @CrmColumn(name = "notice_code", length = 32, note = "公告编码 公告编码")
    private String noticeCode;

}
