package com.biz.crm.notice.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 公告发布范围 实体类
 *
 * @author liuhongming
 * @date 2020-09-17 17:14:43
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_notice_receiving")
@CrmTable(name = "sfa_notice_receiving", tableNote = "公告发布范围")
public class SfaNoticeReceivingEntity extends CrmExtTenEntity<SfaNoticeReceivingEntity> {

    /**
     * 编码 编码
     */
    @CrmColumn(name = "receiving_code", length = 32, note = "编码 编码")
    private String receivingCode;

    /**
     * 名称 名称
     */
    @CrmColumn(name = "receiving_name", length = 100, note = "名称 名称")
    private String receivingName;

    /**
     * 范围类型 范围类型(10:当前组织;20:当前组织及下级组织)
     */
    @CrmColumn(name = "receiving_type", length = 32, note = "范围类型 范围类型(10:当前组织;20:当前组织及下级组织)")
    private String receivingType;

    /**
     * 公告编码 公告编码
     */
    @CrmColumn(name = "notice_code", length = 32, note = "公告编码 公告编码")
    private String noticeCode;

}
